﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace TowerDefence
{
    public class RefreshedEventArgs : EventArgs
    {
        public Bitmap Screen { get; private set; }
        public RefreshedEventArgs(Bitmap screen)
        {
            Screen = screen;
        }
    }

    interface IView : IDisposable
    {
        Bitmap Screen { get; }

        Size Size { get; }

        Size MazeSize { get; }

        event EventHandler<RefreshedEventArgs> Refreshed;

        void Start();

        void Add(BaseObject baseObject);
        void Add(IEnumerable<BaseObject> baseObjects);

        void Remove(BaseObject unit);

        PointF TransformMazeToScreen(PointF coordinates);

        PointF TransformScreenToMaze(PointF coordinates);
    }
}
