/**
 * projekt.js
 * 
 * @author Johannes Michl
 * 
 */

$(document).ready(function() {
	initialzieWebPage();
});

/*******************************************************************************
 * PARAMS
 ******************************************************************************/
var activeGame = false;
var p1Nam = 'Lisa'; // player = X
var p2Nam = 'Peter'; // player = O
var columns = 10;
var rows = 6;
var player;
var winner;
var hColor;
var count = 1;
var fallheight;
var jSize = 75;
var spielfeld;
var gleiche;
var pointer;
var pointer2;

/*******************************************************************************
 * INITIALIZE WEBPAGE AND HTML-ELEMENTS
 ******************************************************************************/

/**
 * Baut die Webseite mit all ihren Elementen und Tags auf
 */
function initialzieWebPage() {
	// Start Menue
	$('<div id="resumeGame" onclick="showGame();"><p>Resume Game</p></div>')
			.appendTo('body').hide();
	$('<div class="menue" onclick="startGame();"><p>New Game</p></div>')
			.appendTo('body');
	$('<div class="menue" onclick="showSettings();"><p>Settings</p></div>')
			.appendTo('body');

	// Settings
	$('<div id="sett"></div>').appendTo('body').hide();
	$('<label class="settings">Spieler 1 </label>').appendTo('#sett').hide();
	$('<input class="settings" id="player1" value="Lisa"></br>').appendTo(
			'#sett').hide();
	$('<label class="settings">Spieler 2 </label>').appendTo('#sett').hide();
	$('<input class="settings" id="player2" value="Peter"></br>').appendTo(
			'#sett').hide();
	$('<label class="settings" id="sUz" >Spalten x Zeilen</label>').appendTo(
			'#sett').hide();
	$(
			'<input class="settings" id="spalten" type="number" value = "10" min="5" max="15"/>')
			.appendTo('#sett').hide();
	$(
			'<input class="settings" id="zeilen" type="number" value = "6" min="5" max="15"/></br>')
			.appendTo('#sett').hide();
	$(
			'<div class="settings" id="settingsBack" onclick="HideSettings();"><p>OK</p></div>')
			.appendTo('#sett').hide();

}

/*******************************************************************************
 * HIDE and SHOW - functions
 ******************************************************************************/

/**
 * Bringt die Einstellungen in den Hintergrund
 */
function HideSettings() {
	p1Nam = $('#player1').val();
	p2Nam = $('#player2').val();
	columns = parseInt($('#spalten').val());
	rows = parseInt($('#zeilen').val());
	$('.settings').hide();
	$('#sett').hide();
	showMenue();
}

/**
 * Bringt die Einstellungen in den Vordergrund
 */
function showSettings() {
	HideMenue();
	$('.settings').show();
	$('#sett').show();
}

/**
 * Bringt das Spielfeld in den Hintergrund
 */
function hideGameField() {
	$('.gameField').hide();
	$('.navElm').hide();
	showMenue();
}

/**
 * Bringt das Spielfeld in den Vordergrund
 */
function showGame() {
	HideMenue();
	$('.gameField').show();
	$('.navElm').show();
	$('#backToMenue').show();
}

/**
 * Bringt das Hauptmenue in den Hintergrund
 */
function HideMenue() {
	$('#resumeGame').hide();
	$('.menue').hide();
}

/**
 * Bringt das Hauptmenue in den Vordergrund
 */
function showMenue() {
	if (activeGame)
		$('#resumeGame').show();
	$('.menue').show();
}

/*******************************************************************************
 * GAME - Functions
 ******************************************************************************/

/**
 * Startet das Spiel
 */
function startGame() {

	if (activeGame)
		destroyGame();

	activeGame = true;
	HideMenue();
	VisualizeField(rows, columns);
	InitializeField(rows, columns);
	setFallheight(rows);
	setHover(getPlayer());
}

/**
 * Wird aufgerufen wenn ein Gewinner feststeht. Startet ein neues Spiel.
 */
function gameReady() {
	$('.winSc').remove();
	destroyGame();
	VisualizeField(rows, columns);
	InitializeField(rows, columns);
	setFallheight(rows);
	setHover(getPlayer());
}

/**
 * Beendet das aktuelle Spiel
 */
function destroyGame() {
	$('.gameField').remove();
	$('.navElm').remove();
}

/**
 * Wird aufgerufen wenn ein Stein gesetzt werden soll bzw. eine Spalte
 * angeklickt wird.
 * 
 * @param colNum - ID der Spalte welche angeklickt wurde
 */
function clickColumn(colNum) {
	// numJetInCol = Anzahl an Jettons die berteits in der Spalte liegen
	var numJetInCol = setStone(colNum, player);
	if (numJetInCol !== undefined) {
		dropJetton(colNum, numJetInCol, player);
		if (GotWinner(numJetInCol, colNum, player)) {

			if (player == 'O')
				winner = p1Nam;
			else
				winner = p2Nam;

			$('<div class="winSc" id="overlay">').appendTo('body');
			$(
					'<div class="winSc" id="winner"><p>Spieler ' + winner
							+ ' gewinnt die Partie!</p></div>')
					.appendTo('body');
			$(
					'<div class="winSc" id="btWin" onclick="gameReady()"><p>OK</p></div>')
					.appendTo('#winner');
		}
	} else
		alert('Die Spalte ist bereits voll!');

	player = getPlayer();
	setHover(player);
}

/**
 * Gibt den Spieler zurück welcher aktuell am Zug ist
 * 
 * @return player - Spieler der aktuell am Zug ist
 */
function getPlayer() {
	if (count % 2 == 0)
		player = 'X';
	else
		player = 'O';

	return player;
}

/**
 * Legt fest welche Farbe der aktuelle Stein hat.
 * 
 * @param player - Spieler der aktuell am Zug ist
 */
function setHover(player) {
	if (player == 'X')
		hColor = 'url(img/bullet_ball_glass_yellow.png) no-repeat center center';
	else
		hColor = 'url(img/bullet_ball_glass_red.png) no-repeat center center';

	$('.navElm').hover(function() {
		$(this).css({
			'background' : hColor,
			'border-radius' : '75px'
		});
	}, function() {
		var cssObj = {
			'background-image' : 'none',
		}
		$(this).css(cssObj);
	});
}

/**
 * Setzt die Fallhöhe des zu setzenden Steins.
 * 
 * @param rows
 */
function setFallheight(rows) {
	fallheight = jSize * (rows - 1);
}

/**
 * Berechnet die Fallhöhe des aktuellen Steins.
 * 
 * @param numJetInCol
 * @return fall
 */
function calculateFallheight(numJetInCol) {
	var fall = fallheight - (jSize * numJetInCol);
	return fall;
}

/**
 * Animation um den zu setzenden Stein fallen zu lassen.
 * 
 * @params 	colNum
 * 			numJetInCol
 * 			player
 */
function dropJetton(colNum, numJetInCol, player) {
	fall = calculateFallheight(numJetInCol);
	var jet = $('<div id="jetton' + count + '" class="jetton' + player + '">')
			.css({
				marginLeft : jSize * (colNum)
			}).appendTo('#rasterfeld');
	jet.animate({
		"top" : "+=" + fall + "px"
	}, "slow");
	count++;
}

/**
 * Visualisiert das Spielfeld
 * 
 * @param 	rows
 * 			columns
 */
function VisualizeField(rows, columns) {
	var width = columns * jSize;
	var height = rows * jSize;

	$('<div class="gameField" id="score"></div>').appendTo('body');
	$(
			'<div class="gameField" id="P1"><img src="img/bullet_ball_glass_red.png"><p>'
					+ p1Nam + '</p></div>').appendTo('#score');
	$('<div class="gameField" id="VS"><p> VS </p></div>').appendTo('#score');
	$(
			'<div class="gameField" id="P2"><p>' + p2Nam
					+ '</p><img src="img/bullet_ball_glass_yellow.png"></div>')
			.appendTo('#score');

	// div-Container fuer die select-boxen
	$('<div class="gameField" id="navigation">').css({
		margin : '0px auto',
		width : width,
		height : jSize
	}).appendTo('body');
	for ( var i = 0; i < columns; i++) {
		$(
				'<div class="navElm" id="col' + i + '"onClick="clickColumn('
						+ i + ');">').css({
			width : jSize,
			height : jSize,
			border : '1px transparent',
			float : 'left',
			'z-index' : 1
		}).appendTo('#navigation');
	}

	$('<div class="gameField" id="rasterfeld">').css({
		margin : '0px auto',
		width : width,
		height : height,
		border : '1px solid',
		position : 'relative'
	}).appendTo('body');
	$('<div class="gameField" id="schablone">').css({
		background : 'url(img/leer.png)',
		position : 'absolute',
		width : width,
		height : height,
		'z-index' : 1
	}).appendTo('#rasterfeld');
	$('<div class="gameField" id="wand">').css({
		'background-color' : '#022467',
		position : 'absolute',
		width : width,
		height : height,
		'z-index' : 0
	}).appendTo('#rasterfeld');
	$(
			'<div id="backToMenue" class="gameField" onClick="hideGameField();"><p>Back</p></div>')
			.appendTo('body');

}

/*******************************************************************************
 * Rechenoperationen - laufen im Hintergrund ab, nicht sichtbar
 ******************************************************************************/

/**
 * Erstellt im Hintergrund ein mehrdimensionales Array, welches dem Spielfeld
 * entspricht.
 * 
 * @param 	rows
 * 			columns
 */
function InitializeField(rows, columns) {
	spielfeld = new Array(columns);
	for ( var i = 0; i < spielfeld.length; i++) {
		spielfeld[i] = new Array(rows);
	}
}

/**
 * Setzt einen Stein im Spielfeld(mehrdimensionalen Array).
 * 
 * 	@param 	colNum
 * 			player
 */
function setStone(colNum, player) {
	// durch die Spalte gehen und schauen an welcher stelle ein platz frei ist
	for ( var i = 0; i < spielfeld[colNum].length; i++) {
		// wenn Spielfeld an der stelle 'leer' ist, zeichen ablegen und aus der
		// schleife springen
		if (spielfeld[colNum][i] == undefined) {
			spielfeld[colNum][i] = player;
			return i;
		}

	}
}

/**
 * Überprüft, ob ein Gewinner feststeht.
 * 
 * @param	i
 * 			colNum
 * 			player
 * @return straight||length||topRight||topLeft (true wenn 4 gleiche in einer Reihe)
 */
function GotWinner(i, colNum, player) {
	var straight = checkColumn(i, colNum, player);
	var length = checkRow(i, colNum, player);
	var topRight = diagonalRight(i, colNum, player);
	var topLeft = diagonalLeft(i, colNum, player);

	return (straight || length || topRight || topLeft);
}

/**
 * Überprüft auf vier in einer Diagonalen.
 * 
 * @param	row
 * 			colNum
 * 			player
 * @return	boolean (true wenn 4 gleiche in einer Reihe)
 */
function diagonalLeft(row, colNum, player) {
	gleiche = 1;

	// links oben
	pointer = colNum - 1;
	pointer2 = row + 1;
	while (pointer >= 0 && pointer2 <= spielfeld[colNum].length) {
		if (spielfeld[pointer][pointer2] != player)
			break;
		else {
			gleiche++;
			pointer--;
			pointer2++;
		}
	}

	// links unten
	pointer = colNum - 1;
	pointer2 = row - 1;
	while (pointer >= 0 && pointer2 >= 0) {
		if (spielfeld[pointer][pointer2] != player)
			break;
		else {
			gleiche++;
			pointer--;
			pointer2--;
		}
	}
	return (gleiche > 3);
}

/**
 * Überprüft auf vier gleiche in einer Diagonalen.
 * 
 * @param	row
 * 			colNum
 * 			player
 * @return	boolean (true wenn 4 gleiche in einer Reihe)
 */
function diagonalRight(row, colNum, player) {
	gleiche = 1;

	// rechts oben
	pointer = colNum + 1;
	pointer2 = row + 1;
	while (pointer <= spielfeld.length && pointer2 <= spielfeld[colNum].length) {
		if (spielfeld[pointer][pointer2] != player)
			break;
		else {
			gleiche++;
			pointer++;
			pointer2++;
		}
	}

	// rechts unten http://palulukan.servegame.com/game
	pointer = colNum + 1;
	pointer2 = row - 1;
	while (pointer <= spielfeld.length && pointer2 >= 0) {
		if (spielfeld[pointer][pointer2] != player)
			break;
		else {
			gleiche++;
			pointer++;
			pointer2--;
		}
	}
	return (gleiche > 3);
}

/**
 * Überprüft auf vier gleiche in einer Spalte.
 * 
 * @param	i
 * 			colNum
 * 			player
 * @return	boolean (true wenn 4 gleiche in einer Reihe)
 */
function checkColumn(i, colNum, player) {
	gleiche = 1;

	// suche nach unten
	pointer = i - 1;
	while (pointer >= 0) {
		if (spielfeld[colNum][pointer] != player)
			break;
		else {
			gleiche++;
			pointer--;
		}
	}

	// nach oben suchen
	pointer = i + 1;
	while (pointer <= spielfeld[colNum].length) {
		if (spielfeld[colNum][pointer] != player)
			break;
		else {
			gleiche++;
			pointer++;
		}
	}

	return (gleiche > 3);
}

/**
 * Überprüft auf vier gleiche in einer Reihe.
 * 
 * @param	i
 * 			colNum
 * 			player
 * @return	boolean (true wenn 4 gleiche in einer Reihe)
 */
function checkRow(i, colNum, player) {
	gleiche = 1;

	// suche nach rechts
	pointer = colNum + 1;
	while (pointer < spielfeld.length) {
		if (spielfeld[pointer][i] != player)
			break;
		else {
			gleiche++;
			pointer++;
		}
	}
	// nach links
	pointer = colNum - 1;
	while (pointer >= 0) {
		if (spielfeld[pointer][i] != player)
			break;
		else {
			gleiche++;
			pointer--;
		}
	}
	return (gleiche > 3);
}
