
$(function() {
	
	
	
	var a = [];
	var woerter = [], 
		zufallszahl, zaehlerFalsche = 0, boolFalsch, neuesWort, buchstabe;
	var c = $('#canvas')[0].getContext('2d');
	var alphabet = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];
	
	//Canvas-Animations-Variablen:
	var beinLineWidth = 20, grad = 90, h = 292, hebelVariable = 1, buchstabenNummer; //Höhe
    
    neuesWort = ypassRandWord.word;
    var wortArray = neuesWort.split(' ');
    for(var i = 0; i < wortArray.length; i++) {
    	woerter.push(wortArray[i].toLowerCase().replace('-',''));
    }
    console.log(woerter);
    
    
    
    
    init();
    //Zum einmal starten:
	draw();
	
	
	setTimeout(zufallswort(), 200);
	
	function init() {
		$('#wrong').html('Falsche Antworten: ');
		
		for(var i = 0; i < 26; i++) {
			$('<div>').text(alphabet[i]).css({'float':'left', 'border':'solid 1px black', 'width': '50px', 'height':'20px', 'text-align':'center'}).attr({'id':'buchstabe'+alphabet[i], 'class':'buchstabenDiv'}).appendTo('#drunter');
		}
		
		$('.buchstabenDiv').each(function(i, v) {
				$(v).click(function() {
					console.log('Ich bin im Click');
					buchstabe = $(v).text();	
					raten();
				});
		});

		
	}
	
	
	
	function zufallswort() {
		$('#spieldfeld').text('').attr({'position':'absolute', 'bottom':'10'});
		
		zufallszahl = Math.floor(Math.random() * woerter.length);
		console.log('Zufallszahl: ' + zufallszahl + ' Zufallswort ' + woerter[zufallszahl])
		for(var i = 0; i < woerter[zufallszahl].length; i++) {
			$('#spielfeld').append('_ ');
			a[i]='_ ';
		}
	}
		
	function raten() {	


		if(zaehlerFalsche < 7) {
		
			boolFalsch = false;
			
			
			for(var i = 0; i < woerter[zufallszahl].length; i++) {
				if(woerter[zufallszahl].charAt(i) === buchstabe) {
					a[i]=buchstabe;
					boolFalsch = true;
				}
			}
			
			if(!boolFalsch) {
				zaehlerFalsche++;
				hebelVariable += 0.055;
				draw();
				$('#wrong').append(buchstabe + ', ');
				console.log('Falsche Buchstabentipps bisher: ' + zaehlerFalsche);
				
			}
			
			$('#spielfeld').text(a.toString().replace(/[,]/g, ''));
			
			if(a.toString().replace(/[,]/g, '') === woerter[zufallszahl]) {
				$('#spielfeld').text('Super! "' + woerter[zufallszahl] + '" war die richtige Lösung!');
				playAudio();
				setTimeout(fertig, 2000);
			}
			
		}
		
		if(zaehlerFalsche === 7) {
			fallen();
			$('#spielfeld').text('"' + woerter[zufallszahl] + '" wäre die richtige Lösung gewesen!');
			playAudio();
			setTimeout(fertig, 2000);
		}
	}
	
	
	function fertig() {
		
		console.log('Ich bin in der fertig-Methode');
		
		$('#all').css({'opacity':'0.3'});
		$('#spielfeld').css({'opacity':'0.3'});
		$('.buchstabenDiv').css({'opacity':'0.3'});
		
		$('<button>').text('Neu starten!').css({'width':'200px', 'height':'80px', 'border':'solid 1px black', 'text-align':'center'}).attr({'id':'neuButton'}).appendTo('#drunter');
		$('#neuButton').click(function() {
			window.location.reload();
		});
	}
	
	
	function playAudio() {
		console.log('playAudio');
		var a = $('#audio')[0];
		a.currentTime = 0;
		a.play();
	}
	
	
	function neuLaden() {
		window.location.reload();
	}
	
	
	
	
	
	function draw() {
	
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);  // Clear the (displayed) canvas to avoid errors
	    c.save();  
	    drawHebel();
	    drawWood();
	    drawBalken();
	    drawHead();
	    drawBody();
	    drawVictim();
	    drawCord();
	    drawTrap();
	    c.restore();
    }
    
    function drawHebel() {
    	//alert('bin in drawhebel');
    	c.save();
    	
    	c.lineWidth = 7;
    	c.strokeStyle = "#000000";
    	c.font = "18px Arial";
    	
    	c.fillText('H', 66, 310);
    	c.fillText('A', 63, 327);
    	c.fillText('N', 60, 344);
    	c.fillText('G', 57, 361);
    	c.fillText('M', 54, 378);
    	c.fillText('A', 51, 395);
    	c.fillText('N', 48, 412);
    	c.beginPath();
    	c.moveTo(220, 430);
    	c.lineTo(80, 310 * hebelVariable);
    	c.stroke();
    	c.closePath();
    	
    	c.restore();
    	
    }
    
    function drawWood() {
		//Holzfläche malen
		c.lineWidth = 7;    
		c.strokeStyle = '#934F01';     	// Zeichenfarbe setzen
	
		c.beginPath();
	    c.moveTo(0,430);
		c.lineTo(c.canvas.width-208,430);
		c.stroke();
		c.closePath();
		
		c.beginPath();
		c.moveTo(c.canvas.width-137,430);
		c.lineTo(c.canvas.width,430);
		c.stroke();
		c.closePath();
		
		c.strokeStyle='#A7A7A7';
		c.lineWidth = 5;
		c.beginPath();
		c.moveTo(c.canvas.width-208,427);
		c.lineTo(c.canvas.width-208,433);
		c.stroke();
		c.closePath();
	}
	
    
    function drawBalken() {
	    c.strokeStyle = '#000000';     	// Zeichenfarbe setzen
	    c.lineWidth = 10;
	    
	    //Startpunkt nach rechts unten
		c.beginPath();
	    c.moveTo(c.canvas.width/2,430);
		c.lineTo(c.canvas.width/2+50,480);
		c.stroke();
		c.closePath();
	    
	    //Startpunkt nach links unten
		c.beginPath();
	    c.moveTo(c.canvas.width/2,430);
		c.lineTo(c.canvas.width/2-50,480);
		c.stroke();
		c.closePath();
	    
	    //Startpunkt nach unten
		c.beginPath();
	    c.moveTo(c.canvas.width/2,430);
		c.lineTo(c.canvas.width/2,480);
		c.stroke();
		c.closePath();
	    
	    //Senkrechten Balken zeichnen
		c.beginPath();
	    c.moveTo(c.canvas.width/2,430);
		c.lineTo(c.canvas.width/2,200);
		c.stroke();
		c.closePath();
	    
	    //Waagrechten Balken zeichnen
		c.beginPath();
	    c.moveTo(c.canvas.width/2-5,200);
		c.lineTo(c.canvas.width/2+143,200);
		c.stroke();
		c.closePath();
	    
	    //Hängebalken zeichnen
		c.beginPath();
	    c.moveTo(c.canvas.width/2+138,200);
		c.lineTo(c.canvas.width/2+138,240);
		c.stroke();
		c.closePath();
	}
	
	
	
	function drawHead() {
		//Kopf malen
		c.save();
		
		c.fillStyle = "#522D03";
		c.strokeStyle = "#522D03";
		
		c.beginPath();
		c.translate(-22 * (1 - grad / 90), 0);
		c.arc(c.canvas.width/2+148, h-2, 15, 0, 2*Math.PI);			//arc(x,y,r,start,stop)
		c.fill();
		c.closePath();			
		
		//Hals malen
		
		c.lineWidth = 16;
		
		c.beginPath();
		c.moveTo(c.canvas.width/2+149, h+11);
		c.lineTo(c.canvas.width/2+149, h+14);
		c.stroke();
		c.closePath();
		
		c.restore();
	}
	
	function drawBody() {
		//Körper malen
		c.fillStyle = "#522D03";
		c.strokeStyle = "#522D03";
		c.lineWidth = 6;
		c.save();
		c.beginPath();
		c.translate(c.canvas.width/2+133, h+13);
		c.rotate(Math.PI*(grad-90) / (33*90));
		c.translate(-18 * (1 - grad / 90), 0);
		c.moveTo(-2-grad*3/90,56);
		c.lineTo(-2-grad*3/90,8);
		c.lineTo(3+grad*3/90,3);
		c.lineTo(27+grad*3/90,3);
		c.lineTo(32+grad*3/90,8);
		c.lineTo(32+grad*3/90,56);
		c.lineTo(-4-grad*3/90,56);
		c.stroke();
		c.fill();
		c.closePath();
		c.restore();
	}
	
	
	function drawVictim() {
		c.save();			
		// 					Arme malen
		//Rechter Oberarm
		c.translate(-16 * (1 - grad / 90), 2);
		c.lineWidth = 13;
		c.beginPath();
		c.moveTo(c.canvas.width/2+160,h+20);
		c.lineTo(c.canvas.width/2+181,h+42);
		c.stroke();
		c.closePath();
		//Rechter Unterarm
		c.beginPath();
		c.lineWidth = 10;
		c.moveTo(c.canvas.width/2+181,h+37);
		c.lineTo(c.canvas.width/2+176,h+70);
		c.stroke();
		c.closePath();
		
		c.restore();
		
		//Linker Oberarm
		c.save();
		c.lineWidth = 13;
		c.beginPath();
		c.translate(17 * (1 - grad / 90), 0);
		c.moveTo(c.canvas.width/2+135,h+20);
		c.lineTo(c.canvas.width/2+117,h+38);
		c.stroke();
		c.closePath();
		//Linker Unterarm
		c.beginPath();
		c.lineWidth = 10;
		c.moveTo(c.canvas.width/2+117,h+32);
		c.lineTo(c.canvas.width/2+122,h+70);
		c.stroke();
		c.closePath();
		c.restore();
		
		//				Beine malen
		//Rechtes Bein
		c.save();
		c.lineWidth = beinLineWidth;
		c.translate(-11 * (1 - grad / 90), 0);
		c.beginPath();
		c.moveTo(c.canvas.width/2+160,h+70);
		c.lineTo(c.canvas.width/2+159,h+135);
		c.stroke();
		c.closePath();
		//Linkes Bein
		c.translate(2 * (1 - grad / 90), 0);
		c.beginPath();
		c.moveTo(c.canvas.width/2+136,h+70);
		c.lineTo(c.canvas.width/2+135,h+135);
		c.stroke();
		c.closePath();
		c.restore();
	}
	
	
	function drawCord() {
	// Seil malen
		c.strokeStyle = '#EBB272';
		c.save();
		c.lineWidth = 2;    
		c.beginPath();
		c.translate(-22 * (1 - grad / 90), 0);
	    c.moveTo(c.canvas.width/2+140,h+13);
		c.lineTo(c.canvas.width/2+156,h+11);
		c.stroke();
		c.closePath();
		c.restore();
		
		
		c.save();
		c.lineWidth = 3;
		c.beginPath();
	    c.moveTo(c.canvas.width/2+156 - 20 * (1 - grad / 90), h+11);
		c.lineTo(c.canvas.width/2+135,235);
		c.stroke();
		c.closePath();
		c.restore();
		
		c.beginPath();
		c.lineWidth = 5;
		c.moveTo(c.canvas.width/2+135,235);
		c.lineTo(c.canvas.width/2+142,235);
		c.stroke();
		c.closePath();
		
	}
    
    
    function drawTrap() {
    	c.save();
    	c.lineWidth = 7;    
		c.strokeStyle = '#934F01'; 
		
		c.beginPath();
        c.translate(c.canvas.width-207, 430);
		c.rotate((0.5 - grad / 180) * Math.PI);
		c.moveTo(0,0);
		c.lineTo(69,0);
		c.stroke();
		c.closePath();
		
		c.restore();
    }
    
    
    
    function fallen() {
    	var tot = setInterval(function() {
    		if(grad > 0) {
    			grad--;
    			h += 0.08;
    			beinLineWidth -= 5/90;
    			draw();
    		} else {
    			clearInterval(tot);
    		}
    	}, 1);
    	console.log(woerter[zufallszahl] + ' wäre die Lösung gewesen!');
    }
    
    
	
});
