var ryuSprites = {
	image : createImage('Ryu.gif'),
	sprites : {
		'start' : {
			width : 145,
			height : 120,
			x : 0,
			y : 0,
			sprites : 9
		},
		'startleft' : {
			width : -145,
			height : 120,
			x : 2610,
			y : 0,
			sprites : 9
		},
		'stand' : {
			width : 145,
			height : 120,
			x : 0,
			y : 121,
			sprites : 5
		},
		'standleft' : {
			width : -145,
			height : 120,
			x : 1450,
			y : 121,
			sprites : 5
		},
		'jump' : {
			width : 145,
			height : 120,
			x : 0,
			y : 241,
			sprites : 7
		},
		'jumpleft' : {
			width : -145,
			height : 120,
			x : 2030,
			y : 241,
			sprites : 7
		},
		'lowkick' : {
			width : 145,
			height : 120,
			x : 0,
			y : 361,
			sprites : 7
		},
		'lowkickleft' : {
			width : -145,
			height : 120,
			x : 2030,
			y : 361,
			sprites : 7
		},
		'move' : {
			width : 145,
			height : 120,
			x : 0,
			y : 481,
			sprites : 12
		},
		'moveleft' : {
			width : -145,
			height : 120,
			x : 3480,
			y : 481,
			sprites : 12
		},
		'lowpunch' : {
			width : 145,
			height : 120,
			x : 0,
			y : 600,
			sprites : 3
		},
		'lowpunchleft' : {
			width : -145,
			height : 120,
			x : 1740,
			y : 600,
			sprites : 3
		},
		'highpunch' : {
			width : 145,
			height : 120,
			x : 435,
			y : 600,
			sprites : 3
		},
		'highpunchleft' : {
			width : -145,
			height : 120,
			x : 1305,
			y : 600,
			sprites : 3
		},
		'uppercut' : {
			width : 145,
			height : 120,
			x : 0,
			y : 720,
			sprites : 6
		},
		'uppercutleft' : {
			width : -145,
			height : 120,
			x : 1740,
			y : 720,
			sprites : 6
		},
		'crouch' : {
			width : 145,
			height : 120,
			x : 0,
			y : 840,
			sprites : 1
		},
		'crouchleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 840,
			sprites : 1
		},
		'block' : {
			width : 145,
			height : 120,
			x : 0,
			y : 960,
			sprites : 1
		},
		'blockleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 960,
			sprites : 1
		},
		'crouchBeat' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1080,
			sprites : 5
		},
		'crouchBeatleft' : {
			width : -145,
			height : 120,
			x : 1451,
			y : 1080,
			sprites : 5
		},
		'win' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1200,
			sprites : 10
		},
		'winleft' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1200,
			sprites : 10
		},
		'jumpBeat' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1320,
			sprites : 2
		},
		'jumpBeatleft' : {
			width : -145,
			height : 120,
			x : 580,
			y : 1320,
			sprites : 2
		},
		'hit' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1440,
			sprites : 1
		},
		'hitleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 1440,
			sprites : 1
		},
		'deadleft' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1560,
			sprites : 3
		},
		'dead' : {
			width : -145,
			height : 120,
			x : 870,
			y : 1560,
			sprites : 3
		}
	}
};
var LiSprites = {
	image : createImage('li.gif'),
	sprites : {
		'start' : {
			width : 145,
			height : 120,
			x : 0,
			y : 0,
			sprites : 3
		},
		'startleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 0,
			sprites : 3
		},
		'stand' : {
			width : 145,
			height : 120,
			x : 0,
			y : 121,
			sprites : 3
		},
		'standleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 121,
			sprites : 3
		},
		'jump' : {
			width : 145,
			height : 120,
			x : 0,
			y : 241,
			sprites : 2
		},
		'jumpleft' : {
			width : -145,
			height : 120,
			x : 580,
			y : 241,
			sprites : 2
		},
		'lowkick' : {
			width : 145,
			height : 120,
			x : 0,
			y : 361,
			sprites : 3
		},
		'lowkickleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 361,
			sprites : 3
		},
		'move' : {
			width : 145,
			height : 120,
			x : 0,
			y : 481,
			sprites : 3
		},
		'moveleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 481,
			sprites : 3
		},
		'lowpunch' : {
			width : 145,
			height : 120,
			x : 0,
			y : 600,
			sprites : 2
		},
		'lowpunchleft' : {
			width : -145,
			height : 120,
			x : 580,
			y : 600,
			sprites : 2
		},
		'highpunch' : {
			width : 145,
			height : 120,
			x : 0,
			y : 720,
			sprites : 3
		},
		'highpunchleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 720,
			sprites : 3
		},
		'uppercut' : {
			width : 145,
			height : 120,
			x : 0,
			y : 720,
			sprites : 3
		},
		'uppercutleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 720,
			sprites : 3
		},
		'crouch' : {
			width : 145,
			height : 120,
			x : 0,
			y : 840,
			sprites : 1
		},
		'crouchleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 840,
			sprites : 1
		},
		'block' : {
			width : 145,
			height : 120,
			x : 0,
			y : 960,
			sprites : 1
		},
		'blockleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 960,
			sprites : 1
		},
		'crouchBeat' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1080,
			sprites : 3
		},
		'crouchBeatleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 1080,
			sprites : 3
		},
		'win' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1200,
			sprites : 10
		},
		'winleft' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1200,
			sprites : 10
		},
		'jumpBeat' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1320,
			sprites : 1
		},
		'jumpBeatleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 1320,
			sprites : 1
		},
		'hit' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1440,
			sprites : 1
		},
		'hitleft' : {
			width : -145,
			height : 120,
			x : 290,
			y : 1440,
			sprites : 1
		},
		'dead' : {
			width : 145,
			height : 120,
			x : 0,
			y : 1560,
			sprites : 3
		},
		'deadleft' : {
			width : -145,
			height : 120,
			x : 870,
			y : 1560,
			sprites : 3
		}
	}
};

var spritePlayerOne = {
	image : '',
	sprite : '',
	index : 0,
	spriteName : ""
};

var spritePlayerTwo = {
	image : '',
	sprite : '',
	index : 0,
	spriteName : ""
};

var Player1;
var Player2;
var spriteName;

var SPRITE_HB_DIV = 3;

/**
 * draws the given players onto the given canvas
 * @param context the context of a canvas
 * @param playerOne
 * @param playerTwo
 */
function drawSprites(context, playerOne, playerTwo) {
	drawPlayerSprite(context, spritePlayerOne, playerOne);
	drawPlayerSprite(context, spritePlayerTwo, playerTwo);
}

/**
 * Draws a single player to the canvas
 * @param context
 * @param spriteToDraw
 * @param player
 */
function drawPlayerSprite(context, spriteToDraw, player) {

	var sprite = getSprite(player);

	//move the position to paint a bit - so the turning of a character seems smoother
	var pos_x_to_paint = player.pos_x - (sprite.width / SPRITE_HB_DIV);
	var offset = sprite.width * spriteToDraw.index;

	context.drawImage(spriteToDraw.image, sprite.x + offset, sprite.y,
			sprite.width, sprite.height, pos_x_to_paint, player.pos_y,
			sprite.width, sprite.height);

	//check if the player is jumping - during this we must not update the spire
	if (player.state === statePlayerEnum.Jumping) {

		var jpBeat = player.jumpBeat;

		//check if the player has just started to jump, is landing or is beating in the air
		if (player.sequenceCounter < 4 || player.sequenceCounter > 8 || jpBeat === 1) {

			if (jpBeat === 2 && player.sequenceCounter <= 8) {
				// player is rising or jumping through the air - do nothing
			} else {
				spriteToDraw.index = (spriteToDraw.index + 1) % (sprite.sprites);
				
				//update the jumpBeat animation only once
				if (jpBeat === 1) {
					player.jumpBeat = 2;
				}
			}
		}
	} else {
		spriteToDraw.index = (spriteToDraw.index + 1) % (sprite.sprites);
	}
}

function createImage(path) {
	// Create new img element
	var img = document.createElement('img');
	img.src = path;
	return img;
}

/**
 * Returns the sprite of the given player. It is automatically turned left if necessary
 * @param player
 * @returns
 */
function getSprite(player) {
	if (player == playerOne) {
		if (playerOne.pos_x > playerTwo.pos_x) {
			return Player1.sprites[spritePlayerOne.spriteName + "left"];
		} else {
			return Player1.sprites[spritePlayerOne.spriteName];
		}
	} else if (player == playerTwo) {
		if (playerTwo.pos_x > playerOne.pos_x) {
			return Player2.sprites[spritePlayerTwo.spriteName + "left"];
		} else {
			return Player2.sprites[spritePlayerTwo.spriteName];
		}
	} else {
		alert('Invalid player!');
	}
}

/**
 * 
 * @param sprite
 *            the Sprite as a String
 * @param drawPlayer
 *            either streetfigher.playerOne or streetfigher.playerTwo
 */
function setSprite(sprite, drawPlayer) {
	if (drawPlayer === playerOne) {
		setSpriteP1(sprite);
	} else if (drawPlayer === playerTwo) {
		setSpriteP2(sprite);
	} else {
		alert('Invalid Player: ' + drawPlayer);
	}
}

/**
 * Set the Sprite type for player one
 * @param spritePlayer1 the name of the sprite as String
 */
function setSpriteP1(spritePlayer1) {

	if (spritePlayerOne.spriteName === spritePlayer1)
		return;

	spritePlayerOne.spriteName = spritePlayer1;
	spritePlayerOne.image = Player1.image;
	spritePlayerOne.index = 0;
}

/**
 * Set the Sprite type for player two
 * @param spritePlayer1 the name of the sprite as String
 */
function setSpriteP2(spritePlayer2) {

	if (spritePlayerTwo.spriteName === spritePlayer2)
		return;

	spritePlayerTwo.spriteName = spritePlayer2;
	spritePlayerTwo.image = Player2.image;
	spritePlayerTwo.index = 0;
}

/**
 * Set the sprite sheet for a player. This is done after the 
 * player have selected their char in menu
 * @param figure
 * @param sprite
 */
function setPlayerSprite(figure, sprite) {
	if(figure === Figures.ryuSprite) {
		if("Ryu" == sprite) {
			Player1 = ryuSprites;
		} else if("ChunLi" == sprite) {
			Player1 = LiSprites;
		}
		setSpriteP1(null);
		
	} else if(figure  === Figures.liSprite) {
		if("Ryu" === sprite) {
			Player2 = ryuSprites;
		} else if('ChunLi' === sprite) {
			Player2 = LiSprites;
		}
		setSpriteP2(null);
	}
}
