var canvas;
var ctx;

var canvas_height = 336;
var canvas_width = 1200;

// the default height and width - used for hitbox
var char_height = 90;
var char_width = 60;

var hitbox_width = 120;

var floor_y = canvas_height - char_height - 50;

var Speed = {
	moveSpeed : 10,
	jumpSpeed_y : 40,
	moveSpeedJump : 20,
	hitSpeedX : 20
};

var statePlayerEnum = {
	None : 0,
	Jumping : -1,
	Lowkick : -2,
	Lowpunch : -3,
	Highpunch : -4,
	Uppercut : -5,
	Hit : -6,
	Block : -7,
	crouchBeat : -8
};

var playerOne = {
	state : statePlayerEnum.None,
	sequenceCounter : 0,
	startsequence : 0,
	pos_x : 150,
	pos_y : floor_y,
	keyboard : keyboardP1,
	hit : null,
	life : 0,
	wins : 0,
	name : "",
	menuChosen : false,
	jumpBeat : 0,
};

var playerTwo = {
	state : statePlayerEnum.None,
	sequenceCounter : 0,
	startsequence : 0,
	pos_x : canvas_width - 150,
	pos_y : floor_y,
	keyboard : keyboardP2,
	hit : null,
	life : 0,
	wins : 0,
	name : "",
	menuChosen : false,
	jumpBeat : 0,
};

var Directions = {
	None : 0,
	Left : 1,
	Top : 2,
	Right : 3,
	Bottom : 4
};

/**
 * The available hits with their strength and range
 */
var Hit = {
	Lowkick : {
		Strength : 10,
		Range : 40
	},
	Lowpunch : {
		Strength : 15,
		Range : 30
	},
	Highpunch : {
		Strength : 10,
		Range : 40
	},
	Uppercut : {
		Strength : 18,
		Range : 25
	},
	CrouchBeat : {
		Strength : 10,
		Range : 30
	},
	JumpBeat : {
		Strength : 10,
		Range : 35
	}
};

var currentPlayer = playerOne;
var otherPlayer = playerTwo;

var loopFunction = null;
var FPS = 20;

// ---welches sprite wird verwendet
var Figures = {
	ryuSprite : 1,
	liSprite : 2
};

/**
 * Initialize a new game!
 */
function initGame() {
	canvas = document.getElementById('runningGame');
	ctx = canvas.getContext('2d');

	//bind the keyboards for the players
	bindKeyboards();

	//set all variables to start
	resetValues();
	
	// ------- menu things
	gameCountdown();
	// -------
	

	//necessary if we do the second game
	draw();
	
	FPS = 20;
	
	initMainLoop(1000 / FPS);
}

/**
 * Initialize the main loop of the game with a given interval
 * @param time the time in milliseconds
 */
function initMainLoop(time) {
	//clear old interval - just to be sure
	clearInterval(loopFunction);
	
	loopFunction = setInterval(function() {
		loop();
	}, time);
}

/**
 * The Main loop function of the game
 */
function loop() {
	//update the player states
	
	currentPlayer = playerOne;
	otherPlayer = playerTwo;
	update();

	currentPlayer = playerTwo;
	otherPlayer = playerOne;
	update();
	
	//check if a player was hit

	checkHit(playerOne);
	checkHit(playerTwo);

	//draw the updates to canvas
	draw();
}

/**
 * Checks if a given player was hit this round
 */
function checkHit(player) {
	if (player.hit) {
		player.state = statePlayerEnum.Hit;
		// we need to update the state here again if the player has not blocked
		if (!player.state !== statePlayerEnum.Block && player.life > 0) {
			setSprite("hit", player);
		} else {
			setSprite("dead", player);
		}
	}
}

function update() {

	// --------- debug

//	$('#debugfield').text("p1 life: " + playerOne.life);
//	$('#debugfield2').text("p2 life: " + playerTwo.life);
//	$('#debugfield3').text("p2 wins: " + playerOne.wins);
//	$('#debugfield4').text("p2 wins: " + playerTwo.wins);

	if (currentPlayer.startsequence <= 8) {
		currentPlayer.startsequence = currentPlayer.startsequence + 1;
	 } else if(!gameReady) {
		 //do nothing yet
		 setSprite('stand',currentPlayer);
	} else if (currentPlayer.state === statePlayerEnum.None) {
		// in this case the current player is not in any state - meaning
		// jumping, kicking, whatever
		// we can check what button is pressed
		updateFromButtons();
	} else {
		// in this case the player is for example jumping. We have to care about
		// the animation
		updateFromState();
	}

	// finally make sure the player reaches the ground again
	gravity();

}

/**
 * This function calculates the gravity for the current player
 */
function gravity() {
	if (statePlayerEnum.Jumping === currentPlayer.state
			&& currentPlayer.sequenceCounter <= 5) {
		if(gameState !== gameStateEnum.gameActive) {
			//game is no more active - gravity can work - like after a player has been 
			//defeated but is still in the air
		} else {
			return;
		}
	}

	var pos_y_tmp = currentPlayer.pos_y;

	if (currentPlayer.pos_y < floor_y) {
		pos_y_tmp = currentPlayer.pos_y + Speed.jumpSpeed_y;
	}

	//check if the new position would be over the floor
	if (pos_y_tmp > floor_y) {
		pos_y_tmp = floor_y;
	}

	currentPlayer.pos_y = pos_y_tmp;
}

/**
 * Updates the current player from its state. Usually the player can not push
 * any buttons when we are doing animations like punching
 */
function updateFromState() {
	var state = currentPlayer.state;

	if (state === statePlayerEnum.Jumping) {

		jump();

	} else if (state === statePlayerEnum.Lowkick) {
		if (currentPlayer.sequenceCounter < 7) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 7) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	} else if (state === statePlayerEnum.Lowpunch) {
		if (currentPlayer.sequenceCounter < 3) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 3) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	} else if (state === statePlayerEnum.Highpunch) {
		if (currentPlayer.sequenceCounter < 3) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 3) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	} else if (state === statePlayerEnum.Uppercut) {
		if (currentPlayer.sequenceCounter < 6) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 6) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	} else if (state == statePlayerEnum.Hit) {

		if (currentPlayer.sequenceCounter < 6) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 6) {
				clearPlayerState();
			} else {
				if (Directions.Left === currentPlayer.hit) {
					moveXPosLeft(Speed.hitSpeedX);
				} else {
					moveXPosRight(Speed.hitSpeedX);
				}
			}
		} else {
			clearPlayerState();
		}

	} else if (state == statePlayerEnum.Block) {
		if (currentPlayer.sequenceCounter < 6) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 6) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	} else if (state == statePlayerEnum.crouchBeat) {
		if (currentPlayer.sequenceCounter < 5) {
			currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;
			if (currentPlayer.sequenceCounter >= 5) {
				clearPlayerState();
			}
		} else {
			clearPlayerState();
		}
	}
}

/**
 * Clears the state of the current player and all avaible variables about it
 * Finally the sprite is set to 'stand'
 */
function clearPlayerState() {
	currentPlayer.state = statePlayerEnum.None;
	currentPlayer.sequenceCounter = 0;
	setSprite('stand', currentPlayer);
	currentPlayer.jumpBeat = 0;
	currentPlayer.hit = null;
}

/**
 * This function is called at every update call when a player is currently in
 * the jumping state
 */
function jump() {
	// check if the drawPlayer is raising in the air
	if (currentPlayer.sequenceCounter <= 5) {
		currentPlayer.pos_y = currentPlayer.pos_y - Speed.jumpSpeed_y;
	}

	if (currentPlayer.sequenceCounter == 10) {
		clearPlayerState();
	} else {
		// or if we just have to go to the next sequence
		currentPlayer.sequenceCounter = currentPlayer.sequenceCounter + 1;

	}

	var keyboard = currentPlayer.keyboard;

	// while jumping we may move the drawPlayer to left or right
	if (keyboard.left) {
		moveXPosLeft(Speed.moveSpeedJump);
	} else if (keyboard.right) {
		moveXPosRight(Speed.moveSpeedJump);
	}

	if (isPlayerPressingHit() && currentPlayer.jumpBeat === 0) {
		setSprite('jumpBeat', currentPlayer);
		currentPlayer.jumpBeat = 1;
		beat(Hit.JumpBeat);
	}
}

/**
 * @returns {Boolean} true if the player is pressing any kind of hit
 */
function isPlayerPressingHit() {
	var keybaord = currentPlayer.keyboard;
	return keybaord.lowKick || keybaord.lowPunch || keybaord.highPunch
			|| keybaord.upperCut;
}

/**
 * Update the state of the current state depending on the currently pressed buttons
 */
function updateFromButtons() {
	var keyboard = currentPlayer.keyboard;

	if (keyboard.lowKick) {
		if (keyboard.down) {
			crouchHit();
		} else {
			setSprite('lowkick', currentPlayer);
			currentPlayer.state = statePlayerEnum.Lowkick;
			beat(Hit.Lowkick);
		}

	} else if (keyboard.lowPunch) {
		if (keyboard.down) {
			crouchHit();
		} else {
			currentPlayer.state = statePlayerEnum.Lowpunch;
			setSprite('lowpunch', currentPlayer);
			beat(Hit.Lowpunch);
		}
	} else if (keyboard.highPunch) {
		if (keyboard.down) {
			crouchHit();
		} else {
			currentPlayer.state = statePlayerEnum.Highpunch;
			setSprite('highpunch', currentPlayer);
			beat(Hit.Highpunch);
		}
	} else if (keyboard.upperCut) {
		if (keyboard.down) {
			crouchHit();
		} else {
			currentPlayer.state = statePlayerEnum.Uppercut;
			setSprite('uppercut', currentPlayer);
			beat(Hit.Uppercut);
		}
	} else if (keyboard.down) {
		setSprite('crouch', currentPlayer);

	} else if (keyboard.left && keyboard.right) {
		setSprite('stand', currentPlayer);

	} else if (keyboard.left) {
		moveXPosLeft(Speed.moveSpeed);
		setSprite('move', currentPlayer);

	} else if (keyboard.right) {
		moveXPosRight(Speed.moveSpeed);
		setSprite('move', currentPlayer);

	} else {
		setSprite('stand', currentPlayer);

	}

	// special case: jumping is always possible when moving right or left
	if (keyboard.up || keyboard.isTopLeft() || keyboard.isTopRight()) {
		// special case: if the player is currently not jumping but is somewhere
		// in the air -
		// like when he has been beaten while jumping - do now allow jumping
		// again until
		// he comes down again
		if (currentPlayer.state !== statePlayerEnum.Jumping
				&& currentPlayer.pos_y !== floor_y) {
			// do nothing
		} else {
			currentPlayer.state = statePlayerEnum.Jumping;
			setSprite('jump', currentPlayer);
		}

	}

	currentPlayer.sequenceCounter = 0;
}

/**
 * This hit can be triggered by any hit while crouching
 */
function crouchHit() {
	currentPlayer.state = statePlayerEnum.crouchBeat;
	setSprite('crouchBeat', currentPlayer);
	beat(Hit.CrouchBeat);
}

/**
 * This function is called after a player hit a beat-button
 * 
 * @param hit
 *            the Hit-Object containing the range and strength
 */
function beat(hit) {

	var direction;
	var blockPressed = false;

	// check at which direction the other player is standing - left or right
	// and if he is blocking - meaning if he is pushing the direction away from
	// the current player
	if (currentPlayer.pos_x > otherPlayer.pos_x) {
		direction = Directions.Left;
		blockPressed = otherPlayer.keyboard.left;
	} else {
		direction = Directions.Right;
		blockPressed = otherPlayer.keyboard.right;
	}

	var range = char_width + hit.Range;
	var strength = hit.Strength;

	if (isInHitbox(currentPlayer.pos_x, direction, range)) {

		if (otherPlayer.keyboard.down && !currentPlayer.keyboard.down) {
			// the other player is crouching - the current player didn't hit him

			if (hit === Hit.Lowkick) {
				// special case: Lowkick hits - do not return
			} else {
				return;
			}
		}

		// if the other player is blocking the beat is not that strong
		if (blockPressed) {
			strength = strength / 5;
			otherPlayer.state = statePlayerEnum.Block;
			setSprite("block", otherPlayer);
		} else {
			// otherwise the player gets thrown through the air
			otherPlayer.hit = direction;
			setSprite("hit", otherPlayer);
		}

		var hitPlayer;

		if (currentPlayer == playerOne) {
			hitPlayer = 1;
		} else {
			hitPlayer = 2;
		}

		//notify the player was hit
		playerHit(hitPlayer, strength);

		// for menu life adjustment
		updatePlayerLife();
	}
}

/**
 * moves the player to the left for a certain amount of pixels
 * @param pixels
 */
function moveXPosLeft(pixels) {
	var pos_x_tmp = currentPlayer.pos_x - pixels;
	if (isInHitbox(pos_x_tmp, Directions.Left, char_width)) {
		// do nothing - we cannot move left, as the other player is standing
		// there
	} else {
		if (pos_x_tmp > char_width) {
			currentPlayer.pos_x = pos_x_tmp;
		} else {
			currentPlayer.pos_x = char_width;
		}
	}
}

/**
 * moves the player to the right for a certain amount of pixels
 * @param pixels
 */
function moveXPosRight(pixels) {
	var pos_x_tmp = currentPlayer.pos_x + pixels;
	//check if the other player is standing where we want to go
	if (isInHitbox(pos_x_tmp, Directions.Right, char_width)) {
		pos_x_tmp = otherPlayer.pos_x - char_width;
	} else {
		if (pos_x_tmp + char_width < canvas_width) {
			currentPlayer.pos_x = pos_x_tmp;
		} else {
			currentPlayer.pos_x = canvas_width - char_width;
		}
	}
}

/**
 * This function checks if the given x_position is in the hitbox of the
 * currently set otherPlayer.
 * 
 * @param pos_x_tmp
 *            the current or destinated position of the currentPlayer
 * @param direction
 *            the direction the current player is looking at
 * @param witdh
 *            the width of the hitbox
 * @returns {Boolean} whether the otherPlayer is in the currentPlayers hitbox
 */
function isInHitbox(pos_x_tmp, direction, witdh) {
	var isInHitbox = false;

	if (direction === Directions.Left) {
		// the hitbox is left of the player - the current x position - the width
		// of the hitbox
		var hitboxBorder = pos_x_tmp - witdh - getSprite(currentPlayer).width
				/ SPRITE_HB_DIV;

		isInHitbox = otherPlayer.pos_x <= pos_x_tmp
				&& otherPlayer.pos_x >= hitboxBorder;

	} else if (direction === Directions.Right) {
		// the hitbox is right of the player - the current x position + the
		// width of the hitbox
		var hitboxBorder = pos_x_tmp + witdh - getSprite(currentPlayer).width
				/ SPRITE_HB_DIV;

		isInHitbox = otherPlayer.pos_x >= pos_x_tmp
				&& otherPlayer.pos_x <= hitboxBorder;

	} else {
		alert('Invalid direction');
	}

	// they are at the same height - check if one is jumping over the other
	if (isInHitbox) {

		if (currentPlayer.pos_y == otherPlayer.pos_y) {
			// players are on the same height - noone is jumping
			// the isInHitbox keeps true
		} else {

			var player_char_height;

			// check if the current player is just crouching - meaning he is
			// only half as big
			if (currentPlayer.keyboard.down) {
				player_char_height = char_height / 2;
			} else {
				player_char_height = char_height;
			}

			var cur_player_y = currentPlayer.pos_y + player_char_height;

			// player are not at the same height
			if (cur_player_y < otherPlayer.pos_y) {
				// the current player is jumping over the other
				isInHitbox = false;
			} else if (cur_player_y < currentPlayer.pos_y) {
				// the other player is jumping over the current player
				isInHitbox = false;
			}
		}
	}

	return isInHitbox;

}

/**
 * Draws the two players to the canvas depending on their current state
 */
function draw() {
	ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
	drawSprites(ctx, playerOne, playerTwo);
}

/**
 * Resets all player variables to start. This method is only to be 
 * called by the resetValues() method
 */
function resetToStart() {
	playerOne.pos_x = 150;
	resetPlayer(playerOne);
	
	playerTwo.pos_x = canvas_width - 150;
	resetPlayer(playerTwo);
	
	gameReady = false;
	
	setSpriteP1('start');
	setSpriteP2('start');
	
	gameState = gameStateEnum.gameActive;
}

function resetPlayer(player) {

	player.state = statePlayerEnum.None;
	player.startsequence = 0;
	player.pos_y = floor_y;
	player.hit = null;
	player.jumpBeat = 0;
	player.life = 0,
	player.sequenceCounter = 0;
}

function playerOneWinAnimation() {

	updateSource("Death/"+getRandom(1,6)+".ogg");
	startSound("empty");
	
	setSpriteP1('win');
	setSpriteP2('dead');
	// hier noch spieler 2 tot umfallen lassen ;)
}

function playerTwoWinAnimation() {
	
	updateSource("Death/"+getRandom(1,6)+".ogg");
	startSound("empty");
	
	setSpriteP2('win');
	setSpriteP1('dead');
	// hier noch spieler 1 tot umfallen lassen ;)
}
