﻿using GameLibrary;
using SdlDotNet.Graphics;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameClient
{
    class PlayerPainter :Painter
    {
        Dictionary<string,bool> actions;
        int x, y;
        double dir;
        int frame = 0;
        int delay = 2;
        int MAX_delay = 2;
        Screen s;
        
        public Point Position
        {
            get
            {
                return new Point(x, y);
            }
        }
        public string ID
        {
            get;
            set;
        }
        public PlayerPainter(Screen s,Player p)
        {
            this.s = s;
            ID = p.Id;
            x = p.X;
            y = p.Y;
            dir = p.Dir;
            actions = p.Actions;
        }
        public void Update(Player p)
        {
            x = p.X;
            y = p.Y;
            dir = p.Dir;
            actions = p.Actions;
        }

        public override void Draw()
        {
            var spritesheet = s.Spritesheets["Player"];
            Surface sprite = spritesheet.GetFrame(frame,0,dir);
            if (actions["forward"])
            {
                if (--delay <= 0)
                {
                    if (++frame >= spritesheet.Frames) frame = 0;
                    delay = MAX_delay;
                }
            }
            else
            {
                frame = 0;
            }
            var pos = new Point(s.Width/2-sprite.Width/2,s.Height/2-sprite.Height/2);
            s.Buffer.Blit(sprite, pos);
        }
    }
}
