﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net;
using System.Net.Sockets;

namespace GameServer
{
    class Client
    {
        public string ID
        {
            get;
            private set;
        }
        public IPEndPoint EndPoint
        {
            get;
            private set;
        }
        Socket sck;
        public Socket Socket
        {
            get { return sck; }
        }
        NetworkStream ns;
        public NetworkStream Stream{
            get
            { 
                if(ns==null) ns = new NetworkStream(sck);
                return ns;
            }
        }

        public Client(Socket accepted)
        {
            sck = accepted;
            ID = Guid.NewGuid().ToString();
            EndPoint = (IPEndPoint)sck.RemoteEndPoint;
            sck.BeginReceive(new byte[] { 0 }, 0, 0, 0, callback, null);
        }

        void callback(IAsyncResult ar)
        {
            try
            {
                sck.EndReceive(ar);
                byte[] receiveBuffer = new byte[1024];

                int recievedSize = sck.Receive(receiveBuffer, receiveBuffer.Length, 0);
                if (recievedSize == 0)
                {
                    Close();
                    return;
                }
                if (recievedSize < receiveBuffer.Length)
                {
                    Array.Resize(ref receiveBuffer, recievedSize);
                }
                if (Received != null)
                {
                    Received(this, receiveBuffer);
                }
                sck.BeginReceive(new byte[] { 0 }, 0, 0, 0, callback, null);

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Close();
            }

        }
        public void Close()
        {
            sck.Close();
            sck.Dispose();
            if (Disconnected != null)
            {
                Disconnected(this);
            }
        }
        public void Send(byte[] data)
        {
            try
            {
                sck.Send(data);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
        public delegate void ClientReceivedHandler(Client sender, byte[] data);
        public delegate void ClientDisconnectedHandler(Client sender);

        public event ClientReceivedHandler Received;
        public event ClientDisconnectedHandler Disconnected;
    }
}
