﻿using GameLibrary;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using ProtoBuf;
using System.Net.Sockets;

namespace GameServer
{
    class Game
    {
        public static Game Current
        {
            get
            {
                if (game == null) game = new Game();
                return game;
            }
        }
        static Game game;

        Thread gameLoop;
        object clientChangeLock;
        List<Client> clients;
        Dictionary<string, Player> players;
        Map map;

        public bool Running
        {
            get;
            private set;
        }

        public Game()
        {
            clientChangeLock = new object();
            map = new Map(MapGenerator.RandomMap(10,10));
            Running = false;
            players = new Dictionary<string, Player>();
        }

        public void ClientChange(ConnectionHandler sender, ConnectionChangeEventArgs e)
        {
            lock (clientChangeLock)
            {
                clients = e.Clients.Values.ToList();
                foreach (var client in clients)
                {
                    client.Received += client_Received;
                }
                if (!Running)
                {
                    gameLoop = new Thread(GameLoop);
                    gameLoop.Name = "GTA_GameLoop";
                    gameLoop.Start();
                    
                }
            }
        }

        void client_Received(Client sender, byte[] data)
        {
            lock (clientChangeLock)
            {
                var actions = players[sender.ID].Actions;
                int input = BitConverter.ToInt32(data,0);
                Console.WriteLine(input);
                actions["forward"] = (input & 0x01) > 0;
                actions["backward"] = (input & 0x02) > 0;
                actions["turnLeft"] = (input & 0x04) > 0;
                actions["turnRight"] = (input & 0x08) > 0;
                
                
            }
        }
        public void Stop()
        {
            lock (clientChangeLock)
            {
                Running = false;
            }
        }

        void GameLoop()
        {
            Running = true;
            if (GameChange != null)
            {
                GameChange(this, new GameChangeEventArgs(true));
            }
            while (Running)
            {
                lock(clientChangeLock)
                {
                    if (clients.Count <= 0)
                    {
                        Running = false;
                        break;
                    }
                    Player p;
                    foreach (var client in clients)
                    {
                        if (players.ContainsKey(client.ID))
                        {
                            p = players[client.ID];
                        }
                        else
                        {
                            p = new Player(0, 0, 0);
                            p.Id = client.ID;
                            players[client.ID] = p;
                            var frame = new Frame(map, p);
                            Serializer.SerializeWithLengthPrefix<Frame>(client.Stream,frame,PrefixStyle.Fixed32);
                            client.Stream.Flush();
                        }
                        p.update();
                        var entities = new List<Entity>();
                        foreach(var ent in players){
                            if (ent.Key == p.Id) continue;
                            entities.Add(ent.Value);
                        }
                        var frame2 = new Frame(null, p,entities);
                        try
                        {
                            Serializer.SerializeWithLengthPrefix<Frame>(client.Stream, frame2, PrefixStyle.Fixed32);
                            client.Stream.Flush();
                        }
                        catch(Exception e) {
                            Console.WriteLine(e.Message);
                        }
                       
                    }

                }
                Thread.Sleep(40);
            }
            if (GameChange != null)
                GameChange(this, new GameChangeEventArgs(false));
        }
        public delegate void GameChangeEventHandler(object sender,GameChangeEventArgs e);
        public event GameChangeEventHandler GameChange;
    }
    
}
