﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SdlDotNet;
using SdlDotNet.Graphics;
using SdlDotNet.Core;
using System.Drawing;
using SdlDotNet.Input;

namespace GameClient
{
    class Screen
    {
        const int SCREEN_WIDTH = 800;
        const int SCREEN_HEIGHT = 600;
        Surface screen;
        Surface buffer;
        List<Painter> painters;
        MapPainter mappainter;

        public Surface Buffer
        {
            get { return buffer; }
            set { buffer = value; }
        }
        public int Width
        {
            get { return SCREEN_WIDTH; }
        }
        public int Height
        {
            get { return SCREEN_HEIGHT; }
        }
        public Dictionary<string, Spritesheet> Spritesheets
        {
            get;
            set;
        }

        public Screen()
        {
            screen = Video.SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT);
            buffer = new Surface(screen);
            screen.Fill(Color.Chocolate);
            screen.Update();
            buffer.Update();
            loadSpritesheets();
            CreatePainters();
            Events.Quit += Close;
            Events.Tick += Tick;
            Events.KeyboardDown += KeyDown;
            Events.MouseMotion += MouseMotion;
            Events.MouseButtonDown += MouseClick;
            Events.Run();
        }

        private void MouseClick(object sender, MouseButtonEventArgs e)
        {
            var x = (mappainter.Center.X - SCREEN_WIDTH / 2 + e.X) / 41;
            var y = (mappainter.Center.Y - SCREEN_HEIGHT / 2 + e.Y) / 41;
            Console.WriteLine("x:{0},y:{1}", x, y);
        }

        private void MouseMotion(object sender, SdlDotNet.Input.MouseMotionEventArgs e)
        {
            if (e.ButtonPressed)
            {
                var p = mappainter;
                p.Center = new Point(p.Center.X - e.RelativeX, p.Center.Y - e.RelativeY);
            }
        }

        private void KeyDown(object sender, SdlDotNet.Input.KeyboardEventArgs e)
        {
            Console.WriteLine(e.Key);
            switch (e.Key)
            {
                case Key.Q:
                    mappainter.Zoom *=0.5;
                    break;
                case Key.E:
                    mappainter.Zoom *=2;
                    break;
            }
            
            
        }
        public void loadSpritesheets()
        {
            Spritesheets = new Dictionary<string, Spritesheet>();
            Spritesheets.Add("Map", new Spritesheet(Images.gta2tiles_41, 41, screen));
        }
        public void CreatePainters()
        {
            painters = new List<Painter>();
            //mappainter = new MapPainter(this, StaticMap.getMapOverview());
            mappainter = new MapPainter(this, StaticMap.getMapfromImage(Images.map));
            painters.Add(mappainter);
        }

        private void Tick(object sender, TickEventArgs e)
        {
            for (int i = 0; i < painters.Count; i++)
            {
                painters[i].Draw();
            }
            screen.Blit(buffer);
            screen.Update();
        }

        void Close(object sender, QuitEventArgs e)
        {
            Events.QuitApplication();
        }
    }
}
