﻿using SdlDotNet.Graphics;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameClient
{
    class Spritesheet
    {
        Surface sprite;
        public int Size
        {
            get;
            set;
        }
        public Spritesheet(Bitmap image,int size,Surface screen)
        {
            Size = size;
            sprite = new Surface(image).Convert(screen, true, true);
        }
        public Surface GetFrame(int x, int y)
        {
            var clip = new Rectangle(x * Size, y * Size, Size, Size);
            return sprite.CreateSurfaceFromClipRectangle(clip);
        }
        public Surface GetFrame(int x)
        {
            return GetFrame(x, 0);
        }
        public Surface GetFrame(int x, int y, int dir)
        {
            //clockwise rotation
            if (dir == 0)
                return GetFrame(x, y);
            return GetFrame(x, y).CreateRotatedSurface(-dir * 90).CreateSurfaceFromClipRectangle(new Rectangle(1, 1, 41, 41));
        }
        public Surface GetFrame(int x, int y, double rotation)
        {
            //changes size
            var angle = rotation*180/Math.PI;
            return GetFrame(x, y).CreateRotatedSurface((int)angle);
        }
        public Surface GetFrame(int x, int y, int dir, int newsize)
        {
            return GetFrame(x, y, dir).CreateResizedSurface(new Size(newsize, newsize));
        }
    }
}
