﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;
using System.Threading;

namespace Kill_The_Squares___
{
    public class SquareManager : Control
    {
        const int TIME_BETWEEN = 10;

        int punkte = 0;

      
        Random rand;
        Square[,] spielfeld;
        List<Square> entities; //Diese Elemente Werden gezeichnet

       
        Form1 formparent;
        int dimension;
       // Color aktuelleFarbe;
        System.Windows.Forms.Timer timer;
        int[] startposition;
        Label points;
        Punktanzeige highscroe_frame;

        public SquareManager()
        {
            entities = new List<Square>();
            SetStyle(ControlStyles.UserPaint | ControlStyles.OptimizedDoubleBuffer, true);
            timer = new System.Windows.Forms.Timer();
            timer.Interval = 25;
            timer.Tick += (s, ev) => Refresh();
            timer.Start();
            Location = new Point(135, 10);
            Height = 1000;
            Width = 1000;
            rand = new Random();
            startposition = new int[2]{0,0};
            CurrentColRow = startposition;

            points = new Label();
           
            points.AutoSize = true;
            points.Font = new Font(points.Font, FontStyle.Bold);
            
            points.BackColor = Color.Transparent;
            this.Controls.Add(points);

            points.MouseClick += new MouseEventHandler(points_Click);

           
                    

            

            
        }

        public SquareManager(int dim, Form1 parent)
            : this()
        {
            formparent = parent;
            dimension = dim;
            spielfeld = new Square[dim, dim];
            GameVersion = parent.GameVersion;

        }

        public int CurrentGameMode
        {
            get;
            set;
        }

        public int CurrentIndex
        {
            get;
            set;
        }

        public string GameVersion
        {
            get;
            set;
        }

        public string PlayerName
        {
            get { return formparent.PlayerName; }
            set { formparent.PlayerName = value; }
        }


        public int Punkte
        {
            get { return punkte; }
            set { punkte = value; }
        }

        public Square[,] Spielfeld
        {
            get { return spielfeld; }
            set { spielfeld = value; }
        }

        public List<Square> Entities
        {
            get { return entities; }
        }

        public int Dimension
        {
            get { return dimension; }
            set { dimension = value; }
        }

        public int[] CurrentColRow
        {
            get;
            set;
        }

        //public Color AktuelleFarbe
        //{
        //    get { return aktuelleFarbe; }
        //    set { aktuelleFarbe = value; }
        //}

        public void Initialize()
        {
            for (int j = 0; j < dimension; j++)
            {
                for (int i = 0; i < dimension; i++)
                {
                    var square = RandomSquare(i, j);
                    spielfeld[i, j] = square;
                    entities.Add(square);
                }
            }

            Debug.WriteLine(this.ToString());
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            foreach (var entity in entities)
                entity.Draw(e);
        }

        protected override void OnMouseClick(MouseEventArgs e)
        {
            base.OnMouseClick(e);

            var col = e.X / 50;
            var row = e.Y / 50;
           
            
            

            for (int i = 0; i < dimension; i++)
            {
                for (int j = 0; j < dimension; j++)
                {
                    if (spielfeld[i, j].Column == col && spielfeld[i, j].Row == row)
                    {
                        spielfeld[i, j].Hit();
                        CurrentColRow = startposition;
                        OnMouseMove(e);
                        return;
                    }
                }
            }
        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            base.OnMouseMove(e);
            int[] position = {e.X / 50, e.Y / 50};


            if (position[0] == CurrentColRow[0] && position[1] == CurrentColRow[1])
                return;

            for (int i = 0; i < dimension; i++)
            {
                for (int j = 0; j < dimension; j++)
                {
                    if (spielfeld[i, j].Column == position[0] && spielfeld[i, j].Row == position[1])
                    {
                        Debug.WriteLine("Position change");
                        spielfeld[CurrentColRow[0], CurrentColRow[1]].UnMarkSquare();
                       
                        spielfeld[i, j].MarkSquare();
                        points.Location = new Point(position[0] * 50, position[1] * 50);
                        
                        

               
                        CurrentColRow = position;
                        return;
                    }
                }
            }

        }


        private void points_Click(object sender, MouseEventArgs e)
        {
            //Debug.WriteLine("Klick auf Label");
            //Debug.WriteLine(e.X + "  " + e.Y);
            Point p = points.Location;

            MouseEventArgs e2 = new MouseEventArgs(System.Windows.Forms.MouseButtons.Left, 1, p.X+10, p.Y+10, 0);
            OnMouseClick(e2);
        }

        

        


        public override string ToString()
        {
            var sb = new StringBuilder();

            for (int j = 0; j < dimension; j++)
            {
                for (int i = 0; i < dimension; i++)
                {
                    sb.Append(spielfeld[i, j].Farbe.Name[0].ToString() + "  ");
                }

                sb.AppendLine();
            }

            return sb.ToString();
        }

        public void Hit(int column, int row)
        {
            spielfeld[column, row].Hit();
            Debug.WriteLine(this.ToString());
        }

        Square RandomSquare(int i, int j)
        {
            int ranzahl = rand.Next(0, 3);
            Square neu;

            switch (ranzahl)
            {
                case 0:
                    neu = new YellowSquare(this);
                    break;
                case 1:
                    neu = new RedSquare(this);
                    break;
                case 2:
                    neu = new BlueSquare(this);
                    break;
                default:
                    neu = new VoidSquare(this);
                    break;
            }

            neu.SetInitialPosition(i, j);
            return neu;
        }

        public void SearchLeft(Square square, List<Square> toEliminate)
        {
            //Find Row, Column of square
            int i = square.Column;
            int j = square.Row;

            if (i == 0)
                return;

            if (spielfeld[i - 1, j].Farbe == square.Farbe)
            {
                var newSquare = spielfeld[i - 1, j];

                if (toEliminate.Contains(newSquare))
                    return;

                toEliminate.Add(newSquare);
                SearchLeft(newSquare, toEliminate);
                SearchTop(newSquare, toEliminate);
                SearchBottom(newSquare, toEliminate);
            }
        }

        public void SearchRight(Square square, List<Square> toEliminate)
        {
            int i = square.Column;
            int j = square.Row;

            if (i >= dimension - 1)
                return;

            if (spielfeld[i + 1, j].Farbe == square.Farbe)
            {
                var newSquare = spielfeld[i + 1, j];

                if (toEliminate.Contains(newSquare))
                    return;

                toEliminate.Add(newSquare);
                SearchRight(newSquare, toEliminate);
                SearchTop(newSquare, toEliminate);
                SearchBottom(newSquare, toEliminate);
            }
        }

        public void SearchBottom(Square square, List<Square> toEliminate)
        {
            int i = square.Column;
            int j = square.Row;
            if (j >= dimension - 1)
                return;

            if (spielfeld[i, j + 1].Farbe == square.Farbe) //Obacht, die unterste Zeile hat Index "spielfeldmass -1"!!!
            {
                var newSquare = spielfeld[i, j + 1];

                if (toEliminate.Contains(newSquare))
                    return;

                toEliminate.Add(newSquare);
                SearchRight(newSquare, toEliminate);
                SearchLeft(newSquare, toEliminate);
                SearchBottom(newSquare, toEliminate);
            }
        }

        public void SearchTop(Square square, List<Square> toEliminate)
        {
            int i = square.Column;
            int j = square.Row;

            if (j == 0)
                return;

            if (spielfeld[i, j - 1].Farbe == square.Farbe) //Obacht, die oberste Zeile hat Index "0"!!!
            {
                var newSquare = spielfeld[i, j - 1];

                if (toEliminate.Contains(newSquare))
                    return;

                toEliminate.Add(newSquare);
                SearchRight(newSquare, toEliminate);
                SearchLeft(newSquare, toEliminate);
                SearchTop(newSquare, toEliminate);
            }
        }

        public void Eliminate(List<Square> toEliminate)
        {
            if (toEliminate.Count < 2)
                return;

            punkte += toEliminate.Count * (toEliminate.Count - 1)*10;

            formparent.SetPunkte = punkte;

            int offset = 0;

            //var toAnimate = toEliminate.ToList();

            foreach (var item in toEliminate)
            {
                //var letztes = toEliminate.ElementAt(toEliminate.Count - 1);


                //Animation wird gestartet
                spielfeld[item.Column, item.Row].Animation(offset);

                offset += TIME_BETWEEN;

                CreateVoid(item.Column, item.Row);
            }

            Runterfallen(toEliminate);
            LinksRuck();
            Debug.WriteLine(ToString());
            CheckEnde();
        }

        public void MarkSquares(List<Square> toMark)
        {
            if (toMark.Count < 2)
            {
                points.Hide();
                return;
            }
            foreach (var item in toMark)
            {
                item.Squaremarker();
                int possiblepoints = toMark.Count * (toMark.Count - 1) * 10;
                points.Text = 
                    possiblepoints.ToString();
                points.Show();
            }
        }

        public void UnMarkSquares(List<Square> toMark)
        {
            if (toMark.Count < 2)
                return;

            foreach (var item in toMark)
            {
                item.Unmarker();

            }
        }


        VoidSquare CreateVoid(int col, int row)
        {
            var vs = new VoidSquare(this);
            vs.SetInitialPosition(col, row);
            spielfeld[col, row] = vs;
            entities.Add(vs);
            return vs;
        }

        private void Runterfallen(List<Square> toEliminate)
        {
            var SpaltenListe = toEliminate.Select(m => m.Column).Union(new int[0]).ToList();

            foreach (var item in SpaltenListe)
            {
                RunterfallenSpalte(item);
            }
        }

        private void RunterfallenSpalte(int spalte)
        {
            bool weiter = true;
            int j = dimension - 1; //j ist zeilenindex und startet unten
            int wohin;

            while (weiter && j >= 0)
            {
                if (spielfeld[spalte, j].Farbe == Color.Empty)
                {
                    weiter = false;
                }
                else j--;
            }

            wohin = j; //erste leeres Feld von unten
            weiter = true;

            while (weiter && j >= 0)
            {
                if (spielfeld[spalte, j].Farbe != Color.Empty)
                {
                    weiter = false;  //j der Index des Feldes, das runterfällt
                }
                else
                    j--;
            }

            if (j < 0)
                return;

            spielfeld[spalte, wohin] = spielfeld[spalte, j];
            spielfeld[spalte, wohin].ChangePosition(spielfeld[spalte, wohin].Column, wohin);

            CreateVoid(spalte, j);
            RunterfallenSpalte(spalte);
        }

        private void LinksRuck()
        {
            int i = 0;
            while ((spielfeld[i, dimension - 1].Farbe != Color.Empty) && (i < dimension - 1)) //Sucht die erste Spalte, die nach links rücken soll, diese ist i
                i++;
            if (i == dimension - 1)
                return;

            {    
                //Abfrage ob die gefundene Spalte i eine der letzten bereits geleerten Spalten ist
                int j = i;
                while ((spielfeld[j + 1, dimension - 1].Farbe == Color.Empty) && (j < dimension - 1))
                {
                    j++;
                    if (j == dimension - 1)
                        return;
                }
          }

            while (i < dimension - 1)
            {
                for (int j = 0; j < dimension; j++)
                {
                   
                    spielfeld[i, j] = spielfeld[i + 1, j];
                    spielfeld[i, j].ChangePosition(i, j);
            
                }
                i++;
            }

            for (int j = 0; j < dimension; j++)
            {
                CreateVoid(dimension - 1, j);
            }

            LinksRuck();
        }

        private void CheckEnde()
        {
            for (int i = 0; i < dimension; i++)
            {
                for (int j = 0; j < dimension-1; j++)
                {
                    if ((spielfeld[i, j].Farbe == spielfeld[i, j + 1].Farbe) && (spielfeld[i, j].Farbe != Color.Empty))
                        return;
                }
            }

            for (int j = 0; j < dimension; j++)
            {
                for (int i = 0; i < dimension - 1; i++)
                {
                    if ((spielfeld[i, j].Farbe == spielfeld[i+1,j].Farbe) && (spielfeld[i, j].Farbe != Color.Empty))
                        return;
                }
            }

            Debug.WriteLine("SpielEnde");
            highscroe_frame = new Punktanzeige(this);
            highscroe_frame.ShowDialog();
        }

    }

}