﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using MySql.Data.MySqlClient;
using MySql.Data;
using System.Diagnostics;
using System.Threading;

namespace Kill_The_Squares___
{
    public partial class Highscore : Form
    {
        
        private MySqlConnection conn = null;
        private MySqlDataAdapter da = null;
        private DataSet ds = null;
        Task t;
        SynchronizationContext current;
        object mylock;


        string version;

        

        public Highscore()
        {
            InitializeComponent();
            current = SynchronizationContext.Current;

            mylock = new object();

            this.dataGridView1.RowPostPaint += new System.Windows.Forms.DataGridViewRowPostPaintEventHandler(this.dataGridView1_RowPostPaint);

            comboBox1.Enabled = false;

            t = new Task(ConnectDB);
            t.Start();
            
        }

        public Highscore(SquareManager parent)
            :this()
        {

            version = parent.GameVersion;
            this.comboBox1.SelectedIndex = parent.CurrentIndex ;
           
        }

        public Highscore(int index, string version)
            : this()
        {
            this.version = version;
            comboBox1.SelectedIndex = index;
           
        }


        
         private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
             if (comboBox1.Enabled == true)
             {
                 t = new Task(ReadDB);
                 t.Start();
            }

        }

         private void comboBox1_SelectedIndexChanged()
         {
             var sender = new object();
             var e = new EventArgs();
             comboBox1_SelectedIndexChanged(sender, e);

         }

        private void ConnectDB()
        {
            string cs = @"server=db4free.net;userid=squser;
            password=square_pw;database=sqhighscores";

            lock (mylock)
            {

                try
                {
                    conn = new MySqlConnection(cs);
                    conn.Open();

                    Debug.WriteLine("MySQL Server Version: " + conn.ServerVersion.ToString());

                    current.Send(_ =>
                    {
                        comboBox1.Enabled = true;
                    }, null);

                }

                catch (MySqlException ex)
                {
                    Debug.WriteLine(ex.ToString());

                }

                finally
                {
                    if (conn != null)
                    {
                        conn.Close();
                    }

                    current.Send(_ => comboBox1_SelectedIndexChanged(), null);
                }
            }

        }
        private void ReadDB()
        {
            lock (mylock)
            {

                try
                {
                    conn.Open();

                    current.Send(_ =>
                    {

                        dataGridView1.TabIndex = 0;
                        dataGridView1.Parent = this;

                        var spielmodus = comboBox1.Text;

                        string stm = "SELECT Score, Name, Timestamp FROM squares_highscores WHERE ModeID = '" + spielmodus + "' AND Version = '" + version + "' ORDER BY Score DESC";

                        ds = new DataSet();
                        da = new MySqlDataAdapter(stm, conn);
                        da.Fill(ds, "squares_highscores");

                        dataGridView1.DataSource = ds.Tables["squares_highscores"];

                    }, null);


                }

                catch (MySqlException ex)
                {
                    Debug.WriteLine(ex.ToString());

                }

                finally
                {
                    if (conn != null)
                    {
                        conn.Close();
                    }
                }
            }

        }

        private void dataGridView1_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            using (SolidBrush b = new SolidBrush(dataGridView1.RowHeadersDefaultCellStyle.ForeColor))
            {
                e.Graphics.DrawString((e.RowIndex + 1).ToString(), e.InheritedRowStyle.Font, b, e.RowBounds.Location.X + 10, e.RowBounds.Location.Y + 4);
            }
        }

       


    }
}
