﻿using System;
using MySql.Data;
using MySql.Data.MySqlClient;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

namespace Kill_The_Squares___
{
    public partial class Punktanzeige : Form
    {
        SquareManager ManagerParent;
        int punkte;
        private MySqlConnection conn = null;
        SynchronizationContext current;
        Task t;



        public Punktanzeige()
        {
            
            InitializeComponent();
            current = SynchronizationContext.Current;

            textBox1.KeyDown += textBox1_KeyDown;

            label3.Hide();
            button1.Enabled = false;
            button2.Enabled = false;
            textBox1.Enabled = false;

            t = new Task(ConnectDB);
            t.Start();
      


        }

        public Punktanzeige(SquareManager parent)
            :this()
        {

            ManagerParent = parent;

            double squares = ManagerParent.Dimension * ManagerParent.Dimension;
            double remainingsquares = 0.0;
            var feld = ManagerParent.Spielfeld;
            foreach (var item in feld)
            {
                if (item.Farbe != Color.Empty)
                remainingsquares++;  
            }
            double penalty = (Math.Sqrt(remainingsquares /squares ) / 2);
            double subtraction = penalty * ManagerParent.Punkte;

            punkte = ManagerParent.Punkte - (int)subtraction;

            
            label2.Text = ManagerParent.Punkte.ToString()+ " - " + (int)subtraction + " = " + punkte;
            label4.Text = "im Modus" + ManagerParent.CurrentGameMode.ToString() + " x " + ManagerParent.CurrentGameMode.ToString();
            if (ManagerParent.PlayerName != null)
            {
                textBox1.Text = ManagerParent.PlayerName;
                button1.Enabled = true;        
            }

        }

        

      

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.Text != "")
                button1.Enabled = true;
            else
                button1.Enabled = false;
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }
        
        private void button1_Click(object sender, EventArgs e)
        {
            SubmitHighscore();
            ManagerParent.PlayerName = textBox1.Text;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var hs = new Highscore(ManagerParent);
            hs.Show();
        }
       

        private void ConnectDB()
        {
            string cs = @"server=db4free.net;userid=squser;
            password=square_pw;database=sqhighscores";

            try
            {
                conn = new MySqlConnection(cs);
                conn.Open();
                Debug.WriteLine(conn.ServerVersion.ToString());

                current.Send(_ =>
                {
                    
                    textBox1.Enabled = true;
                    button2.Enabled = true;
                    label3.ForeColor = Color.Green;
                    label3.Text = "Verbindung zur Datenbank erfolgreich hergestellt";
                    label3.Show();
                }, null);


            }

            catch (MySqlException ex)
            {
                Debug.WriteLine(ex.ToString());

                current.Send(_ =>
                {
                    textBox1.Enabled = false;
                    button2.Enabled = false;
                    label3.ForeColor = Color.Red;
                    label3.Text = "Keine Verbindung zur Datenbank möglich!";
                    label3.Show();
                    button1.Enabled = false;
                }, null);


            }

            finally
            {
                if (conn != null)
                {
                    conn.Close();
                }
            }

        }

        private void SubmitHighscore()
        {
            try
            {

                var name = textBox1.Text;
                var spielmodus = ManagerParent.CurrentGameMode.ToString();
                var version = ManagerParent.GameVersion;
                
                conn.Open();

                MySqlCommand cmd = new MySqlCommand();

                cmd.Connection = conn;
                cmd.CommandText = "INSERT INTO squares_highscores (ModeID, Name, Version, Score) VALUES ('"+spielmodus+"', '"+ name + "', '"+ version+ "', '" + punkte +"')";
                cmd.ExecuteNonQuery();
                Debug.WriteLine("Highscore eingetragen");
                button1.Enabled = false;
                textBox1.Enabled = false;


            }

            catch (MySqlException ex)
            {
                Debug.WriteLine(ex.ToString());
                current.Send(_ => ConnectDB(), null);
                
            }

            finally
            {
                if (conn != null)
                {
                    conn.Close();
                }


            }

        }

        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                if(button1.Enabled == true)
                button1_Click(sender, e);
            }
        }

        private void Punktanzeige_Load(object sender, EventArgs e)
        {

        }

        
    
    }
}
