﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.Threading;

namespace Kill_The_Squares___
{
    public abstract class Square
    {
        Bitmap bmp;
        Graphics g;
        LinearGradientBrush lgb;
        //Label points;

        public Square()
        {
            this.Height = 50;
            this.Width = 50;
        }

        public Square(SquareManager parent)
            : this()
        {
            IsAlive = true;
            ManagerParent = parent;
            lgb = new LinearGradientBrush(new Point(0, 0), new Point(this.Height, this.Width), this.Farbe, Color.Black);
            bmp = new Bitmap(this.Height, this.Width);
            g = Graphics.FromImage(bmp);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;

            g.FillRectangle(lgb, new Rectangle(0, 0, this.Height, this.Width));

            //points = new Label();
         
            //points.Text = "Test";
            //points.ForeColor = Color.Green;
            //this.Controls.Add(points);
            //points.Width = 20;
            //points.Height = 20;

            
            

        }

        public int Height { get; private set; }

        public int Width { get; private set; }

        public SquareManager ManagerParent { get; private set; }

        public int Column { get; private set; }

        public int Row { get; private set; }

        public float X { get; private set; }

        public float Y { get; private set; }

        public float Vx { get; private set; }

        public float Vy { get; private set; }

        public abstract Color Farbe { get; }

        public abstract Brush Pinsel { get; }

        public bool IsAlive { get;  set; }

        public void SetInitialPosition(int column, int row)
        {
            X = column * Width;
            Y = row * Height;
            Column = column;
            Row = row;
        }

        public void ChangePosition(int column, int row)
        {
            Vx -= (Column - column) * 2.5f;
            Vy -= (Row - row) * 2.5f;
            Column = column;
            Row = row;
        }

        //public void Showpoints()
        //{
        //    points.Show();
        //}


        public void Squaremarker()
        {
            g.FillRectangle(this.Pinsel, new Rectangle(0, 0, this.Height, this.Width));
        }

        public void Unmarker()
        {
            g.FillRectangle(lgb, new Rectangle(0, 0, this.Height, this.Width));
        }

        public void MarkSquare()
        {
            var marked = Mark();
            ManagerParent.MarkSquares(marked);
        }

        public void UnMarkSquare()
        {
            var marked = Mark();
            ManagerParent.UnMarkSquares(marked);
        }



        public void Hit()
        {

            var toEliminate = Mark();
            ManagerParent.Eliminate(toEliminate);
            
        }

        public List<Square> Mark()
        {
            var marked = new List<Square>();
            marked.Add(this);

            if (this.Farbe != Color.Empty)
            {
                ManagerParent.SearchLeft(this, marked);
                ManagerParent.SearchRight(this, marked);
                ManagerParent.SearchTop(this, marked);
                ManagerParent.SearchBottom(this, marked);              
            }

            return marked;
        }

        public void Animation(int offset)
        {
            int sleeptime2 = 15;
            int sleeptime1 = 5;
            var lgb = new LinearGradientBrush(new Point(0, 0), new Point(this.Height, this.Width), this.Farbe, Color.Black);
            TimerFrames tf = new TimerFrames();

            tf.Add(new TimerFrame(() => g.FillEllipse(Brushes.GhostWhite, new Rectangle(this.Height * 3 / 8, this.Width * 3 / 8, this.Height / 4, this.Width / 4)), offset));
           // tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(0, 0, this.Height, this.Width)), sleeptime2));
            tf.Add(new TimerFrame(() => g.FillEllipse(Brushes.OrangeRed, new Rectangle(this.Height / 4, this.Width / 4, this.Height / 2, this.Width / 2)), sleeptime1));
            //tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(0, 0, this.Height, this.Width)), sleeptime2));
            tf.Add(new TimerFrame(() => g.FillEllipse(Brushes.Goldenrod, new Rectangle(this.Height / 8, this.Width / 8, this.Height * 3 / 4, this.Width * 3 / 4)), sleeptime1));
            //tf.Add(new TimerFrame(sleeptime2));
            tf.Add(new TimerFrame(() => g.FillEllipse(Brushes.WhiteSmoke, new Rectangle(0, 0, this.Height, this.Width)), sleeptime1));
            tf.Add(new TimerFrame(() => IsAlive = false, sleeptime1));

            tf.Start();
        }

        //public void Animation(int offset, List<Square> toAnimate)
        //{
        //    int sleeptime2 = 12;
        //    int sleeptime1 = 6;
        //    var lgb = new LinearGradientBrush(new Point(0, 0), new Point(this.Height, this.Width), this.Farbe, Color.Ivory);
        //    TimerFrames tf = new TimerFrames();

        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime1));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 32, this.Width / 32, this.Height * 30 / 32, this.Width * 30 / 32)), offset));
        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime2));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 24, this.Width / 24, this.Height * 22 / 24, this.Width * 22 / 24)), sleeptime1));
        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime2));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 18, this.Width / 18, this.Height * 16 / 18, this.Width * 16 / 18)), sleeptime1));
        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime2));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 12, this.Width / 12, this.Height * 10 / 12, this.Width * 10 / 12)), sleeptime1));
        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime2));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 6, this.Width / 6, this.Height * 4 / 6, this.Width * 4 / 6)), sleeptime1));
        //    tf.Add(new TimerFrame(() => g.Clear(Color.Empty), sleeptime2));
        //    tf.Add(new TimerFrame(() => g.FillRectangle(lgb, new Rectangle(this.Height / 4, this.Width / 4, this.Height * 2 / 4, this.Width * 2 / 4)), sleeptime1));
          
        //    tf.Add(new TimerFrame(() => IsAlive = false, sleeptime1));

        //    tf.Start();
        //}

        internal virtual void Draw(PaintEventArgs e)
        {
            if (!IsAlive)
                return;

            if (Vx != 0)
            {
                X += Vx;

                if (X <= 50 * Column)
                {
                    Vx = 0;
                    X = 50 * Column;
                }
            }

            if (Vy != 0)
            {
                Y += Vy;

                if (Y > 50 * Row)
                {
                    Vy = 0;
                    Y = 50 * Row;
                }
            }

            e.Graphics.DrawImage(bmp, new PointF(X, Y));
        }
    }
}
