﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;         //Für Thread
using System.Drawing;           //Für Graphics
using System.Drawing.Drawing2D;
using System.ComponentModel;    //Für InvalidAsynchronousStateException
using System.Diagnostics;       //Für Debug

namespace PsychoTerror
{
    //Zeichnet alle Spielelemente in separatem Thread
    class BildBuffer
    {
        //Thread, SynchContext, Delegat und Event für den DoubleBufferThread, für neuen Level und fürs Sterben
        Thread malThread;                   
        SynchronizationContext context;
        public delegate void MaleBild(BildBuffer sender, Bitmap b);
        public event MaleBild MaleBildEvent;
        public delegate void Sonstiges(BildBuffer sender, object o);
        public event Sonstiges NextLevelEvent;
        public event Sonstiges SterbeEvent;

        const int NO_OF_HINTERGR = 21;   //Anzahl der verfügbaren Hintergrundbilder

        //Bilder
        Bitmap figurBild;
        Bitmap[] hintergrundBild;
        Bitmap gewonnen;
        Bitmap verloren;
        Bitmap zuSendendesBild;

        //Spielfigur und Landschaft
        SpielFigur spielFigur;
        Level level;
        Verfolger verfolger;

        //Konstruktor
        public BildBuffer(SynchronizationContext context, SpielFigur spielFigur, Level level, Verfolger verfolger)
        {
            //Threading-Stuff
            malThread = new Thread(malMethode);
            this.context = context;

            //Lade alle Bilder
            figurBild = MyResources.Figur;
            hintergrundBild = new Bitmap[NO_OF_HINTERGR];
            for (int i = 0; i < NO_OF_HINTERGR; ++i)
            {
                hintergrundBild[i] = MyResources.ResourceManager.GetObject("Hintergrund" + i.ToString("D2")) as Bitmap;
            }
            gewonnen = MyResources.Gewonnen;
            verloren = MyResources.Verloren;

            figurBild.MakeTransparent();    //Weiß ist in diesem Bild transparent
           
            this.spielFigur = spielFigur;
            this.level = level;
            this.verfolger = verfolger;

            //Positioniere Spielfigur auf den Startpunkt
            setzeAufStartpunkt();
        }

        public void StartThread()
        {
            malThread.Start();
        }

        uint count;
        int spriteXPos;
        int spriteYPos;
        int merkeRichtung;
        int aktuellerHintergr;
        float drehWinkel;
        float winkelInkrement;
        Graphics ganzesBild;    //Hier wird nach und nach das ganze Bild reingemalt (gepuffert)

        void malMethode()    //Holt sich ständig alle relevanten Daten und updatet das angezeigte Bild
        {
            count = 0;
            spriteXPos = 0;
            spriteYPos = 0;
            merkeRichtung = 1; //Letzte Bewegungsrichtung; 1: rechts, -1: links; Spielfigur schaut am Anfang nach rechts
            aktuellerHintergr = 0;
            drehWinkel = 0.0f;
            winkelInkrement = 1.0f;

            //Stelle sicher, dass nach Programmende der Thread nicht mehr läuft
            while (Program.Window != null && !Program.Window.IsDisposed)    
            {
                count++;

                //Behandle Ende des Spiels etc
                if (level.Gewonnen)
                    bildSenden(gewonnen);   //Sende fertig gemaltes Bild zur Anzeige
                else if (level.Verloren)
                    bildSenden(verloren);   //Sende fertig gemaltes Bild zur Anzeige
                else
                {
                    if (spielFigur.LevelAnfang)
                    {
                        setzeAufStartpunkt();   //Positioniere Spielfigur auf den Startpunkt des aktuellen Levels
                        spielFigur.LevelAnfang = false;
                    }

                    hintergrundMalen();

                    if (count % 3 == 0)     //Berechne Bewegung und animiere Sprite
                        bewegung();

                    spielFigur.X += spielFigur.XSpeed;  //Bewege Spielfigur gemäß Geschwindigkeit
                    spielFigur.Y += spielFigur.YSpeed;

                    bestimmeDrehung();  //Bestimme die Drehung, mit der alles Folgende gekippt wird

                    barrierenMalen();    //Zeichne Barrieren in der Nähe der Spielfigur

                    verfolgerMalen();   //Zeichnet die Linie, die Zeitdruck macht

                    figurMalen();   //Zeichne Spielfigur

                    bildSenden(zuSendendesBild);   //Schicke Bild an die Hauptform                   
                }
                Thread.Sleep(10);   //Warte kurz
            }
        }

        void setzeAufStartpunkt()
        {
            spielFigur.X = 12;
            spielFigur.Y = level.Landschaft[0] + 75;
        }

        void hintergrundMalen()
        {
            if (level.LevelNummer <= 3)  //Am Anfang harmlos
                zuSendendesBild = new Bitmap(Program.BILDBREITE, Program.BILDHOEHE);
            else
            { 
                if (count % 5 == 0)     //Ändere Hintergrundbild
                {
                    if (level.LevelNummer <= 6) //hier schräge Striche
                        aktuellerHintergr = (aktuellerHintergr + 1) % 7;
                    else if (level.LevelNummer <= 10) //hier waagrechte Striche
                        aktuellerHintergr = 7 + (aktuellerHintergr + 1) % 7;
                    else   //ab hier dichte waagrechte Striche
                        aktuellerHintergr = 14 + (aktuellerHintergr + 1) % 7;
                }

                zuSendendesBild = new Bitmap(hintergrundBild[aktuellerHintergr]);
            }
            
            ganzesBild = Graphics.FromImage(zuSendendesBild);
        }

        //Erzeuge Drehwinkel, der das Wackeln des Bildes steuert
        void bestimmeDrehung()
        {
            if (level.SkippedLevels)
            {
                drehWinkel = 0; //Nötig, wenn man zwischen Levels rumspringt
                level.SkippedLevels = false;
            }
            if (level.LevelNummer > 4)  //ab Level 5
            {
                float max = level.LevelNummer / 8.0f;
                float min = -level.LevelNummer / 4.0f;
                if (drehWinkel >= max || drehWinkel <= min)
                    winkelInkrement *= -1;
                drehWinkel += winkelInkrement * (max - min) / 20.0f;
            }

            ganzesBild.SmoothingMode = SmoothingMode.AntiAlias;
            ganzesBild.RotateTransform(drehWinkel);
        }

        //Bewege Spielfigur im Level
        void bewegung()
        {
            //Nächster Level
            //==================
            if (spielFigur.BarriereRechts() && spielFigur.BlockGrenzeRechts() == Program.BILDBREITE)
            {
                context.Send(_ => NextLevelEvent(this, null), null);     //Sende fertig gemaltes Bild zur Anzeige
            }

            //Sterben
            //==================
            if (   (spielFigur.BodenHoehe() == 0 && spielFigur.Y <= 30)  ||  (spielFigur.X <= verfolger.X)   )
            {
                context.Send(_ => SterbeEvent(this, null), null);     //Sende fertig gemaltes Bild zur Anzeige
            }

            //X-Bewegung
            //==================
            if (spielFigur.RechtsInit)
            {
                if (!spielFigur.BarriereRechts())
                    spielFigur.XSpeed = 3;
                else
                    spielFigur.XSpeed = 0;
            }
            else if (spielFigur.LinksInit)
            {
                if (!spielFigur.BarriereLinks())
                    spielFigur.XSpeed = -3;
                else
                    spielFigur.XSpeed = 0;
            }
            else
                spielFigur.XSpeed = 0;

            //Sprites
            //==================
            if (spielFigur.XSpeed == 0)         //Spielfigur bewegt sich nicht horizontal
            {
                if (merkeRichtung == 1) //Letzte Bewegungsrichtung: rechts
                {
                    spriteXPos = 80;
                    spriteYPos = 0;
                }
                else                    //Letzte Bewegungsrichtung: links
                {
                    spriteXPos = 80;
                    spriteYPos = 25;
                }
            }
            else if (spielFigur.XSpeed > 0)     //Spielfigur bewegt sich nach rechts
            {
                merkeRichtung = 1;
                spriteXPos += 20;
                spriteXPos %= 80;
                spriteYPos = 0;
            }
            else                                //Spielfigur bewegt sich nach links
            {
                merkeRichtung = -1;
                spriteXPos -= 20;
                spriteXPos = (spriteXPos + 80) % 80;
                spriteYPos = 25;
            }

            //Y-Bewegung und Jump-Sprites
            //==================
            if (spielFigur.Y > spielFigur.BodenHoehe() + 25)//Wenn Spielfigur in der Luft ist, beschleunige nach unten
            {
                spriteXPos = 100;
                spielFigur.YSpeed -= 2;
            }
            else if (spielFigur.Y <= spielFigur.BodenHoehe() + 25) //Wenn Spielfigur den Boden erreicht (oder durch einen Fehler darunter ist),
            {                                           //setze y-Geschwindigkeit auf 0 (und zur Sicherheit die Figur auf den Boden)
                spielFigur.YSpeed = 0;

                spielFigur.Y = spielFigur.BodenHoehe() + 25;
            }

            if (spielFigur.JumpInit && spielFigur.Y <= spielFigur.BodenHoehe() + 25)  //Kann nur springen, wenn am Boden
                spielFigur.YSpeed = 10;
        }

        //Bewege Barriere (Verfolger) im Level
        void barrierenMalen()
        {
            GraphicsPath pathUnten = new GraphicsPath();
            GraphicsPath pathSeite = new GraphicsPath();

            Point ul = new Point(spielFigur.BlockGrenzeLinks(), Program.BILDHOEHE - spielFigur.BodenHoehe());   //Punkt unten links
            Point ur = new Point(spielFigur.BlockGrenzeRechts(), Program.BILDHOEHE - spielFigur.BodenHoehe());  //Punkt unten rechts

            if (spielFigur.BodenHoehe() == 0)
            {
                ganzesBild.DrawLine(Pens.Red, ul.X, ul.Y - 1, ur.X, ur.Y - 1);
            }
            else
                ganzesBild.DrawLine(Pens.Black, ul, ur);
            

            if (spielFigur.BarriereRechts())
            {
                Point or = new Point(spielFigur.BlockGrenzeRechts(), Program.BILDHOEHE - spielFigur.BodenHoeheRechts());    //Punkt oben rechts
                ganzesBild.DrawLine(Pens.Black,ur,or);
            }
            if (spielFigur.BarriereLinks())
            {
                Point ol = new Point(spielFigur.BlockGrenzeLinks(), Program.BILDHOEHE - spielFigur.BodenHoeheLinks());  //Punkt oben links
                ganzesBild.DrawLine(Pens.Black, ul, ol);
            }

        }

        //Male Verfolger gemäß Bewegung
        void verfolgerMalen()
        {
            if (level.LevelNummer <= 12)
            {
                verfolger.XSpeed = 0;
            }
            else if (level.LevelNummer <= 15)
                verfolger.XSpeed = 1;
            else if (level.LevelNummer <= 18)
                verfolger.XSpeed = 2;
            else
                verfolger.XSpeed = 3;
            
            if (count % 3 == 0)
                verfolger.X += verfolger.XSpeed;

            ganzesBild.DrawLine(Pens.Red, verfolger.X, -100, verfolger.X, Program.BILDHOEHE+100);
        }

        //Male Figur gemäß Bewegung
        void figurMalen()
        {
            ganzesBild.DrawImage( figurBild, new Rectangle(spielFigur.X - 10, Program.BILDHOEHE - spielFigur.Y, 20, 25), 
                                  spriteXPos, spriteYPos, 20, 25, GraphicsUnit.Pixel);
        }

        //Gib das Bild weiter an die Hauptform zur Anzeige
        void bildSenden(Bitmap bild)
        {
            //Folgende if-Verzweigung sendet das fertig gemalte Bild zur Anzeige.
            //Wenn man es schafft (ist eher selten, aber kommt vor), das Spiel zu beenden, wenn man gerade im falschen Moment kurz vorm Senden ist, 
            //wird eine InvalidAsynchronousStateException geworfen. Dies wird hier abfgefangen.
            //Die catch-Klausel macht nichts, da ja hier das Programm zuende ist.
            if (MaleBildEvent != null)
            {
                try
                {
                    context.Send(_ => MaleBildEvent(this, bild), null);     //Sende fertig gemaltes Bild zur Anzeige
                }
                catch (InvalidAsynchronousStateException) { }
            }
        }

    }
}
