﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PsychoTerror
{
    //Enthält Eigenschaften der Spielfigur
    class SpielFigur
    {
        Level level;

        //Konstruktor
        public SpielFigur(Level level)
        {
            this.level = level;

            XSpeed = 0;
            YSpeed = 0;
            X = 0;
            Y = 0;
            JumpInit = false;
            Lives = 5;
        }
        
        public int XSpeed { get; set; }             //set in BildBuffer
        public int YSpeed { get; set; }             //set in BildBuffer
        public int X { get; set; }                  //set in BildBuffer
        public int Y { get; set; }                  //set in BildBuffer

        public bool JumpInit { get; set; }      //set in Hauptform
        public bool RechtsInit { get; set; }    //set in Hauptform
        public bool LinksInit { get; set; }     //set in Hauptform
        public bool LevelAnfang { get; set; }   //set in Hauptform

        public int Lives { get; set; }  //set in Hauptform

        public int Block()             //Hole Nummer des aktuellen Blocks
        {
            if (X >= 0 && X < Program.BILDBREITE)
                return (level.Landschaft.Length * X / Program.BILDBREITE);
            else
                return -1; //Fehlercode, falls man außerhalb des Bildes ist
        }

        public int BodenHoeheLinks()   //Hoehe des linken Blocks
        {
            var index = Block();

            if (index == 0)
            {
                return 10000;   //Wenn man im ganz linken Block ist, ist die Höhe quasi unendlich
            }
            else if(index == -1)
            {
                return -1;      //Fehlercode
            }
            else
            {
                return level.Landschaft[index - 1];
            }
        }

        public int BodenHoehe()        //Hole Bodenhoehe des aktuellen Blocks
        {
            var index = Block();

            if (index == -1)
                return -1;  //Fehlercode, falls man außerhalb des Bildes ist
            else
                return level.Landschaft[index];
        }

        public int BodenHoeheRechts()   //Hoehe des rechten Blocks
        {
            var index = Block();

            if (index == level.Landschaft.Length - 1)
            {
                return 10000;   //Wenn man im ganz rechten Block ist, ist die Höhe quasi unendlich
            }
            else if (index == -1)
            {
                return -1;      //Fehlercode
            }
            else
            {
                return level.Landschaft[index + 1];
            }
        }

        public int BlockGrenzeLinks()  //Ort der linken Grenze des aktuellen Blocks
        {
            return (Block() * Program.BILDBREITE / level.Landschaft.Length);
        }

        public int BlockGrenzeRechts() //Ort der rechten Grenze des aktuellen Blocks
        {
            return ((Block() + 1) * Program.BILDBREITE / level.Landschaft.Length);
        }

        public int AbstGrenzeLinks()   //Abstand zur linken Blockgrenze
        {
            return X - BlockGrenzeLinks();
        }

        public int AbstGrenzeRechts()  //Abstand zur rechten Blockgrenze
        {
            return BlockGrenzeRechts() - X;
        }

        public bool BarriereLinks()    //Gibt an, ob man nahe einer linken Barriere ist
        {
            if (AbstGrenzeLinks() >= 0 && AbstGrenzeLinks() < 12 && BodenHoeheLinks() > Y)
                return true;
            else
                return false;
        }

        public bool BarriereRechts()    //Gibt an, ob man nahe einer rechten Barriere ist
        {
            if (AbstGrenzeRechts() >= 0 && AbstGrenzeRechts() < 12 && BodenHoeheRechts() > Y)
                return true;
            else
                return false;
        }

        public bool ErlaubterBereich()  //Falls die Figur durch einen Fehler in einen unmöglichen Bereich kommt -> false
        {
            if (AbstGrenzeLinks() < 0 || AbstGrenzeRechts() < 0 || Y < BodenHoehe())
                return false;
            else
                return true;
        }
    }
}
