﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.Diagnostics;

namespace Sudoku
{

    // Klasse zum Erstellen von gelösten Sudokus

    class SudokuSolver
    {
        int randoms = 5;                // Anzahl der Zufallszahlen, die zum Generieren eingetragen werden
        int counter = 0;                // Anzahl eingetragener Zahlen beim Lösungsversuch
        bool generating = false;
        double stopAt = System.Math.Exp(Globals.SIZE) / ((int)Globals.SIZE / 4);
        bool stop = false;              // Abbruch beim Generieren, falls mehr als stopAt Zahlen beim lösen eingetragen wurden

        byte[,] field;
        public byte[,] Field{ get { return field; } }

        SynchronizationContext sync;
        Action progressChangedCallback;


        // Vorgabe generieren

        public SudokuSolver(SynchronizationContext sync, Action progressChangedCallback)
        {
            field = new byte[Globals.SIZE, Globals.SIZE];
            this.sync = sync;
            this.progressChangedCallback = progressChangedCallback;
            generating = true;
            Random rand = new Random();

            while (true)
            {
                for (int i = 0; i < randoms; i++)
                {
                    int row = rand.Next(Globals.SIZE);
                    int column = rand.Next(Globals.SIZE);

                    field[row, column] = (byte)rand.Next(Globals.SIZE + 1);
                    if (!this.testOK(row, column))
                        field[row, column] = 0;
                }
                try
                {
                    this.solve();
                    break;
                }
                catch (NotSolveableExeption)
                {
                    Array.Clear(field, 0, Globals.TOTAL);
                    counter = 0;
                    stop = false;
                }
            }
        }

        // Übergebenes Array lösen

        public SudokuSolver(byte[,] array, SynchronizationContext sync, Action progressChangedCallback)
        {
            field = new byte[Globals.SIZE, Globals.SIZE];
            for (int row = 0; row < Globals.SIZE; row++)
                for (int column = 0; column < Globals.SIZE; column++)
                {
                    int[] pos = new int[] { row, column };
                    this.field.SetValue(array.GetValue(pos), pos);
                }
            this.sync = sync;
            this.progressChangedCallback = progressChangedCallback;

            if (!this.testOK())
                throw new NotSolveableExeption();
            this.solve();
        }


        // Rekursives Lösen des Arrays

        private void solve()
        {
            int row = nextEmpty()[0];
		    int column = nextEmpty()[1];
		    byte i = 1;
		    while (i <= Globals.SIZE)
            {
			    field[row,column]= i;

                RaiseProgressChanged();

                // Abbruch beim Generieren, falls die Anfangszahlen zu schlecht sind
                if (generating && counter >= stopAt)
                {
                    counter = 0;
                    stop = true;
                    throw new NotSolveableExeption();
                }

                if (testOK(row, column))
                {
                    if (testFull())
                        return;
                    else
                    {
                        try
                        {
                            solve();
                            return;
                        }
                        catch (NotSolveableExeption)
                        {
                            if (stop)
                                throw new NotSolveableExeption();
                            else
                                i++;
                        }
                    }
                }
                else
                    i++;
		    }
		    field[row,column]=0;
		    throw new NotSolveableExeption();
        }


        // Hilfsfunktionen

        private int[] nextEmpty()
        {
            int[] empty = new int[2];

            for (int row = 0; row < Globals.SIZE; row++)
                for (int column = 0; column < Globals.SIZE; column++)
                    if (field[row, column] == 0)
                    {
                        empty[0] = row;
                        empty[1] = column;
                        return empty;
                    }
            return empty;
        }

        private bool testOK(int row, int column)
        {
            List<int> listRow = new List<int>();
            List<int> listColumn = new List<int>();
            List<int> listBox = new List<int>();

            for(int i = 0; i < Globals.SIZE; i++)
            {
                if (field[row, i] != 0)
                    listRow.Add(field[row, i]);
                if (field[i, column] != 0)
                    listColumn.Add(field[i, column]);
            }
            
            int[] boxPos = new int[2];
            for (int help = 0; help < Globals.BOXSIZE; help++)
                if (row - (help * Globals.BOXSIZE) - Globals.BOXSIZE < 0)
                {
                    boxPos[0] = help;
                    break;
                }
            for (int help = 0; help < Globals.BOXSIZE; help++)
                if (column - (help * Globals.BOXSIZE) - Globals.BOXSIZE < 0)
                {
                    boxPos[1] = help;
                    break;
                }

            for (int i = boxPos[0]*Globals.BOXSIZE; i < boxPos[0]*Globals.BOXSIZE + Globals.BOXSIZE; i++)
                for (int j = boxPos[1]*Globals.BOXSIZE; j < boxPos[1]*Globals.BOXSIZE + Globals.BOXSIZE; j++)
                {
                    if (field[i, j] != 0)
                    listBox.Add(field[i, j]);
                }

            if (listRow.Distinct().LongCount() != listRow.LongCount()) return false;
            if (listColumn.Distinct().LongCount() != listColumn.LongCount()) return false;
            if (listBox.Distinct().LongCount() != listBox.LongCount()) return false;

            return true;
        }

        private bool testOK()
        {
            for (int row = 0; row < Globals.SIZE; row++)
                    if (!testOK(row, row))
                        return false;
            return true;
        }

        private bool testFull()
        {
            for (int row = 0; row < Globals.SIZE; row++)
                for (int column = 0; column < Globals.SIZE; column++)
                    if (field[row, column] == 0)
                        return false;
            return true;
        }

        private void RaiseProgressChanged()
        {
            counter++;
            Debug.WriteLine("Counter: " + counter);
            if (counter % Globals.SIZE == 0)
            {
                if (progressChangedCallback != null)
                    sync.Send(new SendOrPostCallback(o => progressChangedCallback()), null);
            }
        }
    }
}
