﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.IO;


namespace Sudoku
{
    public partial class SettingsForm : Form
    {
        SynchronizationContext sync;
        SudokuSolver generated;
        MainForm fenster;


        public SettingsForm()
        {
            InitializeComponent();
            var possibilities = Enum.GetNames(typeof(Severity));
            chooseSeverity.Items.AddRange(possibilities);
            chooseInput.SelectedIndex = 0;
            chooseSeverity.SelectedIndex = 1;
            chooseSize.SelectedIndex = 1;
        }


        // Events der Buttons und der Comboboxs
        
        async private void ok_Click(object sender, EventArgs e)
        {
            switch (chooseSize.SelectedIndex)
            {
                case 0: 
                    Globals.BOXSIZE = 2;
                    break;
                case 1:
                    Globals.BOXSIZE = 3;
                    break;
                case 2:
                    Globals.BOXSIZE = 4;
                    break;
            }

            if (chooseInput.SelectedIndex == 1)
            {
                enabler(true);
                await sudokuAsyncGenerator();
                enabler(false);
                fenster = new MainForm(generated, (Severity)chooseSeverity.SelectedIndex);
            }
            else
            {
                fenster = new MainForm();
            }
            fenster.Show();
        }

        private void chooseInput_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (chooseInput.SelectedIndex == 1)
                chooseSeverity.Visible = true;
            else 
                chooseSeverity.Visible = false;
        }

        private void chooseSize_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (chooseSize.SelectedIndex == 2)
            {
                info1.Visible = true;
                info2.Visible = true;
                info3.Visible = true;
            }
            else
            {
                info1.Visible = false;
                info2.Visible = false;
                info3.Visible = false;
            }
        }

        private void load_Click(object sender, EventArgs e)
        {
            SudokuInfos infos = SudokuInfos.Load();
            if (infos != null)
            {
                fenster = new MainForm(infos.GetArray(), infos.Labels, infos.Hints);
                fenster.Show();
            }
        }

        private void quit_Click(object sender, EventArgs e)
        {
            this.Close();
        }


        // Hilfsfunktion, generiert asynchron das Sudoku

        private Task sudokuAsyncGenerator()
        {
            int progress = 0;
            sync = SynchronizationContext.Current;
            return Task.Run(() =>
            {
                generated = new SudokuSolver(sync, () =>
                {
                    progress++;
                    progressBar.Value = (int)(Math.Tanh(Math.Sqrt(progress)/10) * 100);
                });
            });
        }


        private void enabler(bool running)
        {
                progressBar.Visible = running;
                ok.Enabled = !running;
                chooseInput.Enabled = !running;
                chooseSeverity.Enabled = !running;
                chooseSize.Enabled = !running;
                load.Enabled = !running;
        }
    }
}
