﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Data;

namespace WindowsFormsApplication1
{
    public delegate void AntEventHandler(Ant sender, AntEventArgs e);

    public class Ant
    {
        public Form1 form1
        {
            get;
            set;
        }
        public event AntEventHandler GivePosition;
        int[] position;
        int numberofcolors;
        int size;
        public int speed
        {
            get;
            set;
        }
        List<int> leftcolors;
        List<int> rightcolors;
        string comefrom;
        int currentcolornumber;
        int colornumber;
        Color color;
        Graphics g;
        Bitmap bmp;
        int[,] drawingcolors;
        Random random;
        long steps = 0;
        BackgroundWorker worker;
        DoWorkEventArgs e;
        bool farbeschonda;

        public Ant(int width, int height, Daten eingabeDaten, BackgroundWorker Worker,int Speed)
        {
            e = new DoWorkEventArgs(worker);
            worker = Worker;
            position = eingabeDaten.ZeichenPosition;
            rightcolors = eingabeDaten.RightColors;
            leftcolors = eingabeDaten.LeftColors;
            numberofcolors = eingabeDaten.NumberOfColors;
            size = eingabeDaten.size;
            speed = Speed;
            random = new Random();
            bmp = new Bitmap(width, height);
            g = Graphics.FromImage(bmp);
            drawingcolors = new int[numberofcolors + 1, 3];
            drawingcolors[0, 0] = drawingcolors[0, 1] = drawingcolors[0, 2] = 0;
            for (int i = 1; i <= numberofcolors; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    drawingcolors[i, j] = random.Next(0, 255);
                }
                if (i > 1)
                {
                    while (true)
                    {
                        farbeschonda = false;
                        for (int k = 1; k < i; k++)
                        {
                            if ((drawingcolors[i, 0] == drawingcolors[k, 0]) && (drawingcolors[i, 1] == drawingcolors[k, 1]) && (drawingcolors[i, 2] == drawingcolors[k, 2]))
                            {
                                for (int l = 0; l < 3; l++)
                                {
                                    drawingcolors[i, l] = random.Next(0, 255);
                                    farbeschonda = true;
                                }
                            }
                        }
                        if (!farbeschonda)
                            break;
                    }
                }
            }
        }

        public DoWorkEventArgs WalkTheAnt()
        {
            bmp = DrawRectangle(position, Color.FromArgb(drawingcolors[1, 0], drawingcolors[1, 1], drawingcolors[1, 2]), bmp);
            form1.done = false;
            if (GivePosition != null)
            {
                steps++;
                GivePosition(this, new AntEventArgs { Position = position, Steps = steps, Worker = worker, Farbe = Color.FromArgb(drawingcolors[1, 0], drawingcolors[1, 1], drawingcolors[1, 2]) });
            }
            while (!form1.done) ;
            foreach (var element in rightcolors)
                if (element == 1)
                {
                    GoRight();
                    break;
                }
            foreach (var element in leftcolors)
                if (element == 1)
                {
                    GoLeft();
                    break;
                }
            System.Threading.Thread.Sleep(speed);
            Color pix; int width = bmp.Width, height = bmp.Height;
            while ((position[0] >= 0) && (position[0] <= (width - size)) && (position[1] >= 0) && (position[1] <= (height - size)))
            {
                if (worker.CancellationPending)
                {
                    e.Cancel = true;
                    return e;
                }
                pix = bmp.GetPixel(position[0] + 1, position[1] + 1);
                for (int i = 0; i <= numberofcolors; i++)
                {
                    if (pix == Color.FromArgb(pix.A, drawingcolors[i, 0], drawingcolors[i, 1], drawingcolors[i, 2]))
                    {
                        currentcolornumber = i;
                        break;
                    }
                }
                if (currentcolornumber == 0)
                {
                    color = Color.FromArgb(drawingcolors[1, 0], drawingcolors[1, 1], drawingcolors[1, 2]);
                    colornumber = 1;
                }
                else
                {
                    if (currentcolornumber == numberofcolors)
                    {
                        color = Color.FromArgb(drawingcolors[1, 0], drawingcolors[1, 1], drawingcolors[1, 2]);
                        colornumber = 1;
                    }
                    for (int i = 1; i < numberofcolors; i++)
                    {
                        if (currentcolornumber == i)
                        {
                            color = Color.FromArgb(drawingcolors[i + 1, 0], drawingcolors[i + 1, 1], drawingcolors[i + 1, 2]);
                            colornumber = i + 1;
                            break;
                        }
                    }
                }

                bmp = DrawRectangle(position, color, bmp);
                form1.done = false;
                if (GivePosition != null)
                {
                    steps++;
                    GivePosition(this, new AntEventArgs { Position = position, Steps = steps, Worker = worker, Farbe = color });
                }
                System.Threading.Thread.Sleep(speed);
                while (!form1.done) ;

                foreach (var element in rightcolors)
                {
                    if (colornumber == element)
                    {
                        switch (comefrom)
                        {
                            case "up":
                                GoLeft();
                                break;
                            case "down":
                                GoRight();
                                break;
                            case "left":
                                GoDown();
                                break;
                            case "right":
                                GoUp();
                                break;
                        }
                        break;
                    }
                }
                foreach (var element in leftcolors)
                {
                    if (colornumber == element)
                    {
                        switch (comefrom)
                        {
                            case "up":
                                GoRight();
                                break;
                            case "down":
                                GoLeft();
                                break;
                            case "left":
                                GoUp();
                                break;
                            case "right":
                                GoDown();
                                break;
                        }
                        break;
                    }
                }
            }
            e.Cancel = true;
            return e;
        }

        private void GoUp()
        {
            position[1] -= size;
            comefrom = "down";
        }

        private void GoDown()
        {
            position[1] += size;
            comefrom = "up";
        }

        private void GoLeft()
        {
            position[0] -= size;
            comefrom = "right";
        }

        private void GoRight()
        {
            position[0] += size;
            comefrom = "left";
        }

        private Bitmap DrawRectangle(int[] position, Color color, Bitmap bmp)
        {
            //g.SmoothingMode = SmoothingMode.AntiAlias;
            g.FillRectangle(new SolidBrush(color), new Rectangle(position[0], position[1], size, size));
            return bmp;
        }
    }
}
