﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public int speed
        { get; set; }
        public bool done
        {
            get;
            set;
        }
        Graphics g;
        BackgroundWorker bg;
        Ant ant;
        public int size
        {
            get;
            set;
        }
        struct Zeug
        {
            public Color farbe;
            public int[] position;
            public long steps;
        }
        Daten daten;
        Form2 control;

        public Form1()
        {
            daten = new Daten();
            InitializeComponent();
            control = new Form2();
            control.form1 = this;
            control.daten = this.daten;
            pictureBox1.BackColor = Color.FromArgb(255, 255, 255);
            bg = new BackgroundWorker();
            bg.WorkerSupportsCancellation = true;
            bg.WorkerReportsProgress = true;
            bg.DoWork += new DoWorkEventHandler(bg_DoWork);
            bg.ProgressChanged += new ProgressChangedEventHandler(bg_ProgressChanged);
            //bg.RunWorkerCompleted += new RunWorkerCompletedEventHandler(bw_RunWorkerCompleted);
            label1.BackColor = Color.FromArgb(255, 255, 255);
        }

        private void bg_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = sender as BackgroundWorker;
            ant = new Ant(pictureBox1.Width, pictureBox1.Height, daten, worker,speed);
            ant.GivePosition += ant_GivePosition;
            ant.form1 = this;
            control.ant = this.ant;
            e.Cancel=ant.WalkTheAnt().Cancel;
        }

        private void ant_GivePosition(object sender, AntEventArgs e)
        {
            Zeug zeug = new Zeug();
            zeug.position=e.Position;
            zeug.steps=e.Steps;
            zeug.farbe = e.Farbe;
            e.Worker.ReportProgress(50, zeug);
        }

        private void bg_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            Zeug zeug = (Zeug)e.UserState;
            Color Farbe = zeug.farbe;
            daten.ZeichenPosition = zeug.position;
            DrawRectangle(daten.ZeichenPosition, Farbe);
            this.label1.Text = "Anzahl der Schritte: "+zeug.steps.ToString();
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            g = Graphics.FromHwnd(pictureBox1.Handle);
            Point MouseDownPosition = e.Location;
            daten.ZeichenPosition[0] = MouseDownPosition.X;
            daten.ZeichenPosition[1] = MouseDownPosition.Y;
            if (!bg.IsBusy)
            {
                pictureBox1.Invalidate();
                bg.RunWorkerAsync();
            }
            else
            {
                bg.CancelAsync();
                //bg.RunWorkerAsync();
            }
        }

        private void DrawRectangle(int[] position, Color color)
        {
            g.FillRectangle(new SolidBrush(color), new Rectangle(position[0], position[1], daten.size, daten.size));
            done = true;
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            control.Show();
            control.Activate();
        }
    }
}
