﻿(function() {
	var loop;
	var speed = 0;
	var maxSpeed = 300;
	var speedup = 1.1;
	var gameRunning = true;
	var score = 0;
	var space = 281;
	var spaceTrucks = 400;
	var colision = [];
	colision[0] = [false, false, false];
	colision[1] = [false, false, false];
	
	var canvas = document.getElementById("canvas");
	var context = canvas.getContext('2d');
	var sprites = [];
	
	var crashSound = $("#crash").get(0);
	crashSound.playbackRate = 1.5;
	
	var car1 = new Car();
	
	var truck1 = new Truck();
	var truck_big1 = new TruckBig();
	var enemyCar1 = new EnemyCar();
	enemyCar1.setPosition(0);	
	var enemyCar2 = new EnemyCar();
	enemyCar2.setPosition(1);
	var enemyCar3 = new EnemyCar();
	enemyCar3.setPosition(0);	
	var enemyCar4 = new EnemyCar();
	enemyCar4.setPosition(1);
	
	var background1 = new Background();
	var explosionImage = new Image();
	explosionImage.src = 'explosion.png';
	explosionImage.onload = function() {
		// TODO
	};
	
	var trees = []
	for(var i = 0; i < 6; i++)
		trees[i] = new Tree();
	
	window.requestAnimFrame = (function() {
		return  window.requestAnimationFrame ||
				window.webkitRequestAnimationFrame ||
				window.mozRequestAnimationFrame ||
				function (callback){ window.setTimeout(callback, 1000 / 60); };
	})();
	
	function draw() {
		context.clearRect(0, 0, canvas.width, canvas.height);
		background1.draw();
		truck1.draw();
		truck_big1.draw();
		enemyCar1.draw();
		enemyCar2.draw();
		enemyCar3.draw();
		enemyCar4.draw();
		car1.draw();
		
		for (var i = trees.length; i--; )
			trees[i].draw();
			
		//Speed rechts unten anzeigen
		context.fillStyle = "#00F";
		context.strokeStyle = "#F00";
		context.font = "20px Arial";
		context.fillText("Speed: " + parseInt(speed) + " km/h", canvas.width - 160, canvas.height - 10);
		
		//Score rechts oben anzeigen
		context.fillStyle = "#00F";
		context.strokeStyle = "#F00";
		context.font = "20px Arial";
		context.fillText("Score: " + parseInt(score), canvas.width - 160, 20);
		
		for (var i = sprites.length; i--;) {
			sprites[i].draw(90 + 100 * car1.getPosition() - 80, canvas.height - 140 -40 -50, 250, 250);
		}
		
		requestAnimFrame(draw);
	}
	
	function update(){
			
		for (var i = sprites.length; i--;) {
			if (sprites[i].update())
				sprites.splice(i, 1);
			else{
				car1.draw = function(){};
			}
		}
		
		if (gameRunning) {	
			if(speed < maxSpeed)
				speed += speedup;
				
			score += 0.1;
			
			car1.update();
			
			truck1.update(0);
			truck_big1.update(1);
			enemyCar1.update(0);
			enemyCar2.update(0);
			enemyCar3.update(1);
			enemyCar4.update(1);
			
			background1.update();
			for (var i = trees.length; i--; )
				trees[i].update();
			
			//Bäume zufällig erzeugen
			for(var i = 0; i < 6; i++){
				if(Math.random() < 1 / 12 && !trees[i].isShown()){
					trees[i].show();
					if(Math.random() < 0.5)
						trees[i].isLeft(false);
					else
						trees[i].isLeft(true);
				}				
				trees[i].draw();
			}
			
			if(speed - 60 > 0)
				spaceTrucks += (speed - 60) /12;
			if(!truck1.isShown() && Math.random() < 0.005 && spaceTrucks > 10 + 260){
				truck1.show();
				spaceTrucks = 0;
			}
			
			if(!truck_big1.isShown() && Math.random() < 0.005 && spaceTrucks > 10 + 320){
				truck_big1.show();
				spaceTrucks = 0;
			}
			
			if(speed - 150 > 0)
				space += (speed - 150) /12;
			if(!enemyCar1.isShown() && Math.random() < 0.05 && space > 300){
				enemyCar1.show();
				space = 0;
			}
			
			if(!enemyCar2.isShown() && Math.random() < 0.05 && space > 300){
				enemyCar2.show();
				space = 0;
			}
			if(!enemyCar3.isShown() && Math.random() < 0.05 && space > 300){
				enemyCar3.show();
				space = 0;
			}
			
			if(!enemyCar4.isShown() && Math.random() < 0.05 && space > 300){
				enemyCar4.show();
				space = 0;
			}
			
			//Auf Kolision überprüfen
			if (colision[0][car1.getPosition()] || colision[1][car1.getPosition()]){
				speed = 0;
				sprites.push(new Sprite(explosionImage, 64, 64));
				crashSound.play();
				gameRunning = false;
			}
		}
	}
	
	var Sprite = function(img, w, h, frames) {
		var index = 0;
		var delay = 0;
		var cols = Math.floor(img.width / w);
		var rows = Math.floor(img.height / h);
		this.batch = 5;
		
		if (!frames) {
			frames = [];
			for (var i = 0; i < rows; i++) {
				for(var j = 0; j < cols; j++)
					frames.push({ x : j, y : i });
			}
		}
		
		this.draw = function(x, y, width, height) {
			var pos = frames[index];
			var sx = pos.x * w;
			var sy = pos.y * h;
			context.drawImage(img, sx, sy, w, h, x, y, width ? width : w, height ? height : h);
		};
		this.update = function() {
			delay++;
			if (delay === this.batch) {
				delay = 0;
				index = (index + 1) % frames.length;
				return !index;
			}
			
			return false;
		};
	};
	
	//Tastatureingaben abfangen
	document.onkeydown = function(e){
		if(!gameRunning)
			return;
		if(e.keyCode == 37){
			car1.turnLeft();
		}
		if(e.keyCode == 39){
			car1.turnRight();
		}
	}
	
	
	
	function Car() {
		//Position =>  Links: 0; Mitte: 1; Rechts: 2
		var position = 1;
		
		var x;
		var y;
		
		var carImg = new Image();
		carImg.src = "Car.png";
		var isLoaded = false;
		
		carImg.onload = function(){
			isLoaded = true;
		}
		
		this.draw = function(){
			if(isLoaded){
				context.drawImage(carImg, x, y, 100, 140);
			}
		}
		
		this.update = function(){
			x = 90 + 100 * position;
			y = canvas.height - 140 - 40;
		}
		
		this.turnLeft = function(){
			if(position > 0){
				position--;
			}
		}
		
		this.turnRight = function(){
			if(position < 2){										
				position++;
			}
		}
		
		this.getPosition = function(){
			return position;
		}
	}
	
	function Background(){
		var count = 0;
		var bgImg = new Image();
		bgImg.src = "background.jpg";
		var isLoaded = false;
		
		var yPositions = [];
		for(var i = 0; i < 8; i++)
			yPositions[i] = (i - 1) * 100;
		
		bgImg.onload = function(){
			isLoaded = true;
		}
		
		this.draw = function(){
			if(isLoaded){
				for(var i = 0; i < yPositions.length; i++){
					context.drawImage(bgImg, 0, yPositions[i]);	
				}
			}
		}
		
		this.update = function(){
				for(var i = 0; i < yPositions.length; i++){
					yPositions[i] = (i - 1)*100 + count%100;
				}
				count += speed / 12;
		}
	}
	
	function Tree(){
		var y = 0;
		var treeImg = new Image();
		treeImg.src = "tree.png";
		this.isLoaded = false;
		var isShown = false;
		
		var left = true;
		
		this.y = -100;
		
		treeImg.onload = function(){
			isLoaded = true;
		}
		
		this.draw = function(){
			if(isShown){
				context.drawImage(treeImg, left ? 0 : canvas.width - 86, -100 + y);						
			}
		}
		
		this.update = function(){
			y += speed / 12;
		}
		
		this.isLeft = function(isLeft){
			left = isLeft;
		}
		
		this.setY = function(setY){
			y = setY;
		}
		
		this.isShown = function(){
			if(y - 100 < canvas.height && isShown)
				return true;
			return false;
		}
		
		this.show = function(){
			y = 0;
			isShown = true;
		}
	}
	
	function Truck(){
		this.position = 2;
		var count = 0;
		var truckSpeed = 60;
		var x = 90 + 100 * this.position;;
		var y = -200;
		
		var isShown = false;
		
		var truckImg = new Image();
		truckImg.src = "truck_small.png";
		
		var isLoaded = false;
		truckImg.onload = function(){
			isLoaded = true;
		}
		this.draw = function(){
			if(isLoaded){
				context.drawImage(truckImg, x, y);
			}
		}
	
		this.update = function(id){
			if(isShown && y < canvas.height){
				x = 90 + 100 * this.position;
				y = count - 200;
				count += (speed - truckSpeed) / 12;
			
				if(y + 200 > canvas.height - 140 - 40 && y < canvas.height - 40)
					colision[id][this.position] = true;
				else
					colision[id][this.position] = false;
			}
		}
		
		this.show = function(){
			count = 0;
			y = -200;
			isShown = true;
		}
		
		this.isShown = function(){
			if(y < canvas.height && isShown)
				return true;
			return false;
		}
	}
	
	function TruckBig(){
		this.position = 2;
		var count = 0;
		var truckSpeed = 60;
		var x = 90 + 100 * this.position;
		var y = -300;
		
		var isShown = false;
		
		var truckImg = new Image();
		truckImg.src = "truck_big.png";
		
		var isLoaded = false;
		truckImg.onload = function(){
			isLoaded = true;
		}
		this.draw = function(){
			if(isLoaded){
				context.drawImage(truckImg, x, y);
			}
		}
	
		this.update = function(id){
			if(isShown && y < canvas.height){
				x = 90 + 100 * this.position;
				y = count - 300;
				count += (speed - truckSpeed) / 12;
			
				if(y + 300 > canvas.height - 140 - 40 && y < canvas.height - 40)
					colision[id][this.position] = true;
				else
					colision[id][this.position] = false;
			}
		}
		
		this.show = function(){
			count = 0;
			y = -300;
			isShown = true;
		}
		
		this.isShown = function(){
			if(y < canvas.height && isShown)
				return true;
			return false;
		}
	}
	
	function EnemyCar(){
		this.position = 0;
		var count = 0;
		var carSpeed = 150;
		var x = 90 + 100 * this.position;
		var y = -140;
		
		var isShown = false;
		
		var carImg = new Image();
		
		var isLoaded = false;
		carImg.onload = function(){
			isLoaded = true;
		}
		this.draw = function(){
			if(isLoaded){
				context.drawImage(carImg, x, y);
			}
		}
	
		this.update = function(id){
			if(isShown && y < canvas.height){
				x = 90 + 100 * this.position;
				y = count - 140;
				count += (speed - carSpeed) / 12;
			
				if(y + 140 > canvas.height - 140 - 40 && y < canvas.height - 40)
					colision[id][this.position] = true;
				else
					colision[id][this.position] = false;
			}
		}
		
		this.show = function(){
			var random = Math.floor(Math.random() * 5);
			carImg.src = "enemy_car_" + random + ".png";
			count = 0;
			y = -140;
			isShown = true;
		}
		
		this.isShown = function(){
			if(y < canvas.height && isShown)
				return true;
			return false;
		}
		
		this.setPosition = function(position){
			this.position = position;
		}
		
		this.setSpeed = function(cspeed){
			carSpeed = cspeed;
		}
	}
	
	loop = setInterval(update, 25);
	draw();
})();