$(document).ready(function() {
	var c = document.getElementById("drawCanvas").getContext('2d'); 
	var showBallsC = document.getElementById("showBallsCanvas").getContext('2d');
	var showPickupsC = document.getElementById("showPickupsCanvas").getContext('2d');
	var helpBallsC = document.querySelector('#help li:nth-child(1) canvas').getContext('2d');
	var helpPickupsC = document.querySelector('#help li:nth-child(2) canvas').getContext('2d');
	var helpSpidersC = document.querySelector('#help li:nth-child(3) canvas').getContext('2d'); 
	var helpArrowsC = document.querySelector('#help li:nth-child(4) canvas').getContext('2d'); 
	var a = document.getElementById('audio');
	var brickSound = document.getElementById('brickSound'); 
	var spiderSound = document.getElementById('spiderSound'); 
	var BALLR = 7; 
	var BORDERRADIUS = 8;
	var SPIDERRADIUS = 20; 
	var PADDLEWIDTH = 100; 
	var PADDLEHEIGHT = 20; 
	var BRICKWIDTH = 100; 
	var BRICKHEIGHT = 20;
	var PaddleX = c.canvas.width/2-PADDLEWIDTH;
	var PaddleY = c.canvas.height-30;
	var BallDx = c.canvas.width/2;
	var BallDy = c.canvas.height/2;
	var logicLoop; 
	var game;
	var lost; 
	var won; 
	var catched; 
	var levelGame; 
	var currentLevel;
	var highestLevel = getHighestLevel(); 
	var displayHighestLevel; 
	var ballCount;
	var RowCount;
	var pickupsCount; 
	var spiderCount; 
	var ball;
	var bricks; 
	var pickups; 
	var spiders; 
	var randomNumberArray = []; 
	var BallSpeedX; 
	var BallSpeedY;
	var PickupSpeedX; 
	var PickupSpeedY; 
	var SpiderSpeedX; 
	var SpiderSpeedY; 
	var PaddleSpeed; 
	var pickupsCountDisplay; 
	var PickupRotation; 
	var BrickBeginColor = "rgb(238,180,180)";
	var BrickEndColor = "rgb(205,155,155)";
	var BrickStrokeColor = "rgb(139,105,105)";
	var BrickBeginColorArray = ["rgb(0,49,208)", "rgb(88,170,0)", "rgb(218,86,77)", "rgb(216,128,69)", "rgb(216,180,80)"]; 
	var BrickEndColorArray = ["rgb(0,26,114)", "rgb(60,114,0)", "rgb(218,40,27)", "rgb(216,103,27)", "rgb(216,165,27)"];
	var inputBuffer = {
		left : false,
		right : false
	};
	var requestAnimFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || function(f) { setTimeout(f, 30); };

	var levels = {
	"level": [
		//level 1
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 0
		}, 
		//level 2
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 0
		}, 
		//level 3
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 0
		}, 
		//level 4
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 3, 
			"pickupsCount": 12,
			"spiderCount": 0
		}, 
		//level 5
		{ 
			"ballSpeedX": 4,
			"ballSpeedY": 6, 
			"rowCount": 4, 
			"pickupsCount": 16,
			"spiderCount": 0
		}, 
		//level 6
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 5, 
			"pickupsCount": 20,
			"spiderCount": 0
		},
		//level 7
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 1
		}, 
		//level 8
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 1
		}, 
		//level 9
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 1
		}, 
		//level 10
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 1
		}, 
		//level 11
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 1
		},
		//level 12 
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 1
		}, 
		//level 13
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 2
		}, 
		//level 14
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 2
		}, 
		//level 15
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 2
		}, 
		//level 16
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 2
		}, 
		//level 17
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 2
		},
		//level 18 
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 2
		}, 
		//level 19
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 3
		}, 
		//level 20
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 3
		},
		//level 21 
		{ 
			"ballSpeedX": 3, 
			"ballSpeedY": 5, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 3
		}, 
		//level 22
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 3, 
			"pickupsCount": 6,
			"spiderCount": 3
		}, 
		//level 23
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 4, 
			"pickupsCount": 8,
			"spiderCount": 3
		},
		//level 24 
		{ 
			"ballSpeedX": 4, 
			"ballSpeedY": 6, 
			"rowCount": 5, 
			"pickupsCount": 10,
			"spiderCount": 3
		}
	]
}

	$('#game').hide();
	$('#back').hide();
	$('#help').hide();
	$('#levelSelect').hide();
	$('#options').hide();
	$('#winImg').hide();
	$('#looseImg').hide();
	$('#levelMessage').hide(); 
	$('#pauseButton').click(pause); 
	$('#beendenButton').click(stop);
	$('#neustartButton').click(restart); 
	$('#menue li:nth-child(1)').click(function(){ 
		start(speedSelect().speedX, speedSelect().speedY, brickSelect(), pickupSelect(), spiderSelect());
		levelGame = false; 
	}); 
	$('#menue li:nth-child(2)').click(options); 
	$('#menue li:nth-child(3)').click(levelSelect); 
	$('#menue li:nth-child(4)').click(help); 
	$('#back').click(back); 
	$('#levelEins').click(function(){ startLevel(0); }); 
	$('#levelZwei').click(function(){ startLevel(1); }); 
	$('#levelDrei').click(function(){ startLevel(2); }); 
	$('#levelVier').click(function(){ startLevel(3); }); 
	$('#levelFuenf').click(function(){ startLevel(4); }); 
	$('#levelSechs').click(function(){ startLevel(5); }); 
	$('#levelSieben').click(function(){ startLevel(6); }); 
	$('#levelAcht').click(function(){ startLevel(7); }); 
	$('#levelNeun').click(function(){ startLevel(8); }); 
	$('#levelZehn').click(function(){ startLevel(9); }); 
	$('#levelElf').click(function(){ startLevel(10); }); 
	$('#levelZwoelf').click(function(){ startLevel(11); }); 
	$('#levelDreizehn').click(function(){ startLevel(12); }); 
	$('#levelVierzehn').click(function(){ startLevel(13); }); 
	$('#levelFuenfzehn').click(function(){ startLevel(14); }); 
	$('#levelSechzehn').click(function(){ startLevel(15); }); 
	$('#levelSiebzehn').click(function(){ startLevel(16); }); 
	$('#levelAchzehn').click(function(){ startLevel(17); }); 
	$('#levelNeunzehn').click(function(){ startLevel(18); }); 
	$('#levelZwanzig').click(function(){ startLevel(19); });
	$('#levelEinundzwanzig').click(function(){ startLevel(20); }); 
	$('#levelZweiundzwanzig').click(function(){ startLevel(21); }); 
	$('#levelDreiundzwanzig').click(function(){ startLevel(22); }); 
	$('#levelVierundzwanzig').click(function(){ startLevel(23); }); 
	$('#speedSelect').change(speedSelect); 
	$('#brickSelect').change(brickSelect); 
	$('#pickupSelect').change(pickupSelect); 
	$('#spiderSelect').change(spiderSelect); 

	document.onkeydown = keyPressed;
	document.onkeyup = keyReleased;
	
	function getHighestLevel() {
		var content = readCookie('highestLevel'); 
		if(!content) {
			return 0; 
		}
		return content*1; 
	}

	function startLevel(levelNR) {
		if(levelNR <= highestLevel){
			$('#levelSelect').hide(); 
			$('#back').hide(); 
			levelGame = true; 
			currentLevel = levelNR; 
			BallSpeedX = levels.level[levelNR].ballSpeedX; 
			BallSpeedY = levels.level[levelNR].ballSpeedY;
			RowCount  = levels.level[levelNR].rowCount;
			pickupsCount = levels.level[levelNR].pickupsCount;  
			spiderCount = levels.level[levelNR].spiderCount;
			start(BallSpeedX, BallSpeedY, RowCount, pickupsCount, spiderCount);
		}
	}
	function start(BallSpeedX1, BallSpeedY1, RowCount1, pickupsCount1, spiderCount1){
		$('#navigation').hide();
		$('#game').show();
		$('#winImg').hide();
		$('#looseImg').hide();
		$('#levelMessage').hide(); 
		playAudio(a); 
		game = true;
		lost = false; 
		won = false; 
		catched = false; 
		logicLoop = setInterval(updateLogic, 20);
		ballCount = 3;
		PickupSpeedX = 0; 
		PickupSpeedY = 0;
		PaddleSpeed = 10; 
		SpiderSpeedX = 0; 
		SpiderSpeedY = 0; 
		pickupsCountDisplay = 0; 
		PickupRotation = 0.05; 
		bricks = [];
		pickups = [];
		spiders = []; 
		setupBricks(RowCount1); 
		setupPickups(pickupsCount1);
		setupSpiders(spiderCount1);
		paddle = new Paddle(PaddleX,PaddleY,PADDLEWIDTH, PADDLEHEIGHT, BORDERRADIUS);
		ball = new Ball (BallDx, BallDy, BALLR, BallSpeedX1, BallSpeedY1);  
		drawCanvas(); 
		drawShowBallCanvas(showBallsC);
		drawShowPickupsCanvas(showPickupsC);
		$('#showPickups').html(pickupsCountDisplay +"/" + pickupsCount1);
		$('#pauseButton').html('Pause'); 
	}

	function pause() {
		if(!won){
			if (!game){
				logicLoop = setInterval(updateLogic, 20);
				game = true;
				a.play(); 
				ball.setSpeed(BallSpeedX, BallSpeedY);
				this.innerHTML = 'Pause';
				drawCanvas(); 
			} else {
				BallSpeedX = ball.getSpeedX();
				BallSpeedY = ball.getSpeedY();
				game = false;
				a.pause(); 
				clearInterval(logicLoop);
				ball.setSpeed(0, 0);
				this.innerHTML = 'Weiter';
			}
		}
		else {
			if(levelGame) {
				BallSpeedX = levels.level[highestLevel].ballSpeedX; 
				BallSpeedY = levels.level[highestLevel].ballSpeedY;
				RowCount  = levels.level[highestLevel].rowCount;
				pickupsCount = levels.level[highestLevel].pickupsCount;  
				spiderCount = levels.level[highestLevel].spiderCount;
				currentLevel++; 
				this.innerHTML = 'Nächstes Level'; 
			}
			else {
				
				this.innerHTML = 'Pause';
			}
			won = false; 
			start(BallSpeedX, BallSpeedY, RowCount, pickupsCount, spiderCount); 
		}
		
	}

	function stop() {
		$('#game').hide();
		$('#navigation').show();
		game = false;
		a.pause(); 
		clearInterval(logicLoop);
		ball.setSpeed(0, 0);
	}

	function restart() {
		stop();
		if(levelGame) {
			BallSpeedX = levels.level[currentLevel].ballSpeedX; 
			BallSpeedY = levels.level[currentLevel].ballSpeedY;
			RowCount  = levels.level[currentLevel].rowCount;
			pickupsCount = levels.level[currentLevel].pickupsCount;  
			spiderCount = levels.level[currentLevel].spiderCount;
		}
		else {
			BallSpeedX = speedSelect().speedX; 
			BallSpeedY = speedSelect().speedY;
			RowCount  = brickSelect();
			pickupsCount = pickupSelect();  
			spiderCount = spiderSelect();
		}
		start(BallSpeedX, BallSpeedY, RowCount, pickupsCount, spiderCount);
	}

	function help(){
		$('#back').show();
		$('#help').show();
		$('#navigation').hide();
		drawShowBalls(10, 10, 7,helpBallsC);
		drawEmptyBalls(10, 10, 7, helpBallsC)
		drawShowPickups(10, 10, 14, 14, helpPickupsC);
		drawShowArrows(15, 5, 25, 10, helpArrowsC); 
		var helpSpider = new Spider(10, 10, 5, SpiderSpeedX, SpiderSpeedY, helpSpidersC);
		helpSpider.draw();  
	}

	function levelSelect() {
		$('#back').show();
		$('#levelSelect').show();
		$('#navigation').hide();
		setNotActivatedClass(); 
	}

	function back(){
		$('#help').hide();
		$('#options').hide();
		$('#levelSelect').hide();
		$('#navigation').show();
		$('#back').hide();
	}

	function setNotActivatedClass() {
		var display = highestLevel+1; 
		for (var i = 0; i <= display; i++) {
			$('#levelSelect button:nth-child(' + i + ')').removeClass("notActivated"); 
		}
	}
	function createCookie(name, value, days) {
		var expires = '';
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
			expires = '; expires=' + date.toGMTString();
		}
			
		document.cookie = name + '=' + escape(value) + expires + '; path=/';
	}

	function readCookie(name) {
		var nameEQ = name + '=';
		var ca = document.cookie.split(';');
		for(var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') {
				c = c.substring(1, c.length);
			}
			if (c.indexOf(nameEQ) == 0) {
				return c.substring(nameEQ.length, c.length);
			}
		}
	}

	function speedSelect() {
		switch($('#speedSelect').get(0).selectedIndex){
			case 0: 
				BallSpeedX = 2; 
				BallSpeedY = 4;   
				break; 
			case 1: 
				BallSpeedX = 3; 
				BallSpeedY = 5; 
				break; 
			case 2: 
				BallSpeedX = 4; 
				BallSpeedY = 6; 
				break; 
		}
		return {
			speedX: BallSpeedX,
			speedY: BallSpeedY
		}
	}

	function brickSelect() {
		switch($('#brickSelect').get(0).selectedIndex){
			case 0: 
				RowCount = 1;
				break; 
			case 1: 
				RowCount = 2;
				break; 
			case 2: 
				RowCount = 3;
				break; 
			case 3: 
				RowCount = 4;
				break; 
			case 4: 
				RowCount = 5;
				break; 
		}
		return RowCount; 
	}

	function pickupSelect() {
		switch($('#pickupSelect').get(0).selectedIndex){
			case 0: 
				pickupsCount = 0;
				break; 
			case 1: 
				pickupsCount = 8/4 * RowCount;
				break; 
			case 2: 
				pickupsCount = 8/2 * RowCount;
				break; 
		}
		return pickupsCount; 
	}

	function spiderSelect() {
		switch($('#spiderSelect').get(0).selectedIndex){
			case 0: 
				spiderCount = 0;
				break; 
			case 1: 
				spiderCount = 1;
				break; 
			case 2: 
				spiderCount = 2;
				break; 
			case 3: 
				spiderCount = 3;
				break; 
		}
		return spiderCount; 
	}

	function options() {
		$('#back').show();
		$('#options').show(); 
		$('#navigation').hide();
	}

	function drawShowPickups(x, y, w, h, c) {
		c.translate(x, y);
		c.beginPath(); 
		c.moveTo(0-w/2, 0-h/2+h/3+h/15); 
		c.lineTo(0-w/2+w, 0-h/2+h/3+h/15); 
		c.lineTo(0-w/2+w/5, 0-h/2+h); 
		c.lineTo(0-w/2+w/2, 0-h/2); 
		c.lineTo(0-w/2+w/5*4, 0-h/2+h);
		c.lineTo(0-w/2, 0-h/2+h/3+h/15);
		c.fillStyle = "rgb(126,16,16)";
		c.fill();
	}

	function drawShowPickupsCanvas(c) {
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);
		c.save();
		drawShowPickups(10, 10, 14, 14, c); 
		c.restore();
	}

	function drawShowBallCanvas(c) {
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);
		c.save();
		showBalls();
		c.restore();
	}

	function setupBricks(RowCount1) {
		for(var y = 0, k = 0; y < RowCount1 * BRICKHEIGHT; y+=BRICKHEIGHT, k++) {
			for (var x = 0; x < c.canvas.width; x+=BRICKWIDTH){
				bricks.push(new Brick(x, y, BRICKWIDTH, BRICKHEIGHT, BrickBeginColorArray[k], BrickEndColorArray[k], BrickStrokeColor));
			}
		}
	}

	function setupPickups(count) {
		randomNumberArray = generateRandomNrArray(count); 

		for (var i = 0; i < bricks.length; i++){
			for(var k = 0; k < randomNumberArray.length; k++){
				if(randomNumberArray[k] == i){
					pickups[k] = new Pickup(bricks[i].getX()+BRICKWIDTH/2, bricks[i].getY()+BRICKHEIGHT/2, 20, 20, PickupSpeedX, PickupSpeedY, PickupRotation); 
				}
			} 
		}
	}

	function setupSpiders(count) {
		randomNumberArray = generateRandomNrArray(count); 

		for (var i = 0; i < bricks.length; i++){
			for(var k = 0; k < randomNumberArray.length; k++){
				if(randomNumberArray[k] == i){
					spiders[k] = new Spider(bricks[i].getX()+BRICKWIDTH/2, -20, SPIDERRADIUS, SpiderSpeedX, SpiderSpeedY, c); 
				}
			} 
		}
	}

	function contains(arr, o) {
		for (var i = 0; i < arr.length; i++) {
			if(arr[i] === o) {
				return true; 
			}
		}
		return false; 
	}

	function generateRandomNrArray(count) {
		r = []; 
		var randomNumber; 

		for (var i = 0; i < count; i++){
			randomNumber = Math.floor(Math.random()*bricks.length); 
			while(contains(r, randomNumber) == true) {
				randomNumber = Math.floor(Math.random()*bricks.length);  
			}
			r.push(randomNumber); 
		}

		return r;
	}

	function drawShowBalls(x, y, r, c) {
		c.beginPath(); 
		c.arc(x, y, r,0,2*Math.PI);
		c.fillStyle = "rgb(57,83,110)";
		c.fill();
		c.strokeStyle = "rgb(34, 70, 119)";
		c.lineWidth = 1;
		c.stroke();
	}

	function drawArrow(x, y, w, h, c) {
		c.beginPath(); 
		c.moveTo(x, y); 
		c.lineTo(x+w, y+h/2); 
		c.lineTo(x, y+h); 
		c.lineTo(x, y); 
		c.fillStyle = "rgb(0, 0, 0)"; 
		c.fill(); 
	}
	
	function drawShowArrows(x, y, w, h, c) {
		var leftArrow = drawArrow(w/2+5, y, -w/2, h, c); 
		var rightArrow = drawArrow(w/2+10, y, w/2, h, c); 
	}

	function drawEmptyBalls(x, y, r, c) {
		c.beginPath(); 
		c.arc(x, y, r,0,2*Math.PI);
		c.strokeStyle = "rgb(34, 70, 119)";
		c.lineWidth = 2;
		c.stroke();
	}
	function showBalls() {
		for (var i = 0, k = 10; i < ballCount; i++, k+=20) {
			drawShowBalls(k, 10, 7, showBallsC);
		}
		for (var i = 0, k = 10; i < 3; i++, k+=20) {
			drawEmptyBalls(k, 10, 7, showBallsC);
		}
	}

	function drawBricks() {
		for (var i = 0; i < bricks.length; i++) {
			if(!(bricks[i].getDestroyed())){
				bricks[i].draw();
			}
		}
	}

	function drawPickups() {
		for (var i = 0; i < pickups.length; i++) {
			if(!(pickups[i].getFallen())){
				pickups[i].draw();
			}
		}
	}

	function drawSpiders() { 
		for (var i = 0; i < spiders.length; i++) {
			if(!(spiders[i].getFallen())){
				spiders[i].draw();
			}
		}
	}

	function drawShowPickups(x, y, w, h, c) {
		c.translate(x, y);
		c.beginPath(); 
		c.moveTo(0-w/2, 0-h/2+h/3+h/15); 
		c.lineTo(0-w/2+w, 0-h/2+h/3+h/15); 
		c.lineTo(0-w/2+w/5, 0-h/2+h); 
		c.lineTo(0-w/2+w/2, 0-h/2); 
		c.lineTo(0-w/2+w/5*4, 0-h/2+h);
		c.lineTo(0-w/2, 0-h/2+h/3+h/15);
		c.fillStyle = "rgb(126,16,16)";
		c.fill();
	}

	function drawShowPickupsCanvas(c) {
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);
		c.save();
		drawShowPickups(10, 10, 14, 14, c); 
		c.restore();
	}

	function drawShowBallCanvas(c) {
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);
		c.save();
		showBalls();
		c.restore();
	}

	function drawCanvas() {
		c.clearRect(0, 0, c.canvas.width, c.canvas.height);
		c.save();
		if(lost || won){
			c.globalAlpha = 0.4;
		}
		c.fillStyle = "rgb(205,186,150)";
		c.fillRect(0, 0, c.canvas.width, c.canvas.height);
		drawPickups();
		paddle.draw();
		ball.draw();
		drawSpiders(); 
		drawBricks();
		c.restore();

		if (game)
			requestAnimFrame(drawCanvas);
	}

	function updateLogic() {
		if (inputBuffer.left && !inputBuffer.right)
			paddle.moveLeft();
		else if(!inputBuffer.left && inputBuffer.right)
			paddle.moveRight();

		ball.update();
		for(var i = 0; i < pickups.length; i++){
			pickups[i].update();
		}
		for(var j = 0; j < spiders.length; j++){
			spiders[j].update();
		}
		checkCollision();
		gameWon();  
	}

	function everyBrickDestroyed() {
		for (var i = 0; i < bricks.length; i++) {
			if (bricks[i].getDestroyed() == false){
				return false; 
			}
		}
		return true; 
	}

	function Paddle(x1, y1, w1, h1, borderRadius){
		var x = x1 || 0;
		var y = y1 || 0;
		var w = w1 || 0; 
		var h = h1 || 0; 
		this.draw = function() {
			c.beginPath(); 
			c.moveTo(x+borderRadius, y); 
			c.lineTo(x+w-borderRadius, y); 
			c.arcTo(x+w, y, x+w, y+borderRadius, borderRadius); 
			c.lineTo(x+w, y+h-borderRadius); 
			c.arcTo(x+w, y+h, x+w-borderRadius, y+h, borderRadius);
			c.lineTo(x+borderRadius, y+h); 
			c.arcTo(x, y+h, x, y+h-borderRadius, borderRadius); 
			c.lineTo(x, y+borderRadius); 
			c.arcTo(x, y, x+borderRadius, y, borderRadius); 
			var grd = c.createLinearGradient(x, y, x, y+h);
			grd.addColorStop(0, "#a90329");
			grd.addColorStop(1, "#6d0019");
			c.fillStyle = grd; 
			c.fill();
			c.strokeStyle = "#444";
			c.lineWidth = 1;
			c.stroke(); 
		};
		this.getX = function() {
			return x;
		};
		this.getY = function() {
			return y;
		};
		this.moveRight = function(){
			if (x + w < c.canvas.width){
				x += PaddleSpeed;
			}
		};
		this.moveLeft = function(){
			if(x > 0){
				x -= PaddleSpeed;
			}
		};
	}

	function Brick(x, y, w, h, beginColor, endColor, strokeColor) {
		var destroyed = false;
		this.x = x || 0;
		this.y = y || 0;
		this.w = w || 0; 
		this.h = h || 0; 
		this.draw = function() {
			c.beginPath(); 
			c.rect(x, y, w, h);
			var grd = c.createLinearGradient(x, y, x, y+h);
			grd.addColorStop(0, beginColor);
			grd.addColorStop(1, endColor);
			c.fillStyle = grd; 
			c.fill();
			c.strokeStyle = strokeColor;
			c.lineWidth = 1;
			c.stroke(); 
		};
		this.getX = function() {
			return this.x;
		};
		this.getY = function() {
			return this.y;
		};
		this.setDestroyed = function(value) {
			destroyed = value;
		};
		this.getDestroyed = function() {
			return destroyed;
		};
	}

	function Ball(x, y, r, speedX, speedY) {
		this.collided = false;
		this.x = x || 0;
		this.y = y || 0;
		this.speedX = speedX || 0;
		this.speedY = speedY || 0;
		this.update = function() {
			this.x += this.speedX; 
			this.y += this.speedY;
		};
		this.draw = function() {
			c.beginPath(); 
			c.arc(this.x, this.y, r,0,2*Math.PI);
			c.fillStyle = "rgb(57,83,110)";
			c.fill();
			c.strokeStyle = "rgb(34, 70, 119)";
			c.lineWidth = 1;
			c.stroke(); 
		};
		this.getX = function() {
			return this.x;
		};
		this.getY = function() {
			return this.y;
		};
		this.getSpeedX = function() {
			return this.speedX;
		};
		this.getSpeedY = function() {
			return this.speedY;
		};
		this.setSpeed = function(speedX, speedY) {
			this.speedX = speedX;
			this.speedY = speedY;
		};
		this.invertSpeedX = function(){
			this.speedX = -this.speedX;
		};
		this.invertSpeedY = function(){
			this.speedY = -this.speedY;
		};
	}

	function Pickup(x1, y1, w1, h1, speedX1, speedY1, rotation1) {
		var fallen = false; 
		var rotation = rotation1; 
		var x = x1 || 0;
		var y = y1 || 0;
		var h = h1 || 0;
		var w = w1 || 0; 
		var speedX = speedX1 || 0;
		var speedY = speedY1 || 0;
		this.update = function() {
			if(y <= 100 || y >= 200 && y <= 300 || y >=400 || x-w/2 <= 0){
				x += speedX; 
			}
			if(y >= 100 && y <= 200 || y >= 300 && y <= 400 || x+w/2 >= c.canvas.width){
				x -= speedY; 
			}
			y += speedY;
		};
		this.draw = function() {
			c.save();
			c.translate(x, y);
			c.rotate(rotation);
			c.beginPath(); 
			c.moveTo(0-w/2, 0-h/2+h/3+h/15); 
			c.lineTo(0-w/2+w, 0-h/2+h/3+h/15); 
			c.lineTo(0-w/2+w/5, 0-h/2+h); 
			c.lineTo(0-w/2+w/2, 0-h/2); 
			c.lineTo(0-w/2+w/5*4, 0-h/2+h);
			c.lineTo(0-w/2, 0-h/2+h/3+h/15);
			c.fillStyle = "rgb(126,16,16)";
			c.fill();
			rotation+=0.05;
			c.restore();
		};
		this.getX = function() {
			return x;
		};
		this.getY = function() {
			return y;
		};
		this.setSpeed = function(speedX1, speedY1) {
			speedX = speedX1;
			speedY = speedY1;
		};
		this.getFallen = function(){
			return fallen; 
		};
		this.setFallen = function(value) {
			fallen = value;
		};
	}

	function Spider(x1, y1, r1, speedX1, speedY1, c) {
		var fallen = false; 
		var x = x1 || 0;
		var y = y1 || 0;
		var r = r1 || 0;
		var speedX = speedX1 || 0;
		var speedY = speedY1 || 0;
		this.c = c; 
		this.update = function() {
			x += speedX; 
			y += speedY;
		};

		this.draw = function() {
			c.save();
			drawThread();  
			drawSpiderBody(); 
			c.restore();
		};

		function drawSpiderBody() {
			c.save(); 
			drawSpiderHead(); 
			drawSpiderFeet(); 
			c.beginPath(); 
			c.translate(x, y);
			c.scale(0.5, 0.75); 
			c.arc(0, 0, r,0,2*Math.PI);
			c.fillStyle = "rgb(0, 0, 0)"; 
			c.fill(); 
			drawSpiderCross();
			c.restore(); 
		};

		function drawSpiderHead() {
			c.beginPath(); 
			c.arc(x, y+r, r/3,0,2*Math.PI);
			c.fillStyle = "rgb(0, 0, 0)"; 
			c.fill(); 
		};

		function drawSpiderCross() {
			c.beginPath();
			c.strokeStyle = "rgb(126,16,16)";
			c.lineWidth = 3;
			c.moveTo(0-r, 0); 
			c.lineTo(0+r, 0); 
			c.moveTo(0, 0-r); 
			c.lineTo(0, 0+r);
			c.stroke();
		};

		function drawSpiderFeet(){
			c.beginPath();
			c.strokeStyle = "rgb(0, 0, 0)";
			c.lineWidth = 2;
			c.moveTo(x, y); 
			c.lineTo(x-r, y+0.5*r); 
			c.lineTo(x-1.25*r, y+r); 
			c.lineTo(x-0.85*r, y+1.75*r);
			c.moveTo(x, y+r*0.25);
			c.lineTo(x-0.75*r, y+0.75*r); 
			c.lineTo(x-0.5*r, y+1.5*r); 

			c.moveTo(x, y); 
			c.lineTo(x+r, y+0.5*r); 
			c.lineTo(x+1.25*r, y+r); 
			c.lineTo(x+0.85*r, y+1.75*r);
			c.moveTo(x, y+r*0.25);
			c.lineTo(x+0.75*r, y+0.75*r); 
			c.lineTo(x+0.5*r, y+1.5*r); 

			c.moveTo(x, y); 
			c.lineTo(x-r, y-0.5*r); 
			c.lineTo(x-1.25*r, y-r); 
			c.lineTo(x-0.85*r, y-1.75*r);
			c.moveTo(x, y+r*0.25);
			c.lineTo(x-0.75*r, y-0.75*r); 
			c.lineTo(x-0.5*r, y-1.5*r); 

			c.moveTo(x, y); 
			c.lineTo(x+r, y-0.5*r); 
			c.lineTo(x+1.25*r, y-r);
			c.lineTo(x+0.85*r, y-1.75*r); 
			c.moveTo(x, y+r*0.25);
			c.lineTo(x+0.75*r, y-0.75*r); 
			c.lineTo(x+0.5*r, y-1.5*r); 

			c.stroke();
		};

		function drawThread() {
			c.beginPath();
			c.strokeStyle = "rgb(0, 0, 0)";
			c.lineWidth = 2;
			c.moveTo(x, 0); 
			c.lineTo(x, y); 
			c.stroke();
		};
		this.getX = function() {
			return x;
		};
		this.getY = function() {
			return y;
		};
		this.setSpeed = function(speedX1, speedY1) {
			speedX = speedX1;
			speedY = speedY1;
		};
		this.getFallen = function(){
			return fallen; 
		};
		this.setFallen = function(value) {
			fallen = value;
		};
	}

	function intersects(a, b) {
		return a.bottom >= b.top && a.top <= b.bottom && a.right >= b.left && a.left <= b.right;
	}

	function checkCollision() {
		var by = ball.getY();
		var bx = ball.getX();
		var px = paddle.getX();
		var py = paddle.getY();
		var borderRadius = BORDERRADIUS;
		var pcoord = {
			left : px + borderRadius/2,
			top : py,
			right : px + PADDLEWIDTH - borderRadius/2,
			bottom : py + PADDLEHEIGHT
		};
		var pleft = {
			left : px,
			top : py,
			right : px + borderRadius,
			bottom : py + PADDLEHEIGHT
		};
		var pright = {
			left : px + PADDLEWIDTH - borderRadius,
			top : py,
			right : px + PADDLEWIDTH,
			bottom : py + PADDLEHEIGHT
		}; 
		var bcoord = {
			left : bx - BALLR,
			top : by - BALLR,
			right : bx + BALLR,
			bottom : by + BALLR
		};

		if(bcoord.top <= 0) {
			if(!ball.collided) {
				ball.invertSpeedY(); 
			}
		} else if (bcoord.right >= c.canvas.width) {
			if(!ball.collided) {
				ball.invertSpeedX();
				ball.x += c.canvas.width - bcoord.right;
				ball.collided = true; 
			}
		} else if (bcoord.left <= 0) {
			if(!ball.collided) {
				ball.invertSpeedX();
				ball.x += 0 - bcoord.left;
				ball.collided = true; 
			}
		} else if (intersects(bcoord, pcoord)) {
			if(!ball.collided && !catched) {
				ball.invertSpeedY();
				ball.y += pcoord.top - bcoord.bottom;
				ball.collided = true; 
			}
		} else if (intersects(bcoord, pleft)) {
			if(!ball.collided && !catched) {
				var v = sphereCollide(bx, by, ball.getSpeedX(), ball.getSpeedY(), pleft.right, pleft.top + 0.5 * PADDLEHEIGHT);
				ball.setSpeed(v.x, v.y);
				ball.x += pleft.left - bcoord.right;
				ball.y += pleft.top - bcoord.bottom;
				ball.collided = true; 
			}
		} else if (intersects(bcoord, pright)) {
			if(!ball.collided && !catched) {
				var v = sphereCollide(bx, by, ball.getSpeedX(), ball.getSpeedY(), pright.left, pright.top + 0.5 * PADDLEHEIGHT);
				ball.setSpeed(v.x, v.y);
				ball.x += pright.right - bcoord.left;
				ball.y += pright.top - bcoord.bottom;
				ball.collided = true; 
			}
		} else{
			ball.collided = false;
		}
		checkBallBrickCollision(bx, by); 
		checkIfBallInGameField(by); 
		checkBallSpiderCollision(px, py, bx, by); 
		checkPickupPaddleCollision(px, py); 
	}

	function checkBallBrickCollision(bx, by) {
		for (var i = bricks.length; i--; ) {
			var brick = bricks[i];

			if(by - BALLR <= brick.getY() + BRICKHEIGHT && bx >= brick.getX() && bx <= brick.getX() + BRICKWIDTH && by >= brick.getY()) {
				if(!brick.getDestroyed()) {
					for(var k = 0; k < pickups.length; k++) {
						if(pickups[k].getX() === brick.getX() + BRICKWIDTH * 0.5 && pickups[k].getY() === brick.getY() + BRICKHEIGHT * 0.5){
							pickups[k].setSpeed(2, 2); 
						}
					}
					for(var m = 0; m < spiders.length; m++) {
						if(spiders[m].getX() === brick.getX() + BRICKWIDTH * 0.5){
							spiders[m].setSpeed(0, 1); 
						}
					}
					brickSound.play(); 
					brick.setDestroyed(true);
					bricks.slice(i,1);
					ball.invertSpeedY(); 
				}
			}
		}
	}

	function checkIfBallInGameField(by) {
		if(by - 2 * BALLR >= c.canvas.height){
			if(ballCount) {
				if(--ballCount !== 0) {
					ball = new Ball (BallDx, BallDy, BALLR, BallSpeedX, BallSpeedY);
					catched = false; 
				}
				drawShowBallCanvas(showBallsC);
				drawShowPickupsCanvas(showPickupsC); 
			}
		}
	}

	function checkBallSpiderCollision(px, py, bx, by) {
		for (var n = spiders.length; n--; ) {
			var spider = spiders[n]; 
			if (spider.getY() == 150){
				spider.setSpeed(0, 0); 
				if(((by - BALLR <= spider.getY() + SPIDERRADIUS + SPIDERRADIUS/3 && by + BALLR > spider.getY()) || (by + BALLR >= spider.getY() - SPIDERRADIUS && 
					by - BALLR < spider.getY())) && (((bx - BALLR <= spider.getX() + SPIDERRADIUS)  
					&& (bx + BALLR > spider.getX()))|| (bx + BALLR >= spider.getX() - SPIDERRADIUS && bx - BALLR < spider.getX()))) {
					spiderSound.play(); 
					setTimeout(takeBallDown(spider), 20); 
					catched = true; 
				}
			}
			blockBallCollision(px, py, n, spider); 
		}
	}

	function blockBallCollision(px, py, n, spider) {
		if(spider.getY() - SPIDERRADIUS >= py+PADDLEHEIGHT && (spider.getX() === px || spider.getX() === px + PADDLEWIDTH)){
				spider.setFallen(true); 
				spiders.slice(n,1); 
			}
	}

	function checkPickupPaddleCollision(px, py) {
		for (var m = pickups.length; m--; ){
			var pickup = pickups[m];
			if(pickup.getX() >= px && (pickup.getX() <= px + PADDLEWIDTH) && pickup.getY() === py + PADDLEHEIGHT * 0.5){
				pickup.setFallen(true);
				pickups.slice(m,1);
				pickupsCountDisplay++;
				$('#showPickups').html(pickupsCountDisplay +'/' + pickupsCount);
			}
		}
	}

	function takeBallDown(spider1) {
		spider1.setSpeed(0, 1); 
		ball.setSpeed(0, 1); 
	}

	function sphereCollide(bx, by, vbx, vby, px, py) {
		var delta = { x: px - bx, y: py - by };
		var normD = Math.sqrt(delta.x * delta.x + delta.y * delta.y);
		var normV = Math.sqrt(vbx * vbx + vby * vby);
		var v = { x: vbx / normV, y: vby / normV };
		delta.x = delta.x / normD;
		delta.y = delta.y / normD;
		var alpha = delta.x * v.x + delta.y * v.y;
		var g = -2 * alpha * normV;
		delta.x = g * delta.x;
		delta.y = g * delta.y;
		return {
			x: vbx + delta.x,
			y: vby + delta.y
		};
	}

	function gameWon() {
		if(ballCount === 0){
			$('#looseImg').show();
			game = false;
			lost = true; 
			a.pause(); 
			clearInterval(logicLoop);
			ball.setSpeed(0,0);
		}
		if(everyBrickDestroyed()) {
			if(levelGame && currentLevel == highestLevel){
				highestLevel++; 
				createCookie('highestLevel', highestLevel); 
				displayHighestLevel = highestLevel+1; 
				$('#levelMessage').html("Level " + displayHighestLevel + " erreicht!"); 
				$('#levelMessage').show(); 
				$('#levelSelect button:nth-child(' + displayHighestLevel + ')').removeClass("notActivated"); 
				$('#pauseButton').html('Nächstes Level'); 
			}
			else{
				$('#winImg').show();
			}
			game = false;
			won = true; 
			a.pause();
			clearInterval(logicLoop);
			ball.setSpeed(0,0);
		}
	}

	function keyPressed(event) {
		setInput(event.keyCode, true);
	}

	function keyReleased(event) {
		setInput(event.keyCode, false);
	}

	function setInput(keyCode, status) {
		switch (keyCode) {
			case 39: //rechte Pfeiltaste
				inputBuffer.right = status;
				break; 
			case 37: //linke Pfeiltaste
				inputBuffer.left = status;
				break;
		}
	}

	function playAudio(p) {
		p.currentTime = 0; 
		p.play();  
	}
});
