var CanvasRenderer = function(width_, height_) {
    this.click_handlers = [];
    var that = this;
    this.cell_width = 12;
    this.cell_height = 12;
    this.spacing = 1;

    this.init = function(width_, height_) {
        this.element = $("<canvas/>").appendTo(".space");
        this.element.attr("width", 
            ((this.cell_width*1) * (width_*1) + (width_*1) * (this.spacing*1)));
        this.element.attr("height", 
            ((this.cell_height*1) * (height_*1) + (height_*1) * (this.spacing*1)));
            
        this.element.click(function(e) { that.onClick(e); });
    };

    this.render = function(e) {
        canvas = this.element.get()[0].getContext("2d");
        width = e.board_.width;
        
        // Avoid unnecessary costly changes to the fillStyle property
        // by drawing live and dead cells each in one batch. 
        
        canvas.fillStyle = "purple";
        e.board_.state.forEach(function(field, index) {
            if(!e.board_.state[index])
                return;

            var row = Math.floor(index*1 / width*1);
            var column = index*1 % width*1;
            canvas.fillRect(column * this.cell_width + column * this.spacing,
                row * this.cell_height + row * this.spacing,
                this.cell_width,
                this.cell_height);
        }, this);
        
        canvas.fillStyle = "grey";
        e.board_.state.forEach(function(field, index) {
            if(e.board_.state[index])
                return;
                
            row = Math.floor(index*1 / width*1);
            column = index*1 % width*1;
            canvas.fillRect(column * this.cell_width + column * this.spacing,
                row * this.cell_height + row * this.spacing,
                this.cell_width,
                this.cell_height);
        }, this);
        
    };

    this.addClickHandler = function(e) {
        this.click_handlers.push(e);
    };
    
    this.onClick = function(e) {
        xcoord = e.pageX - this.element.position().left;
        ycoord = e.pageY - this.element.position().top;
        
        this.click_handlers.forEach(function(handler) {
                // get cell at coordinates
                row = Math.ceil(ycoord / (this.cell_height + this.spacing));
                column = Math.ceil(xcoord / (this.cell_width + this.spacing));
                cellnumber = handler.board_.width * (row - 1) + (column - 1);
                
                handler.toggle(cellnumber);
                this.render(handler);
            }, this);
    };
    
    this.init(width_, height_);
};
