var CSSRenderer = function(width_, height_) {
    this.element = $();
    this.width = width_;
    this.height = height_;
    this.cell_width = 15;
    this.cell_height = 15;
    this.spacing = 0;
    this.click_handlers = [];
    this.cells = [];
    this.pressed_cell = null;
    this.drawing_mode = false;
    
    var that = this;
    
    this.element = $("<div/>").addClass("board");
    this.element.appendTo($("div.space"));
    
    this.element.css("width", 
        ((this.cell_width*1) * (this.width*1) + (this.width*1) * (this.spacing*1)) + "px");
    
    for(var i = 0; i < (this.width*1)*(this.height*1); ++i) {
        var cell = $("<div/>").addClass("cell").data('n', i);
        cell.mousedown(function() {that.onMouseDownOnCell(this);});
        cell.mouseup(function() {that.onMouseUp(this);});
        //cell.click(function() {that.onClick(this);});
        cell.mouseenter(function() {that.onMouseEnterCell(this);});
        cell.appendTo(this.element);
        this.cells.push(cell);
    }
    
    this.element.mouseenter(function() {that.onMouseEnter();});
    this.element.mouseleave(function() {that.onMouseLeave();});
    $("html").mouseup(function() {that.onMouseUp();});
    $("html").mousedown(function() {that.onMouseDown();});
    
    this.decorator = new DecoratorMenu(this);
};

CSSRenderer.prototype.onClick = function(clicked_element) {
    var element_index = $(clicked_element).data("n");
    console.log("clicked on " + element_index);
    
    this.click_handlers.forEach(function(e) {
        e.toggle(element_index);
        this.render(e);
    }, this);
};

CSSRenderer.prototype.onMouseLeave = function(e) {
    $("div.menu").css("display", "none");       
};

CSSRenderer.prototype.onMouseEnter = function(e) {
    $("div.menu").css("left", this.element.position().left + this.element.width());
    $("div.menu").css("top", this.element.position().top);
    $("div.menu").css("display", "block");        
};

CSSRenderer.prototype.onMouseEnterCell = function(e) {
    if(this.drawing_mode)
        this.onClick(e);
};

CSSRenderer.prototype.onMouseDown = function(e) {
    this.drawing_mode = true;
};

CSSRenderer.prototype.onMouseDownOnCell = function(e) {
    this.pressed_cell = $(e);
    this.onClick(e);
};

CSSRenderer.prototype.onMouseUp = function(e) {
    this.drawing_mode = false;
};

CSSRenderer.prototype.addClickHandler = function(e) {
    this.click_handlers.push(e);
};

CSSRenderer.prototype.render = function(a) {
    for(var i = 0; i < a.board_.state.length; ++i) {
        if(a.board_.state[i] === undefined)
            continue;
        if(a.board_.state[i])
            this.cells[i].addClass("alive");
        else
            this.cells[i].removeClass("alive");
    }
}; 

CSSRenderer.prototype.resize = function(width) {
    var current_width = this.element.width();
    this.element.css("transform", "scale(" + width/current_width + ")");
};

CSSRenderer.prototype.close = function() {
    this.element.remove();
};

