
var checkCreateAutomatonFromURL = function() {
    var u = window.location.href;
    
    if(getUrlParam(u, "width") && getUrlParam(u, "height") && getUrlParam(u, "state") && getUrlParam(u, "rule")) {
        var a = fromURL(u);
        s.addAutomaton(a);
        s.renderAll();
    }
};

var is_main_initialized = false;
var onReady = function() {
    if(is_main_initialized)
        return;
    // prevent dragging elements
    $(document).bind("dragstart", function(event) {
        event.preventDefault();
    });
    
    s = new Space();
    checkCreateAutomatonFromURL();

    $("#start_button").click(function() {s.startTicker();});
    $("#pause_button").click(function() {s.pauseTicker();});
    $("#next_button").click(function() {s.handleTick();});
    $("#add_automaton_button").click(function() {
            var a = new Automaton(30, 30, global_rule, global_custom_rule);
            s.addAutomaton(a);
        });
    is_main_initialized = true;
};

var is_greeter_initialized = false;
var onGreeterInit = function() {
    if(is_greeter_initialized)
        return;
    
    $("div[data-role='collapsible']").bind("expand", onRuleSelected);
    $("#code_viewer_read").show();
    $("#code_viewer_write").val("true;").hide();
    $("#start").click(function() 
        {
            global_custom_rule = $("#code_viewer_write").val();
            s.setAllRules(global_rule, global_custom_rule);
        });
    
    showRuleCode();
    is_greeter_initialized = true;
}

global_rule = "gameoflife";
global_custom_rule = "true;";
use_canvas = false;

var onRuleSelected = function(element) {
    global_rule = $(this).attr("data-value");
    showRuleCode();
}

var showRuleCode = function () {
    var code_viewer = $("#code_viewer_read");
    var code_viewer_write = $("#code_viewer_write");
    
    code_viewer.show();
    code_viewer_write.hide();
    
    switch(global_rule) {
        case "gameoflife":
            code_viewer.text("    if(!!alive) {\n\
        if(count == 2 || count == 3)\n\
            true;\n\
        else\n\
            false;\n\
    } else {\n\
        if(count == 3)\n\
            true;\n\
    }");
            break;
        case "dayandnight":
            code_viewer.text("if(!alive) {\n\
        if(count == 3 || count == 6 || count == 7 || count == 8)\n\
            true;\n\
    } else {\n\
        if(count == 3 || count == 4 || count == 6 || count == 7 || count == 8)\n\
            true;\n\
    }");
            break;
        case "seeds":
            code_viewer.text("if(!alive)\n\
        if(count == 2)\n\
            true;\n\
 false");
            break;
        case "seedsvariation":
            code_viewer.text("if(!alive)\n\
        if(count == 2 && !neighborhood[5] && !neighborhood[0])\n\
            true;\n\
    \n\
    false;");
            break;
        case "highlife":
        code_viewer.text("    if(!alive) {\n\
        if(count == 3 || count == 6)\n\
            true;\n\
        else \n\
            false;\n\
    } else {\n\
        if(count == 2 || count == 3)\n\
            true;\n\
        else\n\
            false;\n\
    }");
            break;
        case "custom":
            code_viewer.hide();
            code_viewer_write.show();
            break;
        default:
            break;
    }
}

var getUrlParam = function(url, name) {
    name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");

    var regex_string = "[\\?&]"+name+"=([^&#]*)";
    var regex = new RegExp(regex_string);
    var results = regex.exec(url);

    if (results == null)
        return "";
    else
    return results[1];
}

$("#main_page").bind('pageinit', onReady);
$("#greeter_page").bind('pageinit', onGreeterInit);
