
$(function () {

    //Initialisierung
    var zutlist = [];
    var result = $('#result').empty();
    var rzahl = 0;//Zahl der erfolgreich abgefragten Rezepte
    var a;//Variable fr Anfragen
    var running = false;

    //AJAX-Anfrage-Funktion
    function anfrage(aname, aurl, afunc) {
        return $.ajax({
            url: 'http://json2jsonp.com/?callback=?',//Ntig, da chefkoch.de keine eigene JSONP-API anbietet :(
            cache: false,
            data: { url: aurl },
            dataType: 'JSON',
            complete: function () {
                console.log(aname + "request beendet!");
            },
            error: function (err) {
                console.log("Fehler beim " + aname + "request!", err);
            },
            success: afunc
        });
    }

    //Successfunktion fr Rezeptabfrage
    function rezeptfunc(response) {//Bei Erfolg erfolgt fr jedes Rezept ein Request fr die Zutaten

        for (var i = 0, n = response.result.length; i < n; i++) {// Schleife ber alle Suchergebnisse

            //Vorbereitung der Zutatabfrage
            var item = response.result[i];
            var p = $.param({ ID: item.RezeptShowID });
            var url = 'http://api.chefkoch.de/api/1.2/api-recipe.php?' + p;

            anfrage("Zutat", url, zutatfunc);
        }
    }

    //Successfunktion fr die Zutatabfrage
    function zutatfunc(response) {
        {
            rzahl++;
            var item = response.result[0].rezept_zutaten; //Zutaten-array holen

            for (var j = 0, m = item.length; j < m; j++) { //Durchgehen der Zutaten fr das Rezept

                var str = item[j].name; //aktuelle Zutat
                var exists = false;

                if (str.charAt(0) === "<") //Abfangen von Pseudo-Zutaten wie <b>Fr den Teig:</b>
                    break;

                for (var k = 0; k < zutlist.length; k++) { //Abgleich mit momentaner Zutatenliste
                    if (zutlist[k][1] === str) {//Bei bereinstimmung wird Auftreten inkrementiert
                        zutlist[k][0]++;
                        exists = true;
                        break;
                    }
                }

                if (!exists)//Bei neuer Zutat Arrayeintrag anlegen
                    zutlist.push([1, str]);

            }

            zutlist.sort(function (a, b) {//Da AJAX asynchron luft, muss stndig geordnet werden
                return a[0] - b[0];
            });


            result.empty();
            for (var i = zutlist.length; i--;) {//Ausgabe wegen Asynchronitt laufend erneuert
                var ratio = (zutlist[i][0] / rzahl);
                var farbe = Math.round(ratio * 270);
                $('<div>').css({
                    width: (ratio * 100) + "%",
                    "background-image": "linear-gradient(to right, transparent 0%, hsl(" + farbe + ",100%,70%) 100%)",
                }).text(zutlist[i][1]).appendTo(result);
            }
        }
    }


    $('#gericht').change(function () {

        rzahl = 0;
        if (running)//Abbrechen des laufenden Requests, falls schon einer luft
            a.abort();
        zutlist.length = 0;
        result.empty();


        //Vorbereitung fr Anfrage
        var p = $.param({
            Suchbegriff: this.value,
            //i: 0,z: 1,m: 0,o: 0, // Mysterise Zusatzparameter ;P
            limit: 20 //Anzahl der Suchergebnisse, Zahlen ber 100 machen die Abfrageroutine sehr trge
        });
        var url = 'http://api.chefkoch.de/api/1.2/api-recipe-search.php?' + p;

        //Anfrage nach den Rezepten
        a = anfrage("Rezept", url, rezeptfunc);
        running = true;
    });
});
