$(document).ready(function (){
	// Varibalen
	var colors=["rgb(0, 0, 255)",
				"rgb(0, 255, 0)",
				"rgb(255, 255, 0)",
				"rgb(255, 0, 0)", 
				"rgb(160, 32, 240)",
				"rgb(135, 206, 255)",
				"rgb(50, 205, 50)",
				"rgb(255, 165, 0)",
				"rgb(255, 0, 255)",
				"rgb(205, 133, 63)"		];
	

	// Alle Divs bis auf welcome verbergen
	$("#game, #players,  #creategame, .playersInfo, .playerswin, .gamebuttons").hide();
		
	// Jquery UI
	$( "#clickToPlay, #weiter1, #weiter2, #neu , #nochmal" ).button();
	$( "#radioset" ).buttonset();
	
	$( "#sliderjquery1" ).slider({ min:5,  max: 10,value:5,  slide: function(event, ui) { $("#sliderjquery1output" ).text(ui.value)} });
	$( "#sliderjquery2" ).slider({ min:10, max: 30,value:10, slide: function(event, ui) { $("#sliderjquery2output" ).text(ui.value)} });
	$( "#sliderjquery3" ).slider({ min:10, max: 30,value:10, slide: function(event, ui) { $("#sliderjquery3output" ).text(ui.value)} });
		

	// Button Klicks
	
	$('#clickToPlay').click(function (){
			$('#window, #welcome').hide(200);
			$('#players, #window').show(200);
	});
	
	
	$('#weiter1').click(function (){
			if( $('#radio1:checked').val()==undefined && $('#radio2:checked').val() == undefined && $('#radio3:checked').val() == undefined ){ 				
				$('#warnung1').text("Plese select!");
				return 0;
			}			
			$('#window, #players').hide(200);		
			$('#creategame, #window').show(200);			
	});	

	
	var a;
	var backup;
	var click1=0;
	var click2=0;
	var numberPlayers=0;
	var playercounter=1;
	var repeatsingle=false;
	
	$('#nochmal').click(function () {
		$('#player1wins, #player2wins, #player1last, #neu, #nochmal, #playersInfodiv').hide();
		click1=0;
		click2=0;
		playercounter=1;
		for ( var y = 0; y < backup.YSize; y++){
		 		for( var x = 0; x < backup.XSize; x++)	
						a.field[y][x]=backup.field[y][x];
		}	
		$('#click1, #click2, #Size1, #Size2').text("0");
		
		$('#player1').css("box-shadow", "inset 0 0 9px 6px honeydew");
		$('#player2').css("box-shadow", "inset 0 0 0px 0px honeydew");
		
		$("#field, #controls").empty();
		$('#field, #controls').show();
	
		$('#game').show(200 , function(){  createGameFunktions(a, playercounter); });
		
	});

	var oldwindow_width;
	var oldwindow_height;

	$('#neu').click(function () {
		$("#game, #players,  #creategame, .playersInfo, .playerswin, .gamebuttons, #player1wins, #player2wins, #player1last, #neu, #nochmal, #playersInfodiv").hide();
		click1=0;
		click2=0;
		playercounter=1;
		$('#click1high').text(" ");
		repeatsingle=false;
		$('#click1, #click2, #Size1, #Size2').text("0");
		$('#window').css("width",oldwindow_width);
		$('#window').css("height",oldwindow_height);	
		$('#window, #welcome').show(200);		
	});
	
	$('#weiter2').click(function () {
		numberPlayers=0;
		playercounter=1;			
		$('#creategame').hide();
		oldwindow_width=$('#window').width();
		oldwindow_height=$('#window').height();
		$('#window').css("width","95%");
		$('#window').css("height","100%");		
		$("#field, #controls").empty();		
		$("#playersInfodiv").hide();
		
		if( $('#radio1:checked').val() =="0" ){
				numberPlayers=1;
				$('#player1').show();
				$('#player2').hide();
		};
		if( $('#radio2:checked').val() =="1" ){
				numberPlayers=2;
				$('#player1').show();
				$('#player2').show();
		};

		a = new gamefield($( "#sliderjquery2" ).slider( "value" ), $( "#sliderjquery3" ).slider( "value" ), $( "#sliderjquery1" ).slider( "value" ) );
		backup = new gamefield($( "#sliderjquery2" ).slider( "value" ), $( "#sliderjquery3" ).slider( "value" ), $( "#sliderjquery1" ).slider( "value" ) );
		for ( var y = 0; y < a.YSize; y++){
			for( var x = 0; x < a.XSize; x++)	backup.field[y][x]=a.field[y][x];
		}		
		$('#game').show(200 , function(){      createGameFunktions(a, playercounter);  } );
		
	});		

$(window).resize(function(){
    var spaceY = $('#field').innerHeight() / a.YSize -3;
	var spaceX = $('#field').innerWidth() / a.XSize  -3;
	if( spaceX > spaceY ){
		spaceX = spaceY;
	}else{
		spaceY=spaceX;
	
	}
	spaceX = spaceX+ "px";
	spaceY = spaceY + "px";		
	$('.game_raw').css("height",spaceY);
	$('.game_cell').css("width",spaceX);
	
	spaceX= $('.game_cell').outerWidth()*a.XSize-2;		
	$('#controls').css("width",spaceX);	
  });

function createGameFunktions(a, playercounter){
			a.print();	
			createControls( $( "#sliderjquery1" ).slider( "value" ) );				
			var spaceY = $('#field').innerHeight() / a.YSize -3;
			var spaceX = $('#field').innerWidth() / a.XSize -3;
			$('#game').show();
			if( spaceX > spaceY ){
				spaceX = spaceY;
			}else{
				spaceY=spaceX;				
			}
					
			spaceX = spaceX+ "px";
			spaceY = spaceY + "px";		
			$('.game_raw').css("height",spaceY);
			$('.game_cell').css("width",spaceX);
			
			var temp;
			if(numberPlayers==2){
				temp = Math.ceil( (a.XSize * a.YSize)/ 2);
				$('#Size1, #Size2').text("1 / "+temp);
			}
			spaceX= $('.game_cell').outerWidth()*a.XSize-2;		
			$('#controls').css("width",spaceX);		
			
			$( ".game_raw " ).show(400, function(){
						$(".game_controll").show(300, function(){ 
									$("#playersInfodiv").show(300, function(){
												if(repeatsingle==true){
													$('#player1last').show(200);
												}
												$(".gamebuttons").show(200);
									}); 
						});
			});		
						
			a.clustercalc(0,0,$('#cube0000').css('background-color'),1 );
			if(numberPlayers==1)
					$('#Size1').text(a.clusterSize1);
			if(numberPlayers==2){					
					var x=a.XSize-1;
					var y=a.YSize-1;
					var temp1;
					var temp2;
					if(x<10) temp1="0"+x;
					else temp1=x;								
					if(y<10) temp2="0"+y;
					else temp2=y;								
					idString="#cube"+temp2+temp1;
					a.clustercalc(a.XSize-1,a.YSize-1,$(idString).css('background-color'),2 );
					$('#Size1').text(a.clusterSize1+" / "+temp);
					$('#Size2').text(a.clusterSize2+" / "+temp);
			}
		
			$( ".game_controll, .game_cell " ).on( "click", function() {	
				
				if(numberPlayers==1){					
							a.clustercalc(0,0,$(this).css('background-color'),1 ); 
							click1++; $('#click1').text(click1);
							$('#Size1').text(a.clusterSize1);
							if(a.clusterSize1 + a.clusterSize2 == a.XSize * a.YSize ){
									repeatsingle=true;
									var vgl = $('#click1high').text();
									if( !isNaN(vgl) )
										vgl*=1;
									else
										vgl=0;
									
									if(vgl!=0 && vgl > click1){
										console.log("test");
										$('#click1high').text(click1);
									}else if(vgl==0){
										$('#click1high').text(click1)
									}
									$('#player1last').show();
							}				
				}else if(numberPlayers==2){
					$('#player1').css("box-shadow", "inset 0 0 9px 6px honeydew")
					$('#player2').css("box-shadow", "inset 0 0 0px 0px honeydew")				
					if( playercounter%2!=0 ){
						a.clustercalc(0,0,$(this).css('background-color'),1 );
						click1++; $('#click1').text(click2);
						$('#player2').css("box-shadow", "inset 0 0 9px 6px honeydew")
						$('#player1').css("box-shadow", "inset 0 0 0px 0px honeydew")
						$('#Size1').text(a.clusterSize1+" / "+temp);						
					}else{
						a.clustercalc(a.XSize-1,a.YSize-1,$(this).css('background-color'),2 );
						click2++; $('#click2').text(click2+" / "+(a.XSize * a.YSize)/ 2);
						$('#player1').css("box-shadow", "inset 0 0 9px 6px honeydew");
						$('#player2').css("box-shadow", "inset 0 0 0px 0px honeydew");
						$('#Size2').text(a.clusterSize2+" / "+temp);
					}
					if(a.clusterSize1 >= temp || a.clusterSize2 >= temp){
							
							$('#playersInfodiv').hide();
							$('#controls').hide();
							$('#neu').show();
							$('#nochmal').show();
							if(a.clusterSize1 > a.clusterSize2){
									$('#player1wins').show();
									$('#player1').css("box-shadow", "inset 0 0 9px 6px honeydew");
									$('#player2').css("box-shadow", "inset 0 0 0px 0px honeydew");
							}else{
									$('#player2wins').show();
									$('#player2').css("box-shadow", "inset 0 0 9px 6px honeydew")
									$('#player1').css("box-shadow", "inset 0 0 0px 0px honeydew")
							}
					}
					playercounter++;					
				}});
};



function gamefield(xSize,ySize,numberColors){
	//	numberPlayers = _numberPlayers*1;		
		this.XSize = xSize*1;
		this.YSize = ySize*1;
		this.clusterSize1=0;
		this.clusterSize2=0;
		this.field = new Array(this.YSize);
		this.cluster1 = new Array(this.YSize);
		this.cluster2 = new Array(this.YSize);
		for ( var y = 0; y < this.YSize; y++){
				this.field[y] = new Array(this.XSize);
				this.cluster1[y] = new Array(this.XSize);
				this.cluster2[y] = new Array(this.XSize);
				for( var x = 0; x < this.XSize; x++){
					this.field[y][x]= colors[ Math.floor(Math.random() * numberColors) ];
					this.cluster1[y][x]= 0;
					this.cluster2[y][x]= 0;
				}
		}		
	};



gamefield.prototype.clustercalc=function(startX,startY,cmp_color,_playerNumber){
		
		playerNumber=_playerNumber*1;
		
		var todo_size = this.XSize * this.YSize * 4;	
		var todo = new Array(todo_size);
		for ( var x = 0; x < todo_size; x++) 	todo[x] = new Array(2);
		
		todo[0][0]=startY;
		todo[0][1]=startX;		
		var readIndex=0;
		var writeIndex=1;
		
		if(playerNumber==1){		
				for(var y=0; y < this.YSize; y++){
					for( var x = 0; x < this.XSize; x++) this.cluster1[y][x]= 0;
				}
				this.cluster1[startY][startX]=1;	
		}else{
				for(var y=0; y < this.YSize; y++){
					for( var x = 0; x < this.XSize; x++) this.cluster2[y][x]= 0;
				}
				this.cluster2[startY][startX]=1;	
		}				
		while(true){			
			var y=todo[readIndex][0];
			var x=todo[readIndex][1];
			readIndex++;					
			// compare upper neighbour
			if(		(y-1) >= 0    &&    this.cluster1[y-1][x] != 1  &&    this.cluster2[y-1][x] != 1  &&  (    this.field[y-1][x] == this.field[y][x]    ||    this.field[y-1][x] == cmp_color    )    ){
					if(playerNumber==1)	this.cluster1[y-1][x]=1;
					else this.cluster2[y-1][x]=1;
					todo[writeIndex][0]=y-1;
					todo[writeIndex][1]=x;
					writeIndex++;
			}
			// compare lower neighbour
			if(		(y+1) < this.YSize    &&    this.cluster1[y+1][x] != 1 &&    this.cluster2[y+1][x] != 1    &&    (    this.field[y+1][x] == this.field[y][x]   ||   this.field[y+1][x] == cmp_color    )    ){
					if(playerNumber==1)	this.cluster1[y+1][x]=1;
					else this.cluster2[y+1][x]=1;
					todo[writeIndex][0]=y+1;
					todo[writeIndex][1]=x;
					writeIndex++;
			}
			// compare left neighbour
			if(		(x-1) >=0     &&    this.cluster1[y][x-1] != 1    &&    this.cluster2[y][x-1] != 1  &&  (    this.field[y][x-1] == this.field[y][x]   ||   this.field[y][x-1] == cmp_color    )    ){
					if(playerNumber==1)	this.cluster1[y][x-1]=1;
					else this.cluster2[y][x-1]=1;
					todo[writeIndex][0]=y;
					todo[writeIndex][1]=x-1;
					writeIndex++;
			}
	 		// compare right neighbour
			if(		(x+1) < this.XSize     &&    this.cluster1[y][x+1] != 1&&    this.cluster2[y][x+1] != 1   &&      (    this.field[y][x+1] == this.field[y][x]  ||    this.field[y][x+1] == cmp_color    )    ){
					if(playerNumber==1)	this.cluster1[y][x+1]=1;
					else this.cluster2[y][x+1]=1;
					
					todo[writeIndex][0]=y;
					todo[writeIndex][1]=x+1;
					writeIndex++;
			}
			if( readIndex >=writeIndex ) break;					
		}

		
		if(playerNumber==1)	this.clusterSize1= update(this.cluster1,this.field,cmp_color,"DarkViolet");
		else				this.clusterSize2= update(this.cluster2,this.field,cmp_color,"orange");
					
	}
	
function update(cluster,field,cmp_color,playerColor){
	var YSize=cluster.length;
	var XSize=cluster[0].length;
	
	var idString="";
	var idStringtemp="";
	var temp1="";
	var temp2="";
	var temp3=0;
	var counter =0;
	
	for(var y=0; y < YSize; y++){
		for( var x = 0; x < XSize; x++){
			if(cluster[y][x]==1){
				counter++;
				if(x<10) temp1="0"+x;
				else temp1=x;								
				if(y<10) temp2="0"+y;
				else temp2=y;								
				idString="#cube"+temp2+temp1;
				$(idString).css("background-color",cmp_color);	
				field[y][x]=cmp_color;

				// compare upper neighbour
				if(	(y-1) >= 0 && cluster[y-1][x] == 1  ) 	$(idString).css("border-top" , "1px solid "+cmp_color);
				else                						$(idString).css("border-top" , "1px solid "+ playerColor);
				// compare lower neighbour			
				if(	y < YSize-1  && cluster[y+1][x] == 1) 	$(idString).css("border-bottom" , "1px solid "+cmp_color);
				else                						$(idString).css("border-bottom" , "1px solid "+ playerColor);
				
				if(		y < YSize-1    &&  cluster[y+1][x] != 1 ){  
						if(x<10) temp1="0"+x;
						else temp1=x;						
						temp3 = y+1;
						if(temp3<10) temp3="0"+temp3;
						else temp3=temp3;
						idStringtemp="#cube"+temp3+temp1;
						$(idStringtemp).css("border-top" , "1px solid "+ playerColor);
				}
				if(		y >0    &&  cluster[y-1][x] != 1 ){  						
						if(x<10) temp1="0"+x;
						else temp1=x;					
						temp3 = y-1;						
						if(temp3<10) temp3="0"+temp3;
						else temp3=temp3;						
						idStringtemp="#cube"+temp3+temp1;						
						$(idStringtemp).css("border-bottom" , "1px solid "+ playerColor);
				}
		
				// compare left neighbour
				if(	x > 0 && cluster[y][x-1] == 1  )    $(idString).css("border-left" , "1px solid "+cmp_color);
				else                					$(idString).css("border-left" , "1px solid "+ playerColor);
				
				// compare right neighbour
				if(	x <  XSize-1  && cluster[y][x+1] == 1 ) $(idString).css("border-right" , "1px solid "+cmp_color);
				else                       					$(idString).css("border-right" , "1px solid "+ playerColor);
				
				if(		x < XSize-1    &&  cluster[y][x+1] != 1 ){						
						temp3=x+1;
						if(temp3<10) temp3="0"+temp3;
						else temp3=temp3;						
						if(y<10) temp2="0"+y;
						else temp2=y;								
						idString="#cube"+temp2+temp3;						
						idStringtemp="#cube"+temp2+temp3;
						$(idStringtemp).css("border-left" , "1px solid "+ playerColor);
				}
				if(		x  > 0    &&  cluster[y][x-1] != 1 ){  						
						temp3=x-1;
						if(temp3<10) temp3="0"+temp3;
						else temp3=temp3;						
						if(y<10) temp2="0"+y;
						else temp2=y;								
						idString="#cube"+temp2+temp3;						
						idStringtemp="#cube"+temp2+temp3;
						$(idStringtemp).css("border-right" , "1px solid "+ playerColor);
				}				
			}					
		}
	}	
	return counter; 	
}

gamefield.prototype.print=function(){		
		var idString="";
		var temp1="";
		var temp2="";
		for(var y=0; y < this.YSize; y++){
			var raw = document.createElement('div');
			raw.setAttribute('class', 'game_raw');
			raw.style.display = 'none';	
			for( var x=0; x < this.XSize; x++){
				var cell = document.createElement('div');
				cell.style.background = this.field[y][x];
				//cell.style.display = 'none';
				cell.setAttribute('class', 'game_cell');				
				if(x==this.XSize-1) cell.style.borderRight = "1px solid black";
				if(x==0) cell.style.borderLeft = "1px solid black";
				if(y==this.YSize-1) cell.style.borderBottom = "1px solid black";
				if(y==0) cell.style.borderTop = "1px solid black";				
				if(x<10) temp1="0"+x;
				else temp1=x;				
				if(y<10) temp2="0"+y;
				else temp2=y;				
				idString="cube"+temp2+temp1;
				cell.setAttribute('id', idString);				
				raw.appendChild(cell);
			}
			$('#field').get(0).appendChild(raw);
		}
};

	

	
	
function createControls(numberColors){
		var space = 100/ numberColors;
		var space = space+"%";		
		for(var i=0; i<numberColors; i++){
				var control = document.createElement('div');
				control.setAttribute('class', 'game_controll');
				control.style.display = "inline-block";
				control.style.display = "none";
				control.style.background = colors[i];
				control.style.width = space;
				control.style.margin = "0px"
				$('#controls').get(0).appendChild(control);				
		}
}





});
