﻿namespace Builder
{
    class MarioBuilder : IBuilder
    {
        MarioCharacter mario;

        public MarioBuilder()
        {
            mario = new MarioCharacter();
        }

        public MarioCharacter Result
        {
            get { return mario; }
        }

        public IBuilder AddWeapon(Weapon weapon)
        {
            mario.Weapon = weapon;
            return this;
        }

        public IBuilder AddArmor(Armor armor)
        {
            mario.Armor = armor;
            return this;
        }

        public IBuilder AddAbility(Ability ability)
        {
            mario.Ability = ability;
            return this;
        }
    }
}
