﻿using System;
using System.Collections.Generic;

namespace Weaponfactory
{
    sealed class Waffenfabrik
    {
        static Waffenfabrik instance;

        Dictionary<String, Func<Weapon>> types;

        private Waffenfabrik()
        {
            types = new Dictionary<String, Func<Weapon>>();
            Register("laser", () => new LaserWeapon());
            Register("particle", () => new ParticleWeapon());
        }

        public static Waffenfabrik Instance
        {
            get { return instance ?? (instance = new Waffenfabrik()); }
        }

        void Register(String typ, Func<Weapon> constructor)
        {
            types.Add(typ.ToLower(), constructor);
        }

        public Weapon Produce(String typ)
        {
            typ = typ.ToLower();

            if (types.ContainsKey(typ))
                return types[typ]();

            return null;
        }
    }
}
