﻿using System;

namespace Zahlenketten
{
    class Range : Enumerator<Int32>
    {
        Int32 minimum;
        Int32 maximum;
        Int32 current;

        public Range(Int32 minimum, Int32 maximum)
        {
            this.minimum = minimum;
            this.maximum = maximum;
            this.current = minimum - 1;
        }

        public Int32 Current
        {
            get { return current; }
        }

        public Boolean Next()
        {
            if (current < maximum)
            {
                ++current;
                return true;
            }

            return false;
        }

        public void Reset()
        {
            this.current = minimum - 1;
        }
    }
}
