﻿using System;
using System.Collections.Generic;

namespace NamespaceFlyweight
{
    class Namespaces
    {
        List<Namespace> namespaces;

        private Namespaces()
        {
            namespaces = new List<Namespace>();
        }

        static readonly Namespaces factory;

        static Namespaces()
        {
            factory = new Namespaces();
        }

        public static Namespaces Factory
        {
            get { return factory; }
        }

        public Namespace Find(String url, String prefix)
        {
            foreach (var entry in namespaces)
                if (entry.Url == url)
                    return entry;

            return AddNamespaceFor(url, prefix);
        }

        public void Add(Namespace entry)
        {
            namespaces.Add(entry);
        }

        private Namespace AddNamespaceFor(String url, String prefix)
        {
            var ns = new Namespace
            {
                Url = url,
                Prefix = prefix,
                Version = "1.0"
            };

            namespaces.Add(ns);
            return ns;
        }
    }
}
