﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace ThreadSync
{
    class Program
    {
        static void Main(String[] args)
        {
            var n = Receive("Anzahl der Iterationen pro Thread eingeben", Convert.ToInt32);
            var p = Receive("Anzahl der Threads eingeben", Convert.ToInt32);
            Kernel(n, p, false);
            Kernel(n, p, true);
        }

        static void Kernel(Int32 nIterations, Int32 nThreads, Boolean synced)
        {
            var result = nIterations * nThreads;
            var threads = new List<Thread>();
            var workgroup = new Workgroup();
            workgroup.IterationsPerThread = nIterations;
            workgroup.IsSynchronized = synced;

            var clock = Stopwatch.StartNew();

            for (int i = 0; i < nThreads; i++)
            {
                var thread = new thread(&Workgroup::DoWork, &workgroup);
                thread.Start();
                threads.Add(thread);
            }

            WaitThreads(threads);
            clock.Stop();

            Console.WriteLine("Ergebnis für {0} Iterationen bei {1} Threads:", result, nThreads);
            Console.WriteLine("  Sync : {0}", synced ? "Ja" : "Nein");
            Console.WriteLine("  Zeit : {0} ms", clock.ElapsedMilliseconds);
            Console.WriteLine("  Wert : {0}", workgroup.Sigma);
            Console.WriteLine("  Richtig : {0}", result == workgroup.Sigma ? "Ja" : "Nein");
            Console.WriteLine();
        }

        static void WaitThreads(List<Thread> threads)
        {
            while (threads.Count > 0)
            {
                for (int i = threads.Count - 1; i >= 0; i--)
                {
                    if (!threads[i].IsAlive)
                        threads.RemoveAt(i);
                }
            }
        }

        static TInput Receive<TInput>(String message, Func<String, TInput> validator)
        {
            Console.Write("{0}: ", message);

            try
            {
                var input = Console.ReadLine();
                return validator(input);
            }
            catch (Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine(ex.Message);
                Console.ResetColor();
            }

            return Receive(message, validator);
        }
    }
}
