﻿using System;
using System.Collections.Generic;

namespace ThreadSync
{
    class Workgroup
    {
        Int32 sigma;
        Int32 iterationsPerThreads;
        Boolean synchronized;
        Object sync;
        Dictionary<Boolean, Action> workers;

        public Workgroup()
        {
            sigma = 0;
            sync = new Object();
            workers = new Dictionary<Boolean, Action>();
            workers[true] = () => { lock (sync) sigma++; };
            workers[false] = () => { sigma++; };
        }

        public Int32 Sigma
        {
            get { return sigma; }
        }

        public Int32 IterationsPerThread
        {
            get { return iterationsPerThreads; }
            set { iterationsPerThreads = value; }
        }

        public Boolean IsSynchronized
        {
            get { return synchronized; }
            set { synchronized = value; }
        }

        public void DoWork()
        {
            var worker = workers[synchronized];

            for (var i = 0; i < iterationsPerThreads; i++)
                worker();
        }
    }
}
