﻿using System;

namespace MyThreadPool
{
    class Program
    {
        static void Main(String[] args)
        {
            var pool = new MyThreadPool(4);
            pool.Initialize();
            Console.CancelKeyPress += (sender, e) => { if (!pool.Running) return; pool.Shutdown(); e.Cancel = true; };

            while (pool.Running)
            {
                var worker = CreateCountdown();

                if (worker != null)
                    pool.Queue(new WorkerThread(worker));
            }
        }

        static CountdownWorker CreateCountdown()
        {
            Console.Write("Zeit in Sekunden eingeben: ");

            try
            {
                var input = Console.ReadLine();
                var num = Convert.ToInt32(input);
                return new CountdownWorker(num);
            }
            catch (Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine(ex.Message);
                Console.ResetColor();
            }

            return null;
        }
    }
}
