﻿using System;
using System.Threading;

namespace MyThreadPool
{
    sealed class CountdownWorker : IWorkUnit
    {
        readonly Int32 target;
        Int32 elapsed;

        public CountdownWorker(Int32 time)
        {
            target = time;
            elapsed = 0;
        }

        public void Process()
        {
            while (elapsed != target)
            {
                Thread.Sleep(1000);
                elapsed++;
            }
        }

        public override String ToString()
        {
            return String.Format("Countdown to {0}s", target.ToString());
        }
    }
}
