﻿using System;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace CsharpSolutions
{
    class ConsoleWriter : TextWriter
    {
        RichTextBox tb;

        public ConsoleWriter(RichTextBox tb)
        {
            this.tb = tb;
        }

        public override Encoding Encoding
        {
            get { return Encoding.UTF8; }
        }

        public override void Write(String value)
        {
            Append(value);
        }

        public override void WriteLine(Double value)
        {
            Write(value);
            Append(Environment.NewLine);
        }

        public override void WriteLine(String value)
        {
            Write(value);
            Append(Environment.NewLine);
        }

        void Append(String text)
        {
            tb.SelectionColor = ColorFrom(Console.ForegroundColor);
            tb.AppendText(text);
        }

        private Color ColorFrom(ConsoleColor consoleColor)
        {
            switch (consoleColor)
            {
                case ConsoleColor.DarkMagenta:
                    return Color.DarkMagenta;
                case ConsoleColor.DarkGreen:
                    return Color.DarkGreen;
                case ConsoleColor.Red:
                    return Color.Red;
                case ConsoleColor.DarkYellow:
                    return Color.Gold;
                case ConsoleColor.DarkGray:
                    return Color.DarkGray;
                case ConsoleColor.Black:
                    return Color.Black;
                case ConsoleColor.White:
                    return Color.White;
                case ConsoleColor.Blue:
                    return Color.Blue;
                case ConsoleColor.Green:
                    return Color.Green;
                default:
                    return tb.ForeColor;
            }
        }
    }
}
