#include <stdlib.h>
#include <stdio.h>
#include "array.h"

void array_init(t_array* array, size_t size, int length) {
	array->length = length;
	array->size = size;
	array->elements = malloc(size * length);
}

double array_getDouble(t_array* array, int index) {
	return ((double*)array->elements)[index];
}

int array_getInt(t_array* array, int index) {
	return ((int*)array->elements)[index];
}

char array_getChar(t_array* array, int index) {
	return ((char*)array->elements)[ index];
}

void array_setDouble(t_array* array, int index, double value) {
	((double*)array->elements)[index] = value;
}

void array_setInt(t_array* array, int index, int value) {
	((int*)array->elements)[index] = value;
}

void array_setChar(t_array* array, int index, char value) {
	((char*)array->elements)[index] = value;
}

void array_destroy(t_array* array) {
	free(array->elements);
	free(array);
}