#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "analysis.h"
#include "random.h"

double getAverage(double* values, int n) {	
	double sum = 0.0;

	for (int i = 0; i < n; i++) {
		sum += values[i];
	}

	return sum / (double)n;
}

double getError(double average, double* values, int n) {
	double error = 0.0;
	double* errors = malloc(n * sizeof(double));

	for (int i = 0; i < n; i++) {
		error = values[i] - average;
		errors[i] = error * error;
	}

	error = getAverage(errors, n);
	free(errors);
	return sqrt(error / (double)n);
}

double getSquaredAverage(double* values, int n) {
	double sum = 0.0;

	for (int i = 0; i < n; i++) {
		sum += values[i] * values[i];
	}
	
	return sum / (double)n;
}

void doAnalysis(double* values, int n, double* outAverage, double* outError) {
	double avg = getAverage(values, n);
	double err = getError(avg, values, n);
	*outAverage = avg;
	*outError = err;
}

double* getAutocorrelation(double* values, int n) {
	double* result = malloc(n * sizeof(double));
	double norm = 1.0 / (double)n;

	for (int i = 0; i < n; i++) {
		double sum = 0.0;

		for (int j = i; j < n; j++) {
			sum += values[j] * values[j - i];
		}

		result[i] = sum * norm;
	}

	return result;
}

double getAutocorrelationTime(double* values, int n) {
	int m = n > 500 ? 500 : n;
	double norm = 1.0 / (double)m;
	double tau = 0.0;

	for (int i = 0; i < m; i++) {
		double sum = 0.0;

		for (int j = i; j < m; j++) {
			sum += values[j] * values[j - i];
		}

		if (sum < 0.0)
			break;

		tau += sum * norm;
	}

	return tau;
}

double getJackknifeError(double average, double* values, int n) {
	double error = 0.0;
	double N = 1.0 / (double)n;
	double norm = 1.0 / ((double)n - 1.0);

	for (int i = 0; i < n; i++) {
		double sum = 0.0;
		double diff = 0.0;

		for (int j = 0; j < n; j++) {
			if (j != i) {
				sum += values[j];
			}
		}

		diff = sum * norm - average;
		error += diff * diff;
	}

	return sqrt(error * (1.0 - N));
}

double getJackknifeErrorWithBlocking(double average, double* values, int n, int nBlock) {
	double error = 0.0;
	double m = n / nBlock;
	double M = 1.0 / (double)m;
	double N = 1.0 / (double)nBlock;
	double norm = 1.0 / ((double)nBlock - 1.0);
	double* rho = malloc(nBlock * sizeof(double));

	for (int i = 0; i < nBlock; i++) {
		int start = i * m;
		int end = start + m;
		double sum = 0.0;

		for (int j = start; j < end; j++) {
			sum += (double)values[j];
		}

		rho[i] = sum * M;
	}

	for (int i = 0; i < nBlock; i++) {
		double sum = 0.0;
		double diff = 0.0;

		for (int j = 0; j < nBlock; j++) {
			if (j != i) {
				sum += rho[j];
			}
		}

		diff = sum * norm - average;
		error += diff * diff;
	}

	free(rho);
	return sqrt(error * (1.0 - N));
}

double getBootstrapError(double average, double* values, int nValues, int nSamples, int nData) {
	double theta = 0.0;
	double error = 0.0;
	double* data = malloc(nSamples * sizeof(double));

	for (int i = 0; i < nSamples; ++i) {
		double sum = 0.0;

		for (int j = 0; j < nData; ++j) {
			sum += values[discrete(0, nValues)];
		}

		data[i] = sum / (double)nData;
		theta += data[i];
	}

	theta = theta / (double)nSamples;

	for (int i = 0; i < nSamples; ++i) {
		double diff = data[i] - theta;
		error += diff * diff;
	}

	error = error / (double)nSamples;
	free(data);

	return sqrt(error * nData / nValues);
}