#include <time.h>
#include <math.h>
#include "random.h"

#define TRUE 1
#define FALSE 0
#define EPS 1e-7

uint m_z;
uint m_w;
int seeded;
int buffered;
double buffer;

uint getUint() {
	if(seeded == FALSE) {
		setRandomSeed();
	}

    m_z = 36969 * (m_z & 65535) + (m_z >> 16);
    m_w = 18000 * (m_w & 65535) + (m_w >> 16);
    return (m_z << 16) + m_w;
}

double randomize() {
    // 0 <= u < 2^32
    uint u = getUint();
    // The magic number below is 1/(2^32 + 2).
    // The result is strictly between 0 and 1.
    return (u + 1.0) * 2.328306435454494e-10;
}

double uniform(double min, double max) {
	return randomize() * (max - min) + min;
}

int discrete(int include_min, int exclude_max) {
	return (int)floor(randomize() * ((double)(exclude_max - include_min) - EPS)) + include_min;
}

double gaussian(double sigma, double mu) {
	if (buffered == TRUE) {
		buffered = FALSE;
		return mu + sigma * buffer;
	} else {
		double s, u, v;

		do
		{
			u = uniform(-1.0, 1.0);
			v = uniform(-1.0, 1.0);
			s = u * u + v * v;
		} while (s == 0.0 || s >= 1.0);

		double a = sqrt(-2.0 * log(s) / s);
		double z = u * a;
		buffer = v * a;
		buffered = TRUE;
		return mu + sigma * z;
	}
}

double exponential(double min, double decay) {
	return min - log(randomize()) / decay;
}

void setSpecificSeed(uint seed) {
	seeded = 1;
	m_z = seed % 4294967296;
	m_w = seed >> 16;
}

void setRandomSeed() {
	setSpecificSeed((uint)time(NULL));
}