$(function()
{	
	var localStorageDefined=localStorage!=undefined;  // For these Browsers, who don't allow localStorage (e.g. Internet explorer, who allows it only offline)
	if(localStorageDefined)
	{
		document.getElementById("force").innerHTML="MZY tHe ForcE be witH You, "+ localStorage.getItem("Name") + "!";
		if(localStorage.getItem("speaker")==1)
		{
			document.getElementById("gamesound").play();
		}
	}
	else
	{
		document.getElementById("force").innerHTML="MZY tHe ForcE be witH You !";
	}
	var c;
	c = document.getElementById('canvas').getContext('2d');
	c.strokeStyle="#F00";
	c.fillStyle="yellow";
	c.font="20px '8bit'";
	//To play the supported audio format in every browser
	var audioFormat=".mp3";
	a= new Audio;
	if(!a.canPlayType('audio/mp3')) audioFormat=".ogg";
	if(localStorageDefined)
	{
		if(localStorage.getItem("speaker")!=1)
		{
			audioFormat=".empty";
		}
	}
	//Variables
	var timerInterval=1000/30;
	var enemyShotInterval=100;
	var enemyshotSpeed=-3*timerInterval/6;
	var enemyShotx=[];
	var enemyShoty=[];
	var shotx=[];
	var shoty=[];
	var maxShield=8;
	var shield=maxShield;
	var shieldAnimate=50;
	var shieldBarWidth=100;
	var energyAnimate=0;
	var energyIncrement=0.05*timerInterval/6;
	var energyBarWidth=100;
	var maxEnergy=100;
	var energy=maxEnergy;
	var barDistance=10;
	var y=canvas.height/2;
	var stored=false;
	var offsetX=50;
	var xwingShotOffsetX=44;
	var xwingShotOffsetUp=4.5;
	var xwingShotOffsetDown=29.5;
	var deathstarX=canvas.width+500;
	var deathstary=canvas.height+100;
	var deathstarWidth=100;
	var deathstarHeight=100;
	var deathstarSpeed=1;
	var deathstarShotInterval=5000;
	var deathstarShotTimer;
	var deathstarShotx=0;
	var deathstarShoty=-10;
	var deathstarshotWidth=0;
	var deathstarshotHeight=3;
	var deathstarshotSpeed=12*timerInterval/6;
	var deathstarShooting=false;
	var deathstarMaxShield=30;
	var deathstarShield=deathstarMaxShield;
	var deathstarPointIncrement=500;
	var deathStarPoints=300;
	var deathstarBarWidth=100;
	var deathstarBarHeight=5;
	var deathstarImage=document.getElementById("deathstar");
	var nextDeathStarPoints=deathstarPointIncrement;
	var score=0;
	var maxInvisibleEnergy=50;
	var invisibleEnergy=maxInvisibleEnergy;
	var invisibleEnergyAnimate=0;
	var invisibleBarWidth=100;
	var invisibleEnergyLow=0;
	var asteroidX=[];
	var asteroidY=[];
	var asteroidWidth=30;
	var asteroidHeight=30;
	var asteroidSpeed=1*timerInterval/6;
	var asteroidAnimationCounter=[];
	var asteroidImgCount=35;
	var asteroidInterval=1250;
	var asteroidMinInterval=500;
	var asteroidImages=[];
	for(var i=0;i<=asteroidImgCount;i++)
	{
		asteroidImages[i]=document.getElementById("asteroid"+i);
	}
	var ufoX=[];
	var ufoY=[];
	var ufoAnimationCounter=[];
	var ufoWidth=40;
	var ufoHeight=40;
	var ufoInterval=500;
	var ufoMinInterval=250;
	var ufoSpeed = 1.5*timerInterval/6;
	var ufoStartSpeed=1.5*timerInterval/6;
	var ufoSpeedy=[];
	var ufoImgCount=5;
	var ufoImages=[document.getElementById("ufo0"),document.getElementById("ufo1"),document.getElementById("ufo2")];
	var lastUfoSpeed=[];
	var shipWidth=133;
	var shipHeight=35;
	var shipAnimationCounter=0;
	var shipImgCount=1;
	var shipImages=[document.getElementById("raumschiff0"),document.getElementById("raumschiff1")];
	var transparentShipImage=document.getElementById("raumschifft");
	var moveSpeed=1.5*timerInterval/6;
	var backgroundSpeed=0.5*timerInterval/6;
	var backgroundX=0;
	var backgroundImage=document.getElementById("back");
	var shotSpeed=5*timerInterval/6;
	var shotWidth=15;
	var shotHeight=1;
	var hitAnimate=0;
	var expX=[];
	var expY=[];
	var expWidth=[];
	var expHeight=[];
	var expAnimationCounter=[];
	var expImgCount=11;
	var exp_volume=0.5;
	var explosionImages=[];
	for(var i=0;i<=expImgCount;i++)
	{
		explosionImages[i]=document.getElementById("exp"+i);
	}
	var shot_volume=0.2;
	var bboxX=offsetX+41;
	var bboxWidth=74;
	var bboxHeight=24;
	var r2d2Interval=15000;
	var r2d2X = [];
	var r2d2Y = [];
	var r2d2Width=20;
	var r2d2Height=30;
	var r2d2Speed=1*timerInterval/6;
	var r2d2Image=document.getElementById("r2d2");
	var heat=0;
	var grd;
	c.drawImage(backgroundImage,0,0,canvas.width,canvas.height);
	c.drawImage(shipImages[0],offsetX,y,shipWidth,shipHeight);
	var isMoving=0;
	//Keyboard event handler
	document.onkeydown= function(event)
	{
		if(event.keyCode==40)
		{
			isMoving=1;
		}

		if(event.keyCode==38)
		{
			isMoving=-1;
		}
		if(event.keyCode==39)
		{
			if(invisibleEnergyLow!=1&&invisibleEnergy>0)
			{
				bboxX=-100000;
			}
			else
			{
				invisibleEnergyAnimate=5;
			}
		}
	}
	document.onkeyup= function(event)
	{
		if(event.keyCode==32)
		{
			if(energy>0&&heat!=1&&bboxX>0)
			{
				shotx.push(shipWidth+1+offsetX-xwingShotOffsetX);
				shoty.push(y+xwingShotOffsetUp);
				shotx.push(shipWidth+1+offsetX-xwingShotOffsetX);
				shoty.push(y+xwingShotOffsetDown);
				expX.push(shipWidth+1+offsetX-xwingShotOffsetX);
				expY.push(y+xwingShotOffsetUp-3);
				expWidth.push(5);
				expHeight.push(5);
				expAnimationCounter.push(6);
				expX.push(shipWidth+1+offsetX-xwingShotOffsetX);
				expY.push(y+xwingShotOffsetDown-3);
				expWidth.push(5);
				expHeight.push(5);
				expAnimationCounter.push(6);
				var laser=new Audio("./sounds/xwing_blaster"+audioFormat);
				laser.volume=shot_volume;
				laser.play();
				energy-=10;
				if(energy<=0)
				{
					heat=1;
					energy=0
				}
			}
			else
			{
				energyAnimate=5;
			}
		}
		if(event.keyCode==39)
		{
			bboxX=offsetX+41;
		}

		
		if(event.keyCode==40)
		{
			isMoving=0;
		}

		if(event.keyCode==38)
		{
			isMoving=0;
		}

	}
	//Timers for the game
	var gameTimer=setInterval(function(){timerFunc()},timerInterval);

	var asteroidTimer=setInterval(function(){asteroidFunc()},asteroidInterval);

	var ufoTimer=setInterval(function(){ufoFunc()},ufoInterval);

	var enemyShotTimer=setInterval(function(){enemyShot()},enemyShotInterval);

	var r2d2Timer=setInterval(function(){r2d2Func()},r2d2Interval);

	function enemyShot()
	{
		var i=0;
		while(ufoX[i]!=undefined)
		{
			if(Math.random()>0.97)
			{
				enemyShotx.push(ufoX[i]+15);
				enemyShoty.push(ufoY[i]+22);
				var sound=new Audio("./sounds/enemy_blaster"+audioFormat);
				sound.volume=shot_volume;
				sound.play();
			}
			else
			{
				if(ufoY[i]+22<y+shipHeight/2+15&&ufoY[i]+22>y+shipHeight/2-15&&Math.random()>0.8)
				{
					enemyShotx.push(ufoX[i]+15);
					enemyShoty.push(ufoY[i]+22);
					var sound=new Audio("./sounds/enemy_blaster"+audioFormat);
					sound.volume=shot_volume;
					sound.play();
				}
			}
			i++
		}
	}

	//manages the end of the game
	function endGame()
	{
		shipHeight=0;
		shipWidth=0;
		$('#endDiv').show();
		setTimeout(function()
			{
				clearInterval(gameTimer);
				clearInterval(asteroidTimer);
				clearInterval(ufoTimer);
				clearInterval(enemyShotTimer);
				if(deathstarShotTimer)
					clearInterval(deathstarShotTimer);
				c.textAlign='center';
				c.font="40px '8bit'";
				c.fillStyle="yellow";
				c.fillText("GZME ovER",canvas.width/2,canvas.height/2);
			},120);
		storeHighScore();
	}

	function explode(x,y,width,height)
	{
		expX.push(x);
		expY.push(y);
		expWidth.push(width);
		expHeight.push(height);
		expAnimationCounter.push(0);
		var explosion=new Audio("./sounds/explosion"+audioFormat);
		explosion.volume=exp_volume;
		explosion.play();
	}

	//collision methods
		function shipCollision(xs, ys, width,height, asteroid)
	{
		var j=0;
		while(xs[j]!=undefined)
		{
			if(xs[j]<bboxWidth+bboxX&&xs[j]>bboxX-width&&y+5+bboxHeight>ys[j]&&y+5-height<ys[j])
			{
				if(asteroid||shield<=0)
				{
					explode(offsetX,y,shipWidth,shipHeight)
					endGame();
				}
				else
				{
					hitAnimate=20;
					ys.splice(j,1);
					xs.splice(j,1);
					var plop=new Audio("./sounds/plop"+audioFormat);
					plop.play();
					shield--;
					if(shield<0)
						shield=0;
				}
			}
			j++;
		}
	}

	function asteroidShotCollision(xs, ys)
	{
		var l=0;
		while(asteroidX[l]!=undefined)
		{
			var k=0;
			while(xs[k]!=undefined)
			{
				if(xs[k]+shotWidth>=asteroidX[l]&&asteroidY[l]-ys[k]<0&&asteroidY[l]-ys[k]>-asteroidHeight)
				{
					ys.splice(k,1);
					xs.splice(k,1);
					var plop=new Audio("./sounds/plop"+audioFormat);
					plop.play();
				}
				k++;
			}
			l++;
		}

	}

	function deathstarShotHit(xs,ys)
	{
			var k=0;
			while(xs[k]!=undefined)
			{
				if(xs[k]+shotWidth>=deathstarX&&deathstary-ys[k]<0&&deathstary-ys[k]>-deathstarHeight)
				{

					deathstarShield--;
					ys.splice(k,1);
					xs.splice(k,1);
					var plop=new Audio("./sounds/plop"+audioFormat);
					plop.play();
					if(deathstarShield<=0)
					{
						explode(deathstarX,deathstary,deathstarWidth,deathstarHeight);
						nextDeathStarPoints=score+deathstarPointIncrement+deathStarPoints;
						deathstarX=canvas.width+100;
						clearInterval(deathstarShotTimer);
						score+=deathStarPoints;
					}
				}
				k++;
			}
	}

	function ufoShipCollision()
	{
		var j=0;
		while(ufoX[j]!=undefined)
		{
			if(ufoX[j]<bboxWidth+bboxX&&ufoX[j]>bboxX-ufoWidth&&y+5+bboxHeight>ufoY[j]&&y+5-ufoHeight<ufoY[j])
			{
				explode(offsetX,y,shipWidth,shipHeight);
				explode(ufoX[j],ufoY[j],ufoWidth,ufoHeight);
				ufoAnimationCounter.splice(j,1);
				ufoX.splice(j,1);
				ufoY.splice(j,1);
				ufoSpeedy.splice(j,1);
				lastUfoSpeed.splice(j,1);
				j--;
				endGame();
			}
			j++;
		}
	}

	function ufoShotCollision()
	{
		var k=0;
			while(shotx[k]!=undefined)
			{
				var l=0;
				while(ufoX[l]!=undefined)
				{
			
					if(shotx[k]+shotWidth>=ufoX[l]&&ufoY[l]-shoty[k]<0&&ufoY[l]-shoty[k]>-ufoHeight)
					{
						explode(ufoX[l],ufoY[l],ufoWidth,ufoHeight);
						ufoAnimationCounter.splice(l,1);
						ufoX.splice(l,1);
						ufoY.splice(l,1);
						ufoSpeedy.splice(l,1);
						lastUfoSpeed.splice(l,1);
						l--;
						shoty.splice(k,1);
						shotx.splice(k,1);
						k--;
						score+=10*ufoSpeed/ufoStartSpeed;
					}
					l++;
				}
			k++;
			}
	}
	function asteroidUfoCollision()
	{
		var k=0;
			while(asteroidX[k]!=undefined)
			{
				var l=0;
				while(ufoX[l]!=undefined)
				{
			
					if(asteroidX[k]+asteroidWidth>=ufoX[l]&& ufoX[l]+ufoWidth>=asteroidX[k]&&ufoY[l]-asteroidY[k]<asteroidHeight&&ufoY[l]-asteroidY[k]>-ufoHeight)
					{
						explode(ufoX[l],ufoY[l],ufoWidth,ufoHeight);
						ufoAnimationCounter.splice(l,1);
						ufoX.splice(l,1);
						ufoY.splice(l,1);
						ufoSpeedy.splice(l,1);
						lastUfoSpeed.splice(l,1);
						l--;
					}
					l++;
				}
			k++;
			}

	}
	function deathstarShotCollision(xs,ys,widths,heights,counter)
	{
			var k=0;
			while(xs[k]!=undefined)
			{
				if(deathstarShotx+deathstarshotWidth<=xs[k]+widths&&deathstarShoty+deathstarshotHeight>=ys[k]&&deathstarShoty<=ys[k]+heights)
				{
					explode(xs[k],ys[k],widths+30,heights+30);
					counter.splice(k,1);
					ys.splice(k,1);
					xs.splice(k,1);
					k--;
				}
				k++;
			}
	}

	function deathstarShotShipCollision()
	{
				if(deathstarShotx+deathstarshotWidth<=bboxX+bboxWidth&&deathstarShoty+deathstarshotHeight>=y&&deathstarShoty<=y+bboxHeight)
				{
					explode(offsetX,y,shipWidth+30,shipHeight+30);
					endGame();
				}
	}
	function collisionDetection()
	{
		if(deathstarShooting)
		{
			deathstarShotCollision(ufoX,ufoY,ufoWidth,ufoHeight,ufoAnimationCounter);
			deathstarShotCollision(asteroidX,asteroidY,asteroidWidth,asteroidWidth,asteroidAnimationCounter);
			deathstarShotShipCollision();
		}
		shipCollision(asteroidX,asteroidY,asteroidWidth,asteroidHeight,true);
		shipCollision(enemyShotx,enemyShoty,shotWidth,shotHeight,false);
		asteroidShotCollision(shotx,shoty);
		asteroidShotCollision(enemyShotx,enemyShoty);
		ufoShotCollision();
		ufoShipCollision();
		asteroidUfoCollision();		
		deathstarShotHit(shotx,shoty);
	}

	function energyRefill()
	{
		var j=0;
		while(r2d2X[j]!=undefined)
		{
			if(r2d2X[j]<bboxWidth+bboxX&&r2d2X[j]>bboxX-r2d2Width&&y+5+bboxHeight>r2d2Y[j]&&y+5-r2d2Height<r2d2Y[j])
			{
				r2d2X.splice(j,1);
				r2d2Y.splice(j,1);
				j--;
				shield=maxShield;
				var r2d2sound=new Audio("./sounds/r2d2_sound"+audioFormat);
				r2d2sound.play();
			}
			j++;
		}
	}

		function updateEnergy()
	{
		if(energy<maxEnergy)
		{
			energy+=energyIncrement;
		}
		else
		{
			heat=0;
		}
		if(bboxX<0)
		{
			invisibleEnergy--;
		}
		if(invisibleEnergy<=0)
		{
			bboxX=offsetX+41;
		}
		if(invisibleEnergy<maxInvisibleEnergy)
		{
			invisibleEnergy+=0.1;
		}
		else
		{
			invisibleEnergyLow=0;
		}
	}

	function drawShots(xs, ys, speed,color)
	{
		var i=0;
		c.strokeStyle=color;
		while(xs[i]!=undefined)
		{
			if(xs[i]>canvas.width)
			{
				xs.splice(i,1);
				ys.splice(i,1);
				continue;
			}
			if(xs[i]<0)
			{
				xs.splice(i,1);
				ys.splice(i,1);
				continue;
			}
			xs[i]+=speed;
			c.strokeRect(xs[i],ys[i],shotWidth,shotHeight);
			i++;
		}
	}
	function deathstarShot()
	{
		deathstarShotx=deathstarX+16;
		deathstarShoty=deathstary+33;
		deathstarSpeed=0;
		deathstarshotWidth=0;
		deathstarShooting=true;
		shot=new Audio("./sounds/deathstarshot"+audioFormat);
		shot.play();
	}
	function deathstarcheck()
	{
		if(score>nextDeathStarPoints)
		{
			if(deathstarX>canvas.width)
			{
				deathstarX=canvas.width-1;
				deathstary=canvas.height/2-deathstarHeight/2;
				deathstarShotTimer=setInterval(function(){deathstarShot()},deathstarShotInterval);
				deathstarShield=deathstarMaxShield;
			}
		}
	}

	function drawBackground()
	{
		backgroundX-=backgroundSpeed;
		if(backgroundX<=-canvas.width)
		{
			backgroundX=0;
		}
		c.drawImage(backgroundImage,backgroundX,0,canvas.width,canvas.height);
		c.drawImage(backgroundImage,backgroundX+canvas.width-1,0,canvas.width,canvas.height);
	}

	function animateEnergyBar()
	{
		grd=c.createLinearGradient(canvas.width/2+barDistance+50,0,canvas.width/2+ barDistance+energyBarWidth,0);
		grd.addColorStop(0,"#FF9");
		grd.addColorStop(1,"yellow");
		c.fillStyle=grd;
		c.strokeStyle=grd;
		if(energyAnimate%2==0)
		{
			c.strokeRect(canvas.width/2+barDistance+50,5,energyBarWidth,10);
		}
		if(energyAnimate>0)
		{
			energyAnimate--;
		}
		c.fillRect(canvas.width/2+barDistance+50,5,energy*energyBarWidth/maxEnergy,10);
		c.strokeStyle="#F00";
		if(heat==1)
		{
			c.font="8px 'Lucida Console'";
			c.fillText("laser overheated!",canvas.width/2+72,23);
		}
		c.font="20px '8bit'";
		c.fillStyle="#F00";
	}

	function animateInvisibleBar()
	{
		grd=c.createLinearGradient(canvas.width/2-barDistance-50,0,canvas.width/2- barDistance-invisibleBarWidth,0);
		grd.addColorStop(0,"#FF9");
		grd.addColorStop(1,"yellow");
		c.fillStyle=grd;
		c.strokeStyle=grd;
		if(invisibleEnergyAnimate%2==0)
		{
			c.strokeRect(canvas.width/2-(invisibleBarWidth+barDistance)+50,5,-invisibleBarWidth,10);
		}
		if(invisibleEnergyAnimate>0)
		{
			invisibleEnergyAnimate--;
		}
		c.fillRect(canvas.width/2-(invisibleBarWidth+barDistance)+50,5,-invisibleBarWidth*invisibleEnergy/maxInvisibleEnergy,10);
		if(invisibleEnergy<=0)
			{
				invisibleEnergyLow=1;
				invisibleEnergy=0;
			}
		if(invisibleEnergyLow==1)
		{
			c.font="8px 'Lucida Console'";
			c.fillText("low energy!",canvas.width/2-138,23);
		}
		c.font="20px '8bit'";		
	}

	function animateShieldBar()
	{
		c.fillStyle="red";
		c.strokeStyle="red";
		if(shield!=0)
		{
			c.strokeRect(canvas.width/2-shieldBarWidth/2,5,shieldBarWidth,10);
		}
		else
		{
			if(shieldAnimate%2==0)
			{
				c.strokeRect(canvas.width/2-shieldBarWidth/2,5,shieldBarWidth,10);
			}
			shieldAnimate--;
		}
		if(hitAnimate%2==0)
		{
			c.fillRect(canvas.width/2-shieldBarWidth/2,5,shield*shieldBarWidth/maxShield,10);
		}
		if(hitAnimate>0) hitAnimate--;
	}

	function drawPoints()
	{
		c.fillStyle="yellow";
		c.fillText("ScoXe: "+Math.round(score),canvas.width-150,30);
	}

	function animateShip()
	{
		if(bboxX>0)
		{
			c.drawImage(shipImages[shipAnimationCounter],offsetX,y,shipWidth,shipHeight);
		}
		else
		{
			c.drawImage(transparentShipImage,offsetX,y,shipWidth,shipHeight);
		}
		shipAnimationCounter++;
		if(shipAnimationCounter>shipImgCount)
		{
			shipAnimationCounter=0;
		}
	}

	function animateExplosions()
	{
		var i=0;
		while(expX[i]!=undefined)
		{
			c.drawImage(explosionImages[(Math.round(expAnimationCounter[i]))],expX[i],expY[i],expWidth[i],expHeight[i]);
			expAnimationCounter[i]+=1.5;
			if(expAnimationCounter[i]>expImgCount)
			{
				expX.splice(i,1);
				expY.splice(i,1);
				expHeight.splice(i,1);
				expWidth.splice(i,1);
				expAnimationCounter.splice(i,1);
				i--;
			}
			i++;
		}
	}
	function animateAsteroids()
	{
		var j=0;
		var zuloeschen=[];
		while(asteroidX[j]!=undefined)
		{
			asteroidX[j]-=asteroidSpeed;
			c.drawImage(asteroidImages[Math.round(asteroidAnimationCounter[j])],asteroidX[j],asteroidY[j],asteroidWidth,asteroidHeight);	
			asteroidAnimationCounter[j]+=0.06*timerInterval/6;
			if(asteroidAnimationCounter[j]>asteroidImgCount)
			{
				asteroidAnimationCounter[j]=0;
			}
			if(asteroidX[j]<0)
			{
				zuloeschen.push(j);
			}
			j++;
		}
		for(var i=0;i<zuloeschen.length;i++)
		{
			asteroidX.splice(zuloeschen[i]-i,1);
			asteroidY.splice(zuloeschen[i]-i,1);
			asteroidAnimationCounter.splice(zuloeschen[i]-i,1);
		}
	}

	function animateUfos()
	{
		var j=0;
		var zuloeschen=[];
		while(ufoX[j]!=undefined)
		{
			ufoAsteroidFly(j);
			ufoY[j]+=ufoSpeedy[j];
			if(ufoY[j]>canvas.height-ufoHeight)
			{
				ufoY[i]=canvas.height-ufoHeight;
				ufoSpeedy[i]*=-1;
			}
			if(ufoY[j]<0)
			{
				ufoY[i]=0;
				ufoSpeedy[i]*=-1;
			}
			ufoX[j]-=ufoSpeed;
			c.drawImage(ufoImages[Math.round(ufoAnimationCounter[j])],ufoX[j],ufoY[j],ufoWidth,ufoHeight);
			if(ufoX[j]<0)
			{
				zuloeschen.push(j);
			}
			j++;
		}
		for(var i=0;i<zuloeschen.length;i++)
		{
			ufoAnimationCounter.splice(zuloeschen[i]-i,1);
			ufoX.splice(zuloeschen[i]-i,1);
			ufoY.splice(zuloeschen[i]-i,1);
			ufoSpeedy.splice(zuloeschen[i]-i,1);
			lastUfoSpeed.splice(zuloeschen[i]-i,1);
		}
	}

	function animater2d2()
	{
		var k=0;		
		var zuloeschen = [];
		while(r2d2X[k]!=undefined)
		{
			r2d2X[k]-=r2d2Speed;
			c.drawImage(r2d2Image,r2d2X[k],r2d2Y[k],r2d2Width,r2d2Height);
		
			if(r2d2X[k]<0)
			{
				zuloeschen.push(k);
			}
			k++;
		}

		for(var i=0;i<zuloeschen.length;i++)
		{
			
			r2d2X.splice(zuloeschen[i]-i,1);
			r2d2Y.splice(zuloeschen[i]-i,1);
		}
	}

	function animateDeathStar()
	{
		if(deathstarX<canvas.width)
		{
			deathstary+=deathstarSpeed;
			if(deathstary+34<y&&!deathstarShooting)
			{
				deathstarSpeed=1;
			}
			if(deathstary+34>y+shipHeight&&!deathstarShooting)
			{
				deathstarSpeed=-1;
			}
			if(deathstary+34>y&&deathstary+34<y+shipHeight)
			{
				deathstarSpeed=0;
			}
			if(deathstary<=0)
			{
				deathstarSpeed=Math.abs(deathstarSpeed);
			}
			if(deathstary>=canvas.height-shipHeight/2)
			{
				deathstarSpeed=-Math.abs(deathstarSpeed);
			}

			if(deathstarX>canvas.width-deathstarWidth-10+1) deathstarX-=(deathstarX-(canvas.width-deathstarWidth-10))/100;
			c.drawImage(deathstarImage,deathstarX,deathstary,deathstarWidth,deathstarHeight);
			c.strokeStyle="red";
			c.fillStyle="red";
			c.strokeRect(canvas.width/2-deathstarBarWidth/2,canvas.height-deathstarBarHeight-barDistance/2,deathstarBarWidth,deathstarBarHeight);
			c.fillRect(canvas.width/2-deathstarBarWidth/2,canvas.height-deathstarBarHeight-barDistance/2,deathstarBarWidth*deathstarShield/deathstarMaxShield,deathstarBarHeight);
			if(deathstarShooting)
				{
				c.strokeStyle="green";
				c.lineWidth=0.5;
				c.beginPath();
				c.moveTo(deathstarX+29,deathstary+23);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				c.beginPath();
				c.moveTo(deathstarX+41,deathstary+23);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				c.beginPath();
				c.moveTo(deathstarX+42,deathstary+39);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				c.beginPath();
				c.moveTo(deathstarX+32,deathstary+46);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				c.beginPath();
				c.moveTo(deathstarX+23,deathstary+41);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				c.beginPath();
				c.moveTo(deathstarX+35,deathstary+21);
				c.lineTo(deathstarX+16,deathstary+34);
				c.closePath();
				c.stroke();
				grd=c.createLinearGradient(0,deathstary+33,0,deathstary+37);
				grd.addColorStop(0,"green");
				grd.addColorStop(0.5,"#54FF9F");
				grd.addColorStop(1,"green");
				c.fillStyle=grd;
				deathstarShotx=deathstarX+16;
				deathstarShoty=deathstary+33;
				c.fillRect(deathstarShotx,deathstarShoty,deathstarshotWidth,deathstarshotHeight);
				deathstarshotWidth-=deathstarshotSpeed;
				if(deathstarshotWidth<-canvas.width+deathstarWidth)
					{
						deathstarshotWidth=0;
						deathstarShooting=false;
					}
				}
		}
	}

	function moveShip()
	{
		y=y+isMoving*moveSpeed;
		if(y>canvas.height-shipHeight)
		{
			y=canvas.height-shipHeight;
		}
		if(y<0)
		{
			y=0;
		}
	}

	function getNextAsteroidInLine(x,y,width,height)
	{
		var index=-1;
		var tempX=0;
		var i=0;
		while(asteroidX[i]!=undefined)
		{
			if(y-asteroidY[i]<asteroidHeight&&y-asteroidY[i]>-height&&asteroidX[i]<x+width&&asteroidX[i]>tempX&&Math.abs(x-asteroidX[i])<canvas.width/6)
			{
				tempX=asteroidX[i];
				index=i;
			}
			i++;
		}
		return index;
	}
	function ufoAsteroidFly(ufoIncrementor)
	{
		var ind=getNextAsteroidInLine(ufoX[ufoIncrementor],ufoY[ufoIncrementor],ufoWidth,ufoHeight);
		if(ind!=-1)
		{
			if(ufoY[ufoIncrementor]-asteroidY[ind]<asteroidHeight&&ufoY[ufoIncrementor]-asteroidY[ind]>-ufoHeight&&asteroidX[ind]<ufoX[ufoIncrementor])
			{
				isNotFlying=false;
				if(ufoSpeedy[ufoIncrementor]==0)
				{
					{
						-((asteroidY[ind]+asteroidHeight/2)-(ufoY[ufoIncrementor]+ufoHeight/2))>0 ? ufoSpeedy[ufoIncrementor]=1:ufoSpeedy[ufoIncrementor]=-1
					}
				}
			}
		}
		else
		{
			lastUfoSpeed[ufoIncrementor]=ufoSpeedy[ufoIncrementor];
				ufoSpeedy[ufoIncrementor]=0;
		}
	}
	
	function timerFunc()
	{
		updateEnergy();
		c.clearRect(0,0,canvas.width,canvas.height);
		drawBackground();
		animateEnergyBar();
		animateShieldBar();
		drawPoints();
		moveShip();
		animateInvisibleBar();
		animateShip();
		drawShots(shotx,shoty,shotSpeed,"orange");
		drawShots(enemyShotx,enemyShoty,enemyshotSpeed,"green");
		animateAsteroids();
		animateUfos();
		animateExplosions();
		animater2d2();
		animateDeathStar();
		deathstarcheck();
		collisionDetection();
		energyRefill();
				
	}
	function asteroidFunc()
	{
			asteroidX.push(canvas.width-asteroidWidth/3);
			asteroidY.push(Math.random()*(canvas.height-asteroidHeight));
			asteroidAnimationCounter.push(0);
			if(asteroidInterval>=asteroidMinInterval)
			{
				clearInterval(asteroidTimer);
				asteroidTimer=null;
				asteroidInterval*=0.98;
				asteroidTimer=setInterval(function(){asteroidFunc()},asteroidInterval);
			}

	}

	function ufoFunc()
	{
		ufoAnimationCounter.push(Math.random()*2);
		ufoX.push(canvas.width-ufoWidth/3);
		ufoY.push(Math.random()*(canvas.height-ufoHeight));
		ufoSpeedy.push(0);
		lastUfoSpeed.push(0);
		ufoSpeed*=1.0015;
		asteroidSpeed*=1.002;
		backgroundSpeed*=1.001;
		enemyshotSpeed*=1.0015;
			if(ufoInterval>=ufoMinInterval)
			{
				clearInterval(ufoTimer);
				ufoTimer=null;
				ufoInterval*=0.995;
				ufoTimer=setInterval(function(){ufoFunc()},ufoInterval);
			}
	}

	function r2d2Func()
	{
		r2d2X.push(canvas.width-r2d2Width/3);
		r2d2Y.push(Math.random()*(canvas.height-r2d2Height));
	}



	function storeHighScore()
	{
		if(!stored&&localStorageDefined)
			{
			var i=0;
			var tempScore;
			var tempScore2;
			var tempName;
			var tempName2;
			for(;i<8;i++)
			{
				if(score>localStorage.getItem("highint"+i)||localStorage.getItem("highint"+i)=="null")
				{
					tempScore=localStorage.getItem("highint"+i);
					tempName=localStorage.getItem("highname"+i);
					localStorage.setItem("highint"+i,score);
					localStorage.setItem("highname"+i,localStorage.getItem("Name"));
					i++;
					break;
				}
			}
			for(;i<8;i++)
				{
					tempScore2=localStorage.getItem("highint"+i);
					tempName2=localStorage.getItem("highname"+i);
					localStorage.setItem("highint"+i,tempScore);
					localStorage.setItem("highname"+i,tempName);
					tempScore=tempScore2;
					tempName=tempName2;
				}	
		}
			stored=true;
	}
})