$(document).ready(startScreen);

var canvas;
var ctx;
var gameOverSoundID;
var winSoundID;
var gameSoundID;
var flag = false;
var buttonFlag = 0;

var logoImg = document.createElement('img');
	logoImg.src = './img/logo.png';
var ImgControls = document.createElement('img');
	ImgControls.src = './img/controls.jpg';
var ImgSpace = document.createElement('img');
	ImgSpace.src = './img/space.jpg';

function startScreen() {
	canvas = document.getElementById("myCanvas");

    if (canvas.getContext)
    {
      ctx = canvas.getContext("2d");
    }
	
    logoImg.onload = (function(){
    	drawLogo();
    	selectGameStart();
    	$('#theme')[0].play();
    	$('#theme')[0].loop = true;
    });  
	
	addEventListener('keydown', downKeyMenu);
}

function startGame() {
	clearInterval(gameOverSoundID);
	clearInterval(winSoundID);
	$('#theme')[0].pause();
	$('#sound')[0].currentTime = 1;	
	$('#sound')[0].play();
	removeEventListener('keydown', downKeyMenu);
	game();
}

function helpPage() {
	buttonFlag = 3;
	drawLogo();
	drawControls();
	flag = false;
	drawBackButton();
}

function startPage() {
	drawLogo();
	selectGameStart();
	$('#sound')[0].pause();
	if(flag) {
		$('#theme')[0].currentTime = 0;
	}
    $('#theme')[0].play();
}

var gameOverSound = function() {
	if($('#sound')[0].currentTime >= 268) {
		$('#sound')[0].currentTime = 255;
	}
}

var winSound = function() {
	if($('#sound')[0].currentTime >= 98) {
		$('#sound')[0].currentTime = 84;
	}
}

var gameSound = function() {
	if($('#sound')[0].currentTime >= 66) {
		$('#sound')[0].currentTime = 54;
	}
}

function downKeyMenu(e) {

	switch (e.keyCode) {

		// Up arrow 
	    case 38:
	    	drawLogo();
	    	selectGameStart();
	      	break;

		// Down arrow
	    case 40:
	    	drawLogo();
	    	selectControls();
	      	break;	    

	    // Enter
	    case 13:
	    	if(buttonFlag == 0) {
	    		startGame();
	    	}
	    	else if(buttonFlag == 1) {
	    		helpPage();
	    	}
	    	else if(buttonFlag == 3) {
	    		startPage();
	    	}
	}
}

var drawLogo = function() {
	ctx.fillStyle = 'black';
	ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);
	ctx.drawImage(logoImg, 0, -100, ctx.canvas.width, ctx.canvas.height);
}

var selectGameStart = function() {
	buttonFlag = 0;
	ctx.lineWidth = 1;
	drawMenu();
	for(var i=0; i<4; i++) {
		ctx.strokeStyle = 'green';
		ctx.strokeRect(ctx.canvas.width/2-110, 100, 200, 50);
		ctx.strokeStyle = 'white';
		ctx.strokeRect(ctx.canvas.width/2-110, 170, 200, 50);
	}
}

var selectControls = function() {
	buttonFlag = 1;
	ctx.lineWidth = 1;
	drawMenu();
	for(var i=0; i<4; i++) {
        ctx.strokeStyle = 'white';
		ctx.strokeRect(ctx.canvas.width/2-110, 100, 200, 50);
		ctx.strokeStyle = 'green';
		ctx.strokeRect(ctx.canvas.width/2-110, 170, 200, 50);
	}
}

var drawControls = function() {
	ctx.drawImage(ImgControls, 100, 100, 100, 50);
	ctx.drawImage(ImgSpace, 100, 180, 100, 40);
	ctx.fillStyle = 'white';
	ctx.font="20px Verdana";
	ctx.fillText("Oben, unten, links, rechts", 220, 130);
	ctx.fillText("Feuer!", 220, 210);
}

var drawMenu = function() {
	ctx.lineWidth = 1;
	ctx.fillStyle = 'white';
	ctx.font="20px Verdana";
	ctx.fillText("Spiel starten", ctx.canvas.width/2-70, 130);
	ctx.fillText("Steuerung", ctx.canvas.width/2-60, 200);
}

var drawBackButton = function() {
	ctx.lineWidth = 1;
	ctx.fillStyle = 'white';
	ctx.font="20px Verdana";
	ctx.fillText("Zurück", ctx.canvas.width/2-45, 270);
    ctx.strokeStyle = 'green';
	ctx.strokeRect(ctx.canvas.width/2-110, 240, 200, 50);
}