// set up game
var myWidth = 1000,
    myHeight = Math.floor(myWidth * 0.5),
    paper = Raphael("holder", myWidth, myHeight),
    display1 = document.getElementById("level"),
    display2 = document.getElementById("hits"),
    display3 = document.getElementById("lives"),
    offsetX = holder.offsetLeft + 3; // 3 = border-width
    offsetY = holder.offsetTop + 3;

var lifetime = 8000;
var dotRadius = 10,
    dotRadiusVariation = 30,
    dotAttr = {fill: "#000",
              "stroke-width": 0
              },
    explosionRadius = myWidth / 16,
    explosionSpeed = 10000 / explosionRadius;

var updateDisplay = function () {
    display1.innerHTML = "Level: " + level.toString();
    display2.innerHTML = "Hits: " + hits.toString() + " / " + goal;
    display3.innerHTML = "Lives: " + lives;
};

var levelUp = function() {
    level = level + 1;
    paper.text(myWidth / 2, myHeight / 2, "Level " + level).attr({fill: "#000", 'font-size': 65, 'font-family': "Open Sans"}).animate({opacity: 0}, 1000, function () {this.remove();});
    goal = goal + 20;
    hits = 0;
    lives = 10 + level;
    updateDisplay();
    targetLoops[level - 1] = setInterval(function() {
        addTargets(level);
    }, 3000);
}

var gameOver = function() {
    paper.forEach(function(el) {
        el.pause();
        el.exploded = 1;
        el.animate({opacity: 0}, 2000);
        el.remove;
    });
    for(i = 0; i < targetLoops.length; i++) {
        clearInterval(targetLoops[i]);
    };
    display1.innerHTML = "";
    display2.innerHTML = "GAME OVER";
    display3.innerHTML = "";
    setTimeout(function() {startButton();}, 2000);
    
};

var targetLoops = []; // collect setIntervall-loops that create dots

var startGame = function() {
    for(i = 0; i < targetLoops.length; i++) {
        clearInterval(targetLoops[i]);
    };
    paper.clear();
    level = 1;
    hits = 0;
    goal = 40;
    lives = 10;
    updateDisplay();
    addTargets(level);
    targetLoops[0] = setInterval(function() {
        addTargets(level);
    }, 3000);
};

var startButton = function() {paper.circle(myWidth / 2, myHeight / 2, 200).attr({fill: "blue"}).click(startGame);
paper.text(myWidth / 2, myHeight / 2, "Start Game").attr({fill:"#fff",'font-size': 65, 'font-family': "Open Sans"}).click(startGame);};
startButton();


var addTargets = function(level) {
    new redDot();
    new redDot();
    var sx1 = Math.floor(Math.random() * myWidth * 0.7  + myWidth * 0.15);
    var sy1 = Math.floor(Math.random() * myHeight * 0.7  + myHeight * 0.15);
    var start = setInterval( function() {
            new target(getCoord(sx1,sy1,300,150), getCoord(sx1,sy1,100,50));
        }, 100);
    setTimeout(function() {
        clearInterval(start);
    }, 400);
}

var target = function(start, stop) {
    radius = Math.floor(Math.random() * window.dotRadiusVariation) + window.dotRadius;
    var dot = paper.circle(start.x, start.y, 0).animate({r:radius}, 100);
    dot.exploded = 0;
    dot.explR = window.explosionRadius;
    dot.explSpeed = window.explosionSpeed;
    dot.collCount = 0;
    dot.attr(window.dotAttr)
        .animate({cx: stop.x, 
                  cy: stop.y,
                  opacity: 0}, 
                  window.lifetime, function() { 
                    if(this.exploded != 1){
                        lives = lives - 1;
                        display3.innerHTML = "Lives: " + lives;
                        if(lives < 0) { gameOver(); };
                        this.remove();
                    }
                }
        );    
    dot.explode = function(speed, explR) {
        if(this.exploded != 1){
            this.exploded = 1;
            hits = hits + this.collCount + 1;
            if(hits >= goal) {levelUp()};
            display2.innerHTML = "Hits: " + hits.toString() + " / " + goal;
            var dotColor = getColor();
            this.attr({stroke:dotColor, 
                       fill: "#fff", 
                       opacity: 1
                      });            
            this.animate({r: explR, 
                          "stroke-width": explR, 
                          opacity: 0.5}, 
                         speed, 
                         function() {
                            dot.toBack(); 
                            dot.collisionDetect(); 
                            dot.animate({opacity: 0}, 4000); 
                            setTimeout(function(){
                                dot.remove(); }, 3800)
                        });
        }
    };
    
    dot.collisionDetect = function() {
        var impact = this;
        paper.forEach(function(el) {
            if(impact.isPointInside(el.attr("cx"), el.attr("cy")) && el != impact) {
                el.collCount < 3 ? el.collCount = el.collCount + 1 : false;
                el.explR = el.explR * (1 + 0.25 * impact.collCount);
                el.explSpeed = el.explSpeed * (impact.collCount);
                el.explode(el.explSpeed, el.explR);
            }
        })
    };
    return dot;
};

var redDot = function() {
    var x1 = Math.floor(Math.random() * myWidth * 0.5  + myWidth * 0.25);
    var y1 = Math.floor(Math.random() * myHeight * 0.5  + myHeight * 0.25);
    var dot = new window.target(getCoord(x1, y1, 200, 100), getCoord(x1, y1, 200,100));
    dot.attr({fill: "#f00"});
    dot.drag(
        // move
        function(dx,dy,x,y) {
            if(this.exploded != 1){
                this.attr({cx: x - offsetX, cy: y - offsetY});
            }
        },
        // start
        function() {
            if(this.exploded != 1){
                this.pause();
                this.toFront();
                this.attr({"opacity": 1});                
            }
        },
        // end
        function() {
            if(this.exploded != 1){this.explode(this.explSpeed, this.explR);}});
    return dot;
};

// define position of dot and color of explosion
var getCoord = function(x, y, dx, dy) { 
    return {x: x + Math.floor(Math.random() * dx * 2 - dx), 
            y: y + Math.floor(Math.random() * dy * 2 - dy)}
};

var getColor = function() {
        var colorBucket = ["red", "green", "blue", "yellow", "cyan", "magenta", "gold"];
        var randomIndex = Math.floor(Math.random() * colorBucket.length);
        return colorBucket[randomIndex];
};