//$(document).ready(function(){

//************ Keyboard-Input ***********************
function playEngineSound(){
	if(sound=='on'){
		$('#engineSound').each(function(i,a){
			a.play();
		})
	}
}	

	//console.log(event.keyCode);	// Zum Abfragen, wie die Keys gemappt sind, danach kann man die switch-case schreiben,
									// später auch für manuelle Tastenbelegung im Spiel		
var keydown = function(event){
	if(game.gameTimeLeft>0){	
		switch (event.keyCode) {
			case 87: //w  = forward tank 1
				tank1.status='forward';
				playEngineSound();
				break;
			case 83: //s = backward tank 1
				tank1.status = 'backward';
				playEngineSound();
				break;
			case 65: //a = rotate left tank 1
				tank1.status = 'left';
				playEngineSound();
				//console.log('Rotation: '+tank1.vec.rot);	// DEBUG
				break;
			case 68: //d = rotate right tank 1
				tank1.status = 'right';
				playEngineSound();
				//console.log('Rotation: '+tank1.vec.rot);	// DEBUG
				break;
			case 32:  //space shoot tank 1
				game.createBullet(tank1);
				break;

			case 38: //UpArrow  = forward tank 2
				tank2.status='forward';
				playEngineSound();
				break;
			case 40: //DownArrow = backward tank 2
				tank2.status = 'backward';
				playEngineSound();
				break;
			case 37: //LeftArrow = rotate left tank 2
				tank2.status = 'left';
				playEngineSound();
				break;
			case 39: //RightArrow = rotate right tank 2
				//tank1.rotation=tank1.rotation+(180*Math.PI);	//Rotation um 1 Grad;
				tank2.status = 'right';
				playEngineSound();
				break;
			case 17:  //Ctrl shoot tank 2 	//Alternative: 16 for Shift
				game.createBullet(tank2);
				break;

				
		}
		return false;
	}
};
var keyup = function(event){
	if(game.gameTimeLeft>=0){
		switch (event.keyCode) {
			case 87: 	//w  = forward tank 1			
			case 83: 	//s = backward tank 1				
			case 65: 	//a = rotate left tank 1								
			case 68: 	//d = rotate right tank 1
			case 32: 	//space shoot tank 1
				tank1.status='idle';  
				break;

			case 38: //UpArrow  = forward tank 2		
			case 40: //DownArrow = backward tank 2				
			case 37: //LeftArrow = rotate left tank 2
			case 39: //RightArrow = rotate right tank 2
			case 17:  //Ctrl shoot tank 2 	//Alternative: 16 for Shift
				tank2.status='idle';
				break;		
		}
		if(tank1.status=='idle' && tank2.status=='idle'){
			$('#engineSound').each(function(i,a){
				a.pause();
				a.currentTime=0;
			})
		}
		return false;
	}
};
$('html').bind('keydown', keydown).bind('keyup', keyup); // Die beiden Events festlegen	
/*
//************ Collision Test ******************
function colCheck(){
	//Tanks prüfen, ob in Hindernis

	//Kugeln prüfen, ob in Tank / Wand /Zeit abgelaufen

	//Tanks prüfen, ob aus Spiel raus

};
*/
	// Move options of the tank, determined by its status
	this.move= function(){
	switch(this.status){
		case 'idle':
			break;
		case 'forward':
			this.setPosition( this.x +this.vec.dx*tankspeed, this.y + this.vec.dy*tankspeed);
			break;
		case 'backward':
			this.setPosition( this.x -this.vec.dx*tankspeed, this.y - this.vec.dy*tankspeed);
			break;
		case 'left':
			this.vec.changerotation(-Math.PI/180*rotspeed);
			break;
		case 'right':
			//this.rotation=this.rotation+(180*Math.PI);	//Rotation um 1 Grad;
			this.vec.changerotation(Math.PI/180*rotspeed);
			break;
		case 'shoot':
			this.createBullet();
			break;
		}
	};



	this.draw = function(mycan){

		mycan.fillStyle=this.color;
		mycan.save();
		mycan.translate(this.x +this.width/2,this.y+ this.height/2);
		mycan.rotate(this.vec.rot);	//nimmt Eck oben links
		mycan.fillRect(-this.width/2, -this.height/2, this.width, this.height);	//later becomes drawImage(..);
		mycan.restore();

		mycan.fillStyle=cannoncolor;
		mycan.lineWidth=cannonwidth;
		mycan.beginPath();
		mycan.moveTo(  	this.x + (this.width/2), this.y + (this.height/2)  );
		mycan.lineTo(  	this.x + (this.width/2) +this.vec.dx*cannonlength,		
						this.y + (this.height/2) + this.vec.dy*cannonlength);
		mycan.stroke();		

	}


	var mycan = $('#gamefieldcanvas')[0].getContext('2d');
//************ Drawing of Everything ******************
function render(){
	
	var bgColor='#0F0';	//Color of Scoreboard
	var scoreBoardColor='#0FF';

	//Draw Scoreboard
	mycan.fillStyle=scoreBoardColor;
	mycan.fillRect(0, 0, 800, 50);

	//Draw Gameboard
	mycan.fillStyle=bgColor;
	mycan.fillRect(0, 50, 800, 550);
	if(game.objects.length>=1){
		for (var i=game.objects.length -1; i>=0; i--){
			game.objects[i].draw(mycan);
		}
		
	}
	if(game.players.length>=1){
		for (var i=game.players.length-1; i>=0; i--){
		game.players[i].draw(mycan);
		}
		
	}
	game.drawGameTimeLeft(mycan);

};

function soundButtonClicked(){
	//console.log("Clicked");
	var audio=$('audio');
	audio.each(function(i, a) {
		if (a.paused === false){
			a.pause();
			a.currentTime=0;
		}
	})
	if (sound == 'on'){
		sound = 'off';
		$("#soundButton").text('Ton einschalten');
	}
	else{
		sound ='on';
		$('#soundButton').text('Ton ausschalten');
		if($('#gamefieldcanvas').is(':visible')){
			if(game.gameTimeLeft>0){
				$('#gameSound').each(function(i,a){
					a.play();
				})
			}
			else{
				$('#scoreBoardSound').each(function(i,a){
					a.play();
				})
			}
			
		}
		else{
			$('#menuSound').each(function(i,a){
					a.play();
				})
		}
				
	}
}  
