// +++++++++++++++++++++ GAME LOOP +++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++
	//************ Copied, is my game graphics loop *******************
	// (description from Paul Irish, http://www.paulirish.com/2011/requestanimationframe-for-smart-animating/) 
	// shim layer with setTimeout fallback
	window.requestAnimFrame = (function(){
	  return  window.requestAnimationFrame       ||
	          window.webkitRequestAnimationFrame ||
	          window.mozRequestAnimationFrame    ||
	          function( callback ){
	            window.setTimeout(callback, 1000 / 60);
	          };
	})();
	// ************ End of game loop *********************

// +++++++++++++++++++++ CREATING STUFF +++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++


$('.newGameButton').click(function(){
	document.getElementById('mainMenu').style.display='none';
	document.getElementById('gamefieldcanvas').style.display='block';
	//Start backgroundmusic
	if(sound=='on'){
		$('audio').each(function(i,a){
				if (a.paused === false){
					a.pause();
					a.currentTime=0;
				}
			})
		$('#gameSound').each(function(i,a){
						a.play();
		})
	}
	//Create Game instance
	game = new Game();

	player1= new Player(1);
	player2= new Player(2);
		game.players.push(player1);
		game.players.push(player2);

	// Create instance of player 1
	tank1 = new Tank(1);	//1 is for first player, 2 for second
	//Adding the instance to the Game Object
		game.objects.push(tank1);
	tank2 = new Tank(2);
		game.objects.push(tank2);

	fence1 = new Fence(0,50 ,800, 20);
		game.objects.push(fence1);
	fence2 = new Fence(0,580 ,800, 20);
		game.objects.push(fence2);

	fence3 = new Fence(270, 315, 300, 50);
		game.objects.push(fence3);
	fence4 = new Fence(400, 180, 50, 300);
		game.objects.push(fence4);

	fence5 = new Fence(150,150,100,50);
		game.objects.push(fence5);
	fence6 = new Fence(600,150,100,50);
		game.objects.push(fence6);
	fence7 = new Fence(150,450,100,50);
		game.objects.push(fence7);
	fence8 = new Fence(600,450,100,50);
		game.objects.push(fence8);
	fence9 = new Fence();
		game.objects.push(fence9);



// +++++++++++++++++++++ GAME LOGIC LOOP +++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++
	gameloop = setInterval(function(){
		if (game.gameTimeLeft>0){
			game.collisionCheck();
			game.moveAll();
			game.decreaseLifetime();
			game.reduceCooldown();
	//		tank2.move();
			game.decreaseGameTime();			
		}
		if (game.gameTimeLeft==0){
			game.gameTimeLeft=-1;
		
			console.log("Game has ended!");
			//document.getElementById('mainMenu').style.display='block';
			//document.getElementById('gamefieldcanvas').style.display='none';
			$('audio').each(function(i,a){
				if (a.paused === false){
					a.pause();
					a.currentTime=0;
				}
			})
			if(sound=='on'){
				$('#scoreBoardSound').each(function(i,a){
						a.play();
				})
			}
			var scorecanvas=$('#gamefieldcanvas')[0].getContext('2d');
			var img1 = new Image(); // HTML5 Constructor
			img1.src = 'Graphics/EndGame.jpg';
			img1.alt = ' ';
			scorecanvas.drawImage(img1, 0, 0, 800, 600);

			var player =game.players;
			var p1score, p2score;
				scorecanvas.font="60px Arial";
			for (var i=player.length -1; i>=0; i--){
				if(player[i].playernumber==1){
					scorecanvas.fillStyle='#FF0000';	
					scorecanvas.fillText("Punkte: "+player[i].points, 500,70);
					scorecanvas.fillText("Spieler: "+player[i].playername, 50,70);
					p1score=player[i].points;
				}
				if (player[i].playernumber==2){
					scorecanvas.fillStyle='#0000FF';
					scorecanvas.fillText("Punkte: "+player[i].points, 500,570);
					scorecanvas.fillText("Spieler: "+player[i].playername, 50,570);
					p2score=player[i].points;
				}
				//else
				//console.log("Error getting playernumber from Player "+player[i].playername);
			}
			scorecanvas.fillStyle='#000';
			scorecanvas.font="100px Arial";
			if(p1score>p2score)
				scorecanvas.fillText("Spieler 1 siegt!",50,300);
			if(p1score<p2score)
				scorecanvas.fillText("Spieler 2 siegt!",50,300);
			if(p1score==p2score)
				scorecanvas.fillText("Unentschieden!",50,300);

			document.getElementById('mainMenu').style.display='block';
		}
	}, 50);
});

//************ Copied, is my game graphics loop *******************
// the render function is / will be my function that draws everything and has to be created somewhere
	(function animloop(){
  requestAnimFrame(animloop);
  if(game!== undefined && game.gameTimeLeft>0){
  	render(); 
  }

})();
// ************ End of game graphics loop *********************



