
var canv = $('#canvasElement').get(0);
var canvCtx = canv.getContext('2d');
var canvWidth = canv.scrollWidth;
var canvHeight = canv.scrollHeight;

// ausgelagerte Kollisionsfunktionen

function collidesFromRight(firstRectx,firstRecty,firstRectwidth,firstRectheight,secondRectx,secondRecty,secondRectwidth,secondRectheight) {
	return (firstRecty > secondRecty - firstRectheight && firstRecty < secondRecty + secondRectheight
	&& firstRectx + firstRectwidth >= secondRectx && firstRectx + firstRectwidth <= secondRectx + secondRectwidth);
}

function collidesFromLeft(firstRectx,firstRecty,firstRectwidth,firstRectheight,secondRectx,secondRecty,secondRectwidth,secondRectheight) {
	return (firstRecty > secondRecty - firstRectheight && firstRecty < secondRecty + secondRectheight
			&& firstRectx <= secondRectx + secondRectwidth && firstRectx >= secondRectx);
}

function collidesFromBottom(firstRectx,firstRecty,firstRectwidth,firstRectheight,secondRectx,secondRecty,secondRectwidth,secondRectheight) {
	return (firstRecty + firstRectheight >= secondRecty && firstRecty + firstRectheight <= secondRecty + secondRectheight
			&& firstRectx + firstRectwidth > secondRectx  && firstRectx < secondRectx + secondRectwidth);
}

function collidesFromTop(firstRectx,firstRecty,firstRectwidth,firstRectheight,secondRectx,secondRecty,secondRectwidth,secondRectheight) {
	return (firstRecty <= secondRecty + secondRectheight && firstRecty >= secondRecty
			&& firstRectx + firstRectwidth > secondRectx  && firstRectx < secondRectx + secondRectwidth);
}


//---------------------
//  Objekte
//---------------------

function randomObject(_x,_y,width,height, context)
{
	var me = this;
	me.x = _x;
	me.y = _y;
	me.width = width;
	me.height = height;
	me.ctx = context;
}

// Objektprototyp zeichnen

randomObject.prototype.draw = function() {
	var me = this;
	me.ctx.fillStyle = '#556b2f';
	me.ctx.fillRect(me.x,me.y,me.width,me.height);
}

randomObject.prototype.move = function () {
	//hier kann man noch funktionalität hinzufügen
}



randomObject.prototype.checkForCollision = function (otherObject) {
	if(otherObject instanceof randomObject){
		return false
	} else {
		return otherObject.checkForCollision(this);
	}
}


//----------------------------------------------------------------------------------
// Held 
//----------------------------------------------------------------------------------

function Hero(_x,_y,context)
{
	var me = this;
	me.x = _x || 0;
	me.y = _y || 0;
	me.width = 20;
	me.height = 20;
	me.ctx = context;
	me.direction = "down";
	me.bwg = 5;

	me.catched = false;
	me.movesUp = false;
	me.movesDown = false;
	me.movesLeft = false;
	me.movesRight = false;
}

Hero.prototype.draw = function() {
	var me = this;
	me.ctx.fillStyle = '#00F';
	me.ctx.fillRect(me.x,me.y,me.width,me.height);
}

Hero.prototype.move = function(){
	var me = this;

	if(me.movesUp){
		me.y = me.y - me.bwg;
			}

	if(me.movesDown){
		me.y = me.y + me.bwg;
		}

	if(me.movesRight){
		me.x = me.x + me.bwg;
		}

	if(me.movesLeft){
		me.x = me.x - me.bwg;
		} 

}

Hero.prototype.checkForCollision = function(otherObject)
{
	var me = this;

	if(otherObject instanceof randomObject) {
		//kollision nach rechts
		if(me.movesRight)
			me.movesRight = !collidesFromRight(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach links
		if(me.movesLeft)
			me.movesLeft = !collidesFromLeft(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach oben
		if(me.movesUp)
			me.movesUp = !collidesFromTop(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach unten
		if(me.movesDown)
			me.movesDown = !collidesFromBottom(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
	} else {
		otherObject.checkForCollision(this);
	}

}

// Sprites für den Hero 

// 	var setAni = function(dir, press) {		
// 		if(!press) {
// 			Hero.destroy();
// 			direction = 0;
// 		}
// 		else {
// 			direction = dir;
		
// 			if(dir < 0) {
// 				Hero.addClass('mirror');
// 				dir *= -1;
// 			} else
// 			{
// 				Hero.removeClass('mirror');
				
// 			Hero.sprite({ fps : 25, no_of_frames : 6 }).spState(dir);
// 		}
// }


//--------------------------------------------------------------------
// Gegner 
//--------------------------------------------------------------------

function enemy (_x, _y, width, height, context){
	var me = this;
	me.x = _x;
	me.y = _y;
	me.width = width;
	me.height = height;
	me.ctx = context;
	me.speedEnemy = 2;

	me.movesUp = false;
	me.movesDown = false;
	me.movesLeft = false;
	me.movesRight = false;
}

enemy.prototype.draw = function() {
	var me = this;
	me.ctx.fillStyle = '#CCC';
	me.ctx.fillRect(me.x,me.y,me.width,me.height);
}

enemy.prototype.move = function () {
		
		var me = this;
		if(me.movesLeft) {
			me.x = me.x-me.speedEnemy;
		}
		if (me.movesRight) {
			me.x = me.x+me.speedEnemy;
		}
		if(me.movesUp) {
			me.y = me.y-me.speedEnemy;
		}
		if(me.movesDown) {
			me.y = me.y+me.speedEnemy;
		}

		//directions for the next step
		me.movesLeft = false;
		me.movesRight = false;
		me.movesDown = false;
		me.movesUp = false;

		if (me.x > h.x)
		{
			me.movesLeft = true;
		}
		if(me.x < h.x)
		{
			me.movesRight = true;
		}
		if(me.y < h.y)
		{
			me.movesDown = true;
		}
		if(me.y > h.y)
		{
			me.movesUp = true;
		}
	}

enemy.prototype.checkForCollision = function(otherObject) {
	var me = this;

	if(otherObject instanceof bullet)
	{
		if(otherObject.checkForCollision(me)) 
		{
			ObjectArray.splice(ObjectArray.indexOf(me),1);
		}

	} else if(otherObject instanceof randomObject || otherObject instanceof	enemy) {
		//kollision nach rechts
		if(me.movesRight)
			me.movesRight = !collidesFromRight(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach links
		if(me.movesLeft)
			me.movesLeft = !collidesFromLeft(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach oben
		if(me.movesUp)
			me.movesUp = !collidesFromTop(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach unten
		if(me.movesDown)
			me.movesDown = !collidesFromBottom(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
	} else if(otherObject instanceof Hero){
		if(me.movesRight)
			h.catched = collidesFromRight(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach links
		if(me.movesLeft)
			h.catched = collidesFromLeft(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach unten
		if(me.movesDown)
			h.catched = collidesFromBottom(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);
		//kollision nach oben
		if(me.movesUp)
			h.catched = collidesFromTop(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height);

	if(h.catched)
			{
				alert('You are Dead!');
				restartGame();
			}	
	


}
}


//-------------------------------------------------------------------------------------
// Objekte hinzufügen

function startGame(){



h = new Hero(canvWidth/2,canvHeight/2,canvCtx);
ObjectArray = [];
ObjectArray.push(h);

//------------------------------------------------------------------------------------
// Feste Objekte einfügen
ObjectArray.push(new randomObject(100,60, 10, 100, canvCtx));
ObjectArray.push(new randomObject(50,60, 100, 10, canvCtx));
ObjectArray.push(new randomObject(50,60, 10, 10, canvCtx));
ObjectArray.push(new randomObject(700,200, 10, 100, canvCtx));
ObjectArray.push(new randomObject(350,350, 150, 10, canvCtx));
ObjectArray.push(new randomObject(400,30, 10, 50, canvCtx));
ObjectArray.push(new randomObject(200,200, 10, 20, canvCtx));
ObjectArray.push(new randomObject(600,150, 10, 20, canvCtx));


//-------------------------------------------------------------------------------------
// Canvasgrenzen

ObjectArray.push(new randomObject(-10,0, 10, canvHeight, canvCtx));	// Linke Grenze
ObjectArray.push(new randomObject(0,-10, canvWidth, 10, canvCtx));	// Obere Grenze
ObjectArray.push(new randomObject(canvWidth,0, 10, canvHeight , canvCtx));  // Rechte Grenze
ObjectArray.push(new randomObject(0, canvHeight, canvWidth, 10, canvCtx));		//Untere Grenze
//------------------------------------------------------------------------------------
// Zombies erstellen

ObjectArray.push(new enemy(110, 110, 10, 10, canvCtx));
ObjectArray.push(new enemy(120, 150, 10, 10, canvCtx));
ObjectArray.push(new enemy(140, 110, 10, 10, canvCtx));
ObjectArray.push(new enemy(120, 120, 10, 10, canvCtx));
ObjectArray.push(new enemy(300, 200, 10, 10, canvCtx));
ObjectArray.push(new enemy(420, 390, 10, 10, canvCtx));
ObjectArray.push(new enemy(220, 250, 10, 10, canvCtx));
ObjectArray.push(new enemy(720, 350, 10, 10, canvCtx));
ObjectArray.push(new enemy(760, 50, 10, 10, canvCtx));
ObjectArray.push(new enemy(20, 50, 10, 10, canvCtx));
ObjectArray.push(new enemy(320, 250, 10, 10, canvCtx));
ObjectArray.push(new enemy(380, 340, 10, 10, canvCtx));
ObjectArray.push(new enemy(620, 340, 10, 10, canvCtx));
ObjectArray.push(new enemy(720, 270, 10, 10, canvCtx));
ObjectArray.push(new enemy(440, 50, 10, 10, canvCtx));
ObjectArray.push(new enemy(420, 70, 10, 10, canvCtx));
ObjectArray.push(new enemy(380, 40, 10, 10, canvCtx));
ObjectArray.push(new enemy(30, 340, 10, 10, canvCtx));
ObjectArray.push(new enemy(30, 70, 10, 10, canvCtx));
}





//-------------------------------------------------------------------------------------
// Gameloop
//-------------------------------------------------------------------------------------
var h, ObjectArray;
startGame();
GameLoop = setInterval(gameLoopFunction, 30);

function gameLoopFunction()
{
	canvCtx.clearRect(0,0,canvCtx.canvas.width,canvCtx.canvas.height); //alles löschen

	//Kollisionen kontrollieren
	for (var i = 0; i < ObjectArray.length - 1; i++) {
		for (var j = i+1; j < ObjectArray.length; j++) {
			ObjectArray[i].checkForCollision(ObjectArray[j]);
		}
	}

	//alles bewegen
	for (var i = ObjectArray.length - 1; i >= 0; i--) {
		ObjectArray[i].move();
	};

	//alles zeichnen
	for (var i = 0; i< ObjectArray.length; i++) {
		ObjectArray[i].draw();
	};

}

function restartGame() {
	clearInterval(GameLoop);
	startGame();
	GameLoop = setInterval(gameLoopFunction, 30);
}



$('html').keydown(function(event){
	//console.log(event);
	switch (event.keyCode) {
			// case 87||65||83||68 ://Enter
			// 	var b = new bullet(h.x + h.width /2 ,h.y + h.height /2 ,h.ctx, h.direction);
			// 	b.center();
			// 	b.move();
			// 	ObjectArray.push(b);
			// 	break;
			case 37://Linke Pfeiltaste
				h.movesLeft = true;
				h.direction = 'left';
				//setAni(2, !up);
				break;
			case 38://Pfeiltaste nach oben
				h.movesUp = true;
				h.direction = 'up';
				//setAni(1, !up);
				break;
			case 39://Rechte Pfeiltaste
				h.movesRight = true;
				h.direction = 'right';
				//setAni(-2, !up);
				break;
			case 40://Pfeiltaste nach unten
				h.movesDown = true;
				h.direction = 'down';
				//setAni(3, !up);
				break;
			case 87:// W
				var b = new bullet(h.x + h.width /2 ,h.y + h.height /2 ,h.ctx, h.direction);
				b.center();
				b.move();
				ObjectArray.push(b);
				h.direction = 'W';
				break;
			case 65:// A 
				var b = new bullet(h.x + h.width /2 ,h.y + h.height /2 ,h.ctx, h.direction);
				b.center();
				b.move();
				ObjectArray.push(b);
				h.direction = 'A';
				break;
			case 83:// S
				var b = new bullet(h.x + h.width /2 ,h.y + h.height /2 ,h.ctx, h.direction);
				b.center();
				b.move();
				ObjectArray.push(b);
				h.direction = 'S';
				break;
			case 68:// D
				var b = new bullet(h.x + h.width /2 ,h.y + h.height /2 ,h.ctx, h.direction);
				b.center();
				b.move();
				ObjectArray.push(b);
				h.direction = 'D';
				break;	
			}
});




$('html').keyup(function(event){
	switch (event.keyCode) {
		case 37://Linke Pfeiltaste
			h.movesLeft = false;
			break;
		case 38://Pfeiltaste nach oben
			h.movesUp = false;
			break;
		case 39://Rechte Pfeiltaste
			h.movesRight = false;
			break;
		case 40://Pfeiltaste nach unten
			h.movesDown = false;
			break;
	}
});

//Schussfunktion

function bullet(_x, _y, context, _direction){
		var me = this;
		me.x = _x || 10;
		me.y = _y || 10;
		me.width = 6;
		me.height = 6;
		me.direction = _direction;
		me.ctx = context;
		me.speed = 10;
}

bullet.prototype.center = function() {
	var me = this;
	me.x = me.x - me.width/2;
	me.y = me.y - me.height/2;
}

bullet.prototype.draw = function() {
	var me = this;
	me.ctx.fillStyle = '#F00';
	me.ctx.fillRect(me.x,me.y,me.width,me.height);
}

bullet.prototype.move = function(speed) {
	var me = this;
	var currentspeed = speed || me.speed;
	switch(me.direction) {
		case 'W':
			me.y = me.y - currentspeed;
		break;
		case 'S':
			me.y = me.y + currentspeed;
		break;
		case 'D':
			me.x = me.x + currentspeed;
		break;
		case 'A':
			me.x = me.x - currentspeed;
		break;
	}
}

bullet.prototype.checkForCollision = function(otherObject) {
	var me = this;
	switch(me.direction) {
		case 'W':
		if(!collidesFromTop(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height))
			return false;
		break;
		case 'S':
		if(!collidesFromBottom(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height))
			return false;
		break;
		case 'D':
		if(!collidesFromRight(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height))
			return false;
		break;
		case 'A':
		if(!collidesFromLeft(me.x,me.y,me.width,me.height,otherObject.x,otherObject.y,otherObject.width,otherObject.height))
			return false;
		break;
	}
	ObjectArray.splice(ObjectArray.indexOf(me),1);
	return true;
}


//Dieses Projekt enstand im Kurs Webapplications (Blockkurs SoSe14) und wurde von Teresa Eggerstorfer und Christian Baumgartner programmiert.//

