{
    // For Hitbox-Dbg: Add WiredHitBox to Components of the corresponding objects,
    
    // Basic properties of Walls (they are black, and do have a hitbox)
    Crafty.c(
	"Wall", {
	    init: function() {
		this.addComponent("2D,Canvas,Color,Collision,wall,coll") 
		    .color('black');
	    },
	    wall: function(x,y,w,h) {
		this.x = x*1 || 0;
		this.y = y*1 || 0;
		this.w = w*1 || 0;
		this.h = h*1 || 0;
		
		this.attr({x:this.x, y:this.y, w:this.w, h:this.h})
		    .collision();
		
		return this;
	    }
	}
    );
    
    // Thing may later be used for treasuries, then it would need a hitox itself.
    // old_pos is used for distance calculations.
    Crafty.c(
	"Thing", {
	    init: function() {
		this.addComponent("2D,Canvas,Color,thing");
		this.old_pos={"x":0, "y":0};
	    },
	    thing: function(x,y,w,h,col) {
		this.x = x || 0;
		this.y = y || 0;
		this.w = w || 20;
		this.h = h || 20;
		this.col = col || "black";
		
		this.attr({x:this.x, y:this.y, w:this.w, h:this.h})
		    .color(col);
		this.old_pos["x"]=this.x;
		this.old_pos["y"]=this.y;
		return this;
	    }
	}
    );
    
    // Creatures are players as well as monsters. They may be moved either by mouse, or by fourway-buttons.
    Crafty.c(
	"Creature", {
	    init: function() {
		this.addComponent("Thing,Fourway,Draggable,Collision,Mouse,creature,coll"); 
	    },
	    creature: function(id,x,y,w,h,col) {
		this.id=id || "";
		this.h = h || 40;
		this.w = w || 40;
		this.x = x || 0;
		this.y = y || 0;
		this.thing(x,y,w,h,col)
		    .collision()
		    .fourway(4)
		    .onHit("coll", function(hb) {
			/* If object hits something it shouldn't, release it from influence of mouse
			 */
			var t=cur_sel.graphelement;
			t.stopDrag();
			if (hb[0].normal && (! isNaN(hb[0].overlap)) ) {
			    /* If it ends up overlapping with oneo r several other objects,
			     * push it back as long as necessary
			     */
			    do {
				var nor=hb[0].normal;
				var ol=hb[0].overlap;
				t.x += Math.ceil(nor.x * -ol);
				t.y += Math.ceil(nor.y * -ol);
			    }
			    while( (hb=t.hit("coll")) && (t.hit("coll")[0].normal) && 
				   (t.hit("coll")[0].overlap) );
			}
		    });

		/* Mouse-actions: 
		 * left click: select creature, save old position, make only this creature
		 * controllable by mouse, write output info
		 * right click: If current selected creature, show battle menu,
		 * otherwise just attack (by now)
		 */
		this.bind('MouseDown', function(e) {
		    if(e.mouseButton === Crafty.mouseButtons.LEFT) {
			if( cur_sel != player[this.id] ) {
			    this.calc_center();
			    this.old_pos["cx"]=this.cx;
			    this.old_pos["cy"]=this.cy;
			    this.old_pos["x"]=this.x;
			    this.old_pos["y"]=this.y;
			};
		    	Crafty("Creature").each( function() {
			    this.disableControl();
			});
			cur_sel=player[this.id];
			if (! cur_sel.enem) {
			    $('#uibon').show();
			    cur_sel.sel_bon();
			}
			else {
			    $('#uibon').hide();
			}
			cur_sel.printoutput();
			cur_sel.sel_att();
			this.enableControl();
		    };
		    if(e.mouseButton === Crafty.mouseButtons.RIGHT) {
			if ( !cur_sel ) { return; };
			if ( cur_sel != player[this.id] )
			{
			    cur_sel.attack(player[this.id]);
			};
		    };
		});
		this.bind('MouseUp', function(e) {
		    if(e.mouseButton === Crafty.mouseButtons.LEFT) {
			cur_sel.printoutput();
		    }
		});
		this.bind('KeyUp', function(e) {
		    cur_sel.printoutput();
		});
		
		return this;
	    },
	    calc_center: function() {
		this.cx = this.x + (this.w / 2);
		this.cy = this.y + (this.h / 2);
	    }
	}
    );
    
    /* function for basic setup: creates canvas and small boxes that keep ojects on it
     */
    var start_init = function(w,h) {
	var width=w || 500;
	var height=h|| 400;
	Crafty.init(width,height, document.getElementById('game'));

	//Create Bounding Box
	Crafty.e("Wall,Color").wall(0,0,width,1).color('white'); // Top
	Crafty.e("Wall,Color").wall(0,0,1,height).color('white');
	Crafty.e("Wall,Color").wall(0,height,width,-1).color('white'); // Bottom
	Crafty.e("Wall,Color").wall(width,0,-1,height).color('white');

    };	

    /* At the end, disable mouse-control for all creatures
     */
    var last_sel;
    var end_init = function() {
	Crafty("Creature").each( function() {
	    this.disableControl();
	});
	$(window).focus( function() {
	    last_sel = cur_sel;
	});
    };
    
    var reset_bug = function() {
	Crafty("Thing").each( function() {
	    this._movement.x=0;
	    this._movement.y=0;
	});
	var g= last_sel.graphelement;
	g.attr("x",g.old_pos.x);
	g.attr("y", g.old_pos.y);
    };
}
