﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net.Sockets;
using System.Threading;
using System.IO;
using System.Net;

namespace ChatClient
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            Application.Current.Exit += Current_Exit;
        }

        

        // Will hold the alias
        private string AliasName = "Unknown";
        private StreamWriter swSender;
        private StreamReader srReceiver;
        private TcpClient tcpServer;
        // Needed to update the form with messages from another thread
        private delegate void UpdateLogCallback(string strMessage);
        // Needed to set the form to a "disconnected" state from another thread
        private delegate void CloseConnectionCallback(string strReason);
        private Thread thrMessaging;
        private IPAddress ipAddr;
        private bool Connected;

        void Current_Exit(object sender, ExitEventArgs e)
        {
            if (Connected == true)
            {
                // Closes the connections, streams, etc.
                Connected = false;
                swSender.Close();
                srReceiver.Close();
                tcpServer.Close();
            }
        }
        
        private void ConncetButton_Click(object sender, RoutedEventArgs e)
        {
            // If we are not currently connected but awaiting to connect
            if (Connected == false)
            {
                // Initialize the connection
                InitializeConnection();
            }
            else // We are connected, thus disconnect
            {
                CloseConnection("Disconnected at user's request.");
            }          
        }

        private void InitializeConnection()
        {
            try
            {
                // Parse the IP address from the TextBox into an IPAddress object
                ipAddr = IPAddress.Parse(IpAdressTextBox.Text);
                // Start a new TCP connections to the chat server
                tcpServer = new TcpClient();
                tcpServer.Connect(ipAddr, Int32.Parse(PortTextBox.Text));

                // Helps us track whether we're connected or not
                Connected = true;
                // Prepare the form
                AliasName = AliasTextBox.Text;

                // Disable and enable the appropriate fields
                SendButton.IsEnabled = true;
                ConncetButton.Content = "Disconnect";

                // Send the desired username to the server
                swSender = new StreamWriter(tcpServer.GetStream());
                swSender.WriteLine(UserTextBox.Text + ";" + PasswordTextBox.Password + ";" + AliasTextBox.Text + "#");
                swSender.Flush();

                // Start the thread for receiving messages and further communication
                thrMessaging = new Thread(new ThreadStart(ReceiveMessages));
                thrMessaging.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }
            
        }

        private void ReceiveMessages()
        {
            // Receive the response from the server
            srReceiver = new StreamReader(tcpServer.GetStream());
            // If the first character of the response is 1, connection was successful
            string ConResponse = srReceiver.ReadLine();
            // If the first character is a 1, connection was successful
            if (ConResponse[0] == '1')
            {
                // Update the form to tell it we are now connected
                this.Dispatcher.Invoke(new UpdateLogCallback(this.UpdateLog), new object[] { "Connected Successfully!" });
            }
            else // If the first character is not a 1 (probably a 0), the connection was unsuccessful
            {
                string Reason = "Not Connected: ";
                // Extract the reason out of the response message. The reason starts at the 3rd character
                Reason += ConResponse.Substring(2, ConResponse.Length - 2);
                // Update the form with the reason why we couldn't connect
                this.Dispatcher.Invoke(new CloseConnectionCallback(this.CloseConnection), new object[] { Reason });
                // Exit the method
                return;
            }
            // While we are successfully connected, read incoming lines from the server
            while (Connected)
            {
                try
                {
                    // Show the messages in the log TextBox
                    this.Dispatcher.Invoke(new UpdateLogCallback(this.UpdateLog), new object[] { srReceiver.ReadLine() });
                }
                catch (Exception)
                {
                    Connected = false;
                }
                
            }
        }

        // This method is called from a different thread in order to update the log TextBox
        private void UpdateLog(string strMessage)
        {
            // Append text also scrolls the TextBox to the bottom each time
            ChatSessionTextBox.AppendText(strMessage + "\r\n");
            ChatSessionTextBox.ScrollToEnd();
        }

        // Closes a current connection
        private void CloseConnection(string Reason)
        {
            // Show the reason why the connection is ending
            ChatSessionTextBox.AppendText(Reason + "\r\n");
            ChatSessionTextBox.ScrollToEnd();
            // Enable and disable the appropriate controls on the form
            SendButton.IsEnabled = false;
            ConncetButton.Content = "Connect";

            // Close the objects
            Connected = false;
            swSender.Close();
            srReceiver.Close();
            tcpServer.Close();
        }

        private void SendButton_Click(object sender, RoutedEventArgs e)
        {
            SendMessage();
        }

        private void MessageTextBox_KeyDown_1(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Return || e.Key == Key.Enter)
            {
                SendMessage();
            }
        }

        // Sends the message typed in to the server
        private void SendMessage()
        {
            try
            {
                swSender.WriteLine(MessageTextBox.Text);
                swSender.Flush();

                MessageTextBox.Text = "";
            }
            catch (Exception ex)
            {
                CloseConnection(ex.Message);
            }
            
        }

        private void SetFontButton_Click(object sender, RoutedEventArgs e)
        {
            var fontDialog = new System.Windows.Forms.FontDialog();
            fontDialog.ShowColor = true;
            fontDialog.ShowEffects = true;
            
            //Open's a new FontDialog which is part of System.Windows.Forms
            if (fontDialog.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                //Converter needed to convert beteween wpf and Windows Forms Standards
                FontFamilyConverter ffc = new FontFamilyConverter();

                var font = fontDialog.Font;

                //Get the fontsize
                this.ChatSessionTextBox.FontSize = font.Size;

                //Get the fontcolor
                var color = fontDialog.Color;
                var brush = new SolidColorBrush();

                //Convert the color to a System.Windows.Media.Color and store it in the SolidColorBrush brush
                var mcolor = System.Windows.Media.Color.FromArgb(color.A, color.R, color.G, color.B);
                brush.Color = mcolor;

                //Set the Foreground 
                this.ChatSessionTextBox.Foreground = brush;
                
                //Set the FontFamily
                this.ChatSessionTextBox.FontFamily = (FontFamily)ffc.ConvertFromString(font.Name);

                //If Bold was checked, set it
                if (font.Bold)
                    ChatSessionTextBox.FontWeight = FontWeights.Bold;
                else
                    ChatSessionTextBox.FontWeight = FontWeights.Normal;

                //If Italic was checked, set it
                if (font.Italic)
                    ChatSessionTextBox.FontStyle = FontStyles.Italic;
                else
                    ChatSessionTextBox.FontStyle = FontStyles.Normal;
            }
        }

        private void SetBackgroundButton_Click(object sender, RoutedEventArgs e)
        {
            var colorDialog = new System.Windows.Forms.ColorDialog();

            //Open's a new Colordialog which is part of System.Windows.Forms
            if (colorDialog.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                //Get the choosen color
                var color = colorDialog.Color;
                var brush = new SolidColorBrush();

                //Convert it and make it compatible for wpf
                var mcolor = System.Windows.Media.Color.FromArgb(color.A, color.R, color.G, color.B);
                brush.Color = mcolor;

                //Set the backgroundcolor
                this.ChatSessionTextBox.Background = brush;
            }
        }       
    }
}
