﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public struct ControlBuffer : IVehicleControl
    {
        public Boolean IsAccelerating
        {
            get;
            private set;
        }

        public Boolean IsDecelerating
        {
            get;
            private set;
        }

        public Boolean IsTurningLeft
        {
            get;
            private set;
        }

        public Boolean IsTurningRight
        {
            get;
            private set;
        }

        //Keep track of past states
        //public Boolean WasAccelerating
        //{
        //    get;
        //    private set;
        //}

        //public Boolean WasDecelerating
        //{
        //    get;
        //    private set;
        //}

        //public Boolean WasTurningLeft
        //{
        //    get;
        //    private set;
        //}

        //public Boolean WasTurningRight
        //{
        //    get;
        //    private set;
        //}

        /// <summary>
        /// Set the state (accel, decel, left, right) according to current keyboard
        /// </summary>
        /// <param name="current">Currently active keys</param>
        /// <param name="pressed">Indicates if pressed (t) or released (f)</param>
        public void ChangeBuffer(Keys current, Boolean pressed)
        {
            if (current == Keys.Up)
            {
                IsAccelerating = pressed;
            }
            if (current == Keys.Down)
            {
                IsDecelerating = pressed;
            }
            if (current == Keys.Left)
            {
                IsTurningLeft = pressed;
            }
            if (current == Keys.Right)
            {
                IsTurningRight = pressed;
            }
        }

        /// <summary>
        /// Formats the current state to a string
        /// </summary>
        /// <returns>Current state</returns>
        public override string ToString()
        {
            return String.Format("Left : {0}, Right : {1}, Accelerate : {2}, Decelerate : {3}", IsTurningLeft, IsTurningRight, IsAccelerating, IsDecelerating);
        }
    }
}
