﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;


namespace Projekt
{
    public partial class MyForm : Form
    {
        Car car;
        ControlBuffer control;
        Image renault;

        public MyForm()
        {
            InitializeComponent();
            CarType.Items.Add("Rear Wheel Drive");
            CarType.Items.Add("Front Wheel Drive");
            CarType.Items.Add("Four Wheel Drive");
            CarType.SelectedIndex = 0;
            control = new ControlBuffer();
            renault = Images.Renault;
        }

        void timer_Tick(object sender, EventArgs e)
        {
            if (RaceTrack.Width == 0 || RaceTrack.Height == 0)
                return;
            var bmp = new Bitmap(RaceTrack.Width, RaceTrack.Height);

            var stw = new Stopwatch();
            stw.Start();
       
            car.Control(control);
            car.Update();

            stw.Stop();

            StatsLabel.Text = car.ToString();
            LogicLabel.Text = String.Format("Logic step : {0} ms", stw.Elapsed.TotalMilliseconds);

            using (var g = Graphics.FromImage(bmp))
            {
                DrawTest(g);
            }
            RaceTrack.Image = bmp;
        }

        void DrawTest(Graphics g) 
        {
            var width = RaceTrack.Width;
            var height = RaceTrack.Height;

            //var xfrontleft = (int)car.FrontLeft.Position.X % width;
            //var yfrontleft = (int)car.FrontLeft.Position.Y % height;
            //var xfrontright = (int)car.FrontRight.Position.X % width;
            //var yfrontright = (int)car.FrontRight.Position.Y % height;

            //var xrearleft = (int)car.RearLeft.Position.X % width;
            //var yrearleft = (int)car.RearLeft.Position.Y % height;
            //var xrearright = (int)car.RearRight.Position.X % width;
            //var yrearright = (int)car.RearRight.Position.Y % height;

            //xfrontleft += xfrontleft < 0 ? width : 0;
            //yfrontleft += yfrontleft < 0 ? height : 0;
            //xfrontright += xfrontright < 0 ? width : 0;
            //yfrontright += yfrontright < 0 ? height : 0;
            //xrearleft += xrearleft < 0 ? width : 0;
            //yrearleft += yrearleft < 0 ? height : 0;
            //xrearright += xrearright < 0 ? width : 0;
            //yrearright += yrearright < 0 ? height : 0;

            //g.FillEllipse(Brushes.Red, xfrontleft, (yfrontleft), 5, 5);
            //g.FillEllipse(Brushes.Red, xfrontright, (yfrontright), 5, 5);
            //g.FillEllipse(Brushes.Black, xrearleft, (yrearleft), 5, 5);
            //g.FillEllipse(Brushes.Black, xrearright, (yrearright), 5, 5);
        
            //var x = (Int32)car.Position.X % width;
            //var y = (Int32)car.Position.Y % height;
            //x += x < 0 ? width : 0;
            //y += y < 0 ? height : 0;

            g.TranslateTransform(width / 2, height / 2);
            
            g.ScaleTransform(8f, 8f);

            g.TranslateTransform((float)(car.Position.X + car.Length / 2), (float)(car.Position.Y + car.Width / 2));
            g.RotateTransform(-(float)car.Position.Alignment.Deg);
            g.DrawImage(renault, 0, 0, (Int32)car.Length, (Int32)car.Width);
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            control.ChangeBuffer(e.KeyCode, true);
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            control.ChangeBuffer(e.KeyCode, false);
        }

        private void Start_Click(object sender, EventArgs e)
        {
            var position = new Placement(new Coord(0.0, 0.0), (Angle)0.0);
            var mass = (Double)MassNumber.Value;
            var length = (Double)LengthNumber.Value;
            var width = (Double)WidthNumber.Value;
            var com = (Double)ComNumber.Value;
            var radius = (Double)RadiusNumber.Value;
            var maxAngle = Angle.FromDeg((Double)MaxAngleNumber.Value);
            var maxPower = Power.FromHP(((Double)PowerNumber.Value));
            var dragCoefficient = (Double)DragNumber.Value;
            var airDensity = (Double)AirDensityNumber.Value;
            var gravitationAcceleration = (Double)GravAccNumber.Value;

            var context = new Context(20, airDensity, gravitationAcceleration); //choose 5 updates per second
            
            switch (CarType.SelectedIndex)
            {
                case 0:
                    car = new RWDCar(context, mass, length, width, com, position, radius, maxAngle, WheelType.Profile, dragCoefficient, maxPower);
                    break;
                case 1:
                    car = new FWDCar(context, mass, length, width, com, position, radius, maxAngle, WheelType.Profile, dragCoefficient, maxPower);
                    break;
                case 2:
                    car = new FourWDCar(context, mass, length, width, com, position, radius, maxAngle, WheelType.Profile, dragCoefficient, maxPower);
                    break;
            }

            Timer timer = new Timer();
            timer.Interval = 1;// context.Interval_ms; //Math.Max(1, context.Interval_ms / 10);
            timer.Start();
            timer.Tick += new EventHandler(timer_Tick);
        }

        
    }
}