﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public struct FrictionValue
    {
        Double frictionCoeff;
        Double rollingFrictionCoeff;

        /// <summary>
        /// Instanciates a FrictionValue containing a rolling- and a sliding- friction coefficient
        /// </summary>
        /// <param name="frictionCoeff">sliding friction coefficient</param>
        /// <param name="rollingFrictionCoeff">rolling friction coefficient</param>
        public FrictionValue(Double frictionCoeff, Double rollingFrictionCoeff)
        {
            this.frictionCoeff = frictionCoeff;
            this.rollingFrictionCoeff = rollingFrictionCoeff;
        }

        public Double FrictionCoeff
        {
            get { return frictionCoeff; }
            set
            {
                frictionCoeff = Math.Max(0.0, value);
            }
        }

        public Double RollingFrictionCoeff
        {
            get { return rollingFrictionCoeff; }
            set
            {
                rollingFrictionCoeff = Math.Max(0.0, value);
            }
        }
    }
}
